/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonNativeWritableBufferImplTest {
    @Test
    public void checkCharacters() {
        int i;
        int n = 8;
        int m = 2;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        char ch = 'a';
        for (i = 0; i < n; ++i) {
            char c = ch;
            ch = (char)(ch + 1);
            wbuf.putChar((long)(i * m), c);
        }
        ch = 'a';
        for (i = 0; i < n; ++i) {
            char c = ch;
            ch = (char)(ch + '\u0001');
            Assert.assertEquals((char)wbuf.getChar((long)(i * m)), (char)c);
        }
        ch = 'a';
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            char c = ch;
            ch = (char)(ch + 1);
            wbuf.putChar(c);
        }
        ch = 'a';
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            char c = ch;
            ch = (char)(ch + '\u0001');
            Assert.assertEquals((char)wbuf.getChar(), (char)c);
        }
        char[] cArr = new char[n];
        wbuf.setPosition(0L);
        wbuf.getCharArray(cArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf2 = wmem2.asWritableBuffer();
        wbuf2.putCharArray(cArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkDoubles() {
        int i;
        int n = 8;
        int m = 8;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        double dbl = 1.0;
        for (i = 0; i < n; ++i) {
            double d = dbl;
            dbl = d + 1.0;
            wbuf.putDouble((long)(i * m), d);
        }
        dbl = 1.0;
        for (i = 0; i < n; ++i) {
            double d = dbl;
            dbl = d + 1.0;
            Assert.assertEquals((double)wbuf.getDouble((long)(i * m)), (double)d);
        }
        dbl = 1.0;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            double d = dbl;
            dbl = d + 1.0;
            wbuf.putDouble(d);
        }
        dbl = 1.0;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            double d = dbl;
            dbl = d + 1.0;
            Assert.assertEquals((double)wbuf.getDouble(), (double)d);
        }
        double[] dblArr = new double[n];
        wbuf.setPosition(0L);
        wbuf.getDoubleArray(dblArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf2 = wmem2.asWritableBuffer();
        wbuf2.putDoubleArray(dblArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkFloats() {
        int i;
        int n = 8;
        int m = 4;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        float flt = 1.0f;
        for (i = 0; i < n; ++i) {
            float f = flt;
            flt = f + 1.0f;
            wbuf.putFloat((long)(i * m), f);
        }
        flt = 1.0f;
        for (i = 0; i < n; ++i) {
            float f = flt;
            flt = f + 1.0f;
            Assert.assertEquals((float)wbuf.getFloat((long)(i * m)), (float)f);
        }
        flt = 1.0f;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            float f = flt;
            flt = f + 1.0f;
            wbuf.putFloat(f);
        }
        flt = 1.0f;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            float f = flt;
            flt = f + 1.0f;
            Assert.assertEquals((float)wbuf.getFloat(), (float)f);
        }
        float[] fltArr = new float[n];
        wbuf.setPosition(0L);
        wbuf.getFloatArray(fltArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf2 = wmem2.asWritableBuffer();
        wbuf2.putFloatArray(fltArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkInts() {
        int i;
        int n = 8;
        int m = 4;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        int intg = 1;
        for (i = 0; i < n; ++i) {
            wbuf.putInt((long)(i * m), intg++);
        }
        intg = 1;
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((int)wbuf.getInt((long)(i * m)), (int)intg++);
        }
        intg = 1;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            wbuf.putInt(intg++);
        }
        intg = 1;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((int)wbuf.getInt(), (int)intg++);
        }
        int[] intArr = new int[n];
        wbuf.setPosition(0L);
        wbuf.getIntArray(intArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf2 = wmem2.asWritableBuffer();
        wbuf2.putIntArray(intArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkLongs() {
        int i;
        int n = 8;
        int m = 8;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        long lng = 1L;
        for (i = 0; i < n; ++i) {
            wbuf.putLong((long)(i * m), lng++);
        }
        lng = 1L;
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((long)wbuf.getLong((long)(i * m)), (long)lng++);
        }
        lng = 1L;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            wbuf.putLong(lng++);
        }
        lng = 1L;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((long)wbuf.getLong(), (long)lng++);
        }
        long[] longArr = new long[n];
        wbuf.setPosition(0L);
        wbuf.getLongArray(longArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf2 = wmem2.asWritableBuffer();
        wbuf2.putLongArray(longArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkShorts() {
        int i;
        int n = 8;
        int m = 2;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        short sht = 1;
        for (i = 0; i < n; ++i) {
            short s = sht;
            sht = (short)(sht + 1);
            wbuf.putShort((long)(i * m), s);
        }
        sht = 1;
        for (i = 0; i < n; ++i) {
            short s = sht;
            sht = (short)(sht + 1);
            Assert.assertEquals((short)wbuf.getShort((long)(i * m)), (short)s);
        }
        sht = 1;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            short s = sht;
            sht = (short)(sht + 1);
            wbuf.putShort(s);
        }
        sht = 1;
        wbuf.setPosition(0L);
        for (i = 0; i < n; ++i) {
            short s = sht;
            sht = (short)(sht + 1);
            Assert.assertEquals((short)wbuf.getShort(), (short)s);
        }
        short[] shortArr = new short[n];
        wbuf.setPosition(0L);
        wbuf.getShortArray(shortArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf2 = wmem2.asWritableBuffer();
        wbuf2.putShortArray(shortArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkDuplicate() {
        byte[] bArr = new byte[8];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bArr, (ByteOrder)ByteOrder.BIG_ENDIAN);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        WritableBuffer wdup = wbuf.writableDuplicate();
        Assert.assertEquals((Object)wdup.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
        WritableBuffer wreg = wbuf.writableRegion();
        Assert.assertEquals((Object)wreg.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
    }

    @Test
    public void checkDuplicateZeros() {
        byte[] bArr = new byte[]{};
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bArr, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Buffer buf = wmem.asBuffer();
        Buffer dup = buf.duplicate();
        Assert.assertEquals((Object)dup.getTypeByteOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
        Buffer reg = buf.region();
        Assert.assertEquals((Object)reg.getTypeByteOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
    }
}

