/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;

public final class ReflectUtil {
    static final Class<?> BASE_STATE = ReflectUtil.getClass("org.apache.datasketches.memory.internal.BaseStateImpl");
    static final Class<?> BASE_WRITABLE_MEMORY_IMPL = ReflectUtil.getClass("org.apache.datasketches.memory.internal.BaseWritableMemoryImpl");
    static final Class<?> ALLOCATE_DIRECT_MAP = ReflectUtil.getClass("org.apache.datasketches.memory.internal.AllocateDirectMap");
    static final Class<?> NIO_BITS = ReflectUtil.getClass("org.apache.datasketches.memory.internal.NioBits");
    static final Method CHECK_VALID = ReflectUtil.getMethod(BASE_STATE, "checkValid", null);
    static final Method GET_DIRECT_ALLOCATIONS_COUNT = ReflectUtil.getMethod(NIO_BITS, "getDirectAllocationsCount", null);
    static final Method GET_MAX_DIRECT_BYTE_BUFFER_MEMORY = ReflectUtil.getMethod(NIO_BITS, "getMaxDirectByteBufferMemory", null);
    static final Method GET_NATIVE_BASE_OFFSET = ReflectUtil.getMethod(BASE_STATE, "getNativeBaseOffset", null);
    static final Method GET_RESERVED_MEMORY = ReflectUtil.getMethod(NIO_BITS, "getReservedMemory", null);
    static final Method GET_TOTAL_CAPACITY = ReflectUtil.getMethod(NIO_BITS, "getTotalCapacity", null);
    static final Method GET_UNSAFE_OBJECT = ReflectUtil.getMethod(BASE_STATE, "getUnsafeObject", null);
    static final Method IS_BB_TYPE = ReflectUtil.getMethod(BASE_STATE, "isBBType", null);
    static final Method IS_BUFFER_TYPE = ReflectUtil.getMethod(BASE_STATE, "isBufferType", null);
    static final Method IS_DIRECT_TYPE = ReflectUtil.getMethod(BASE_STATE, "isDirectType", null);
    static final Method IS_DUPLICATE_TYPE = ReflectUtil.getMethod(BASE_STATE, "isDuplicateType", null);
    static final Method IS_FILE_READ_ONLY = ReflectUtil.getMethod(ALLOCATE_DIRECT_MAP, "isFileReadOnly", File.class);
    static final Method IS_HEAP_TYPE = ReflectUtil.getMethod(BASE_STATE, "isHeapType", null);
    static final Method IS_MAP_TYPE = ReflectUtil.getMethod(BASE_STATE, "isMapType", null);
    static final Method IS_NON_NATIVE_TYPE = ReflectUtil.getMethod(BASE_STATE, "isNonNativeType", null);
    static final Method IS_PAGE_ALIGHED = ReflectUtil.getMethod(NIO_BITS, "isPageAligned", null);
    static final Method IS_READ_ONLY_TYPE = ReflectUtil.getMethod(BASE_STATE, "isReadOnlyType", null);
    static final Method IS_REGION_TYPE = ReflectUtil.getMethod(BASE_STATE, "isRegionType", null);
    static final Method PAGE_COUNT = ReflectUtil.getMethod(NIO_BITS, "pageCount", Long.TYPE);
    static final Method PAGE_SIZE = ReflectUtil.getMethod(NIO_BITS, "pageSize", null);
    static final Method RESERVE_MEMORY = ReflectUtil.getMethod(NIO_BITS, "reserveMemory", Long.TYPE, Long.TYPE);
    static final Method UNRESERVE_MEMORY = ReflectUtil.getMethod(NIO_BITS, "unreserveMemory", Long.TYPE, Long.TYPE);
    static final Method WRAP_DIRECT = ReflectUtil.getMethod(BASE_WRITABLE_MEMORY_IMPL, "wrapDirect", Long.TYPE, ByteOrder.class, MemoryRequestServer.class);

    private ReflectUtil() {
    }

    public static Class<?> getClass(String fullyQualifiedBinaryName) {
        try {
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            return scl.loadClass(fullyQualifiedBinaryName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> ownerClass, Class<?> ... parameterTypes) {
        try {
            Constructor<?> ctor = ownerClass.getDeclaredConstructor(parameterTypes);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInstance(Constructor<?> constructor, Object ... initargs) {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(initargs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(Class<?> ownerClass, String fieldName) {
        try {
            Field field = ownerClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Class<?> ownerClass, Field field) {
        try {
            field.setAccessible(true);
            return field.get(ownerClass);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Class<?> ownerClass, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = parameterTypes == null ? ownerClass.getDeclaredMethod(methodName, new Class[0]) : ownerClass.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    static void checkValid(Object target) {
        try {
            CHECK_VALID.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static long getDirectAllocationsCount() {
        try {
            return (Long)GET_DIRECT_ALLOCATIONS_COUNT.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static long getMaxDirectByteBufferMemory() {
        try {
            return (Long)GET_MAX_DIRECT_BYTE_BUFFER_MEMORY.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static long getNativeBaseOffset(Object target) {
        try {
            return (Long)GET_NATIVE_BASE_OFFSET.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static long getReservedMemory() {
        try {
            return (Long)GET_RESERVED_MEMORY.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static long getTotalCapacity() {
        try {
            return (Long)GET_TOTAL_CAPACITY.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static Object getUnsafeObject(Object target) {
        try {
            return GET_UNSAFE_OBJECT.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isBBType(Object target) {
        try {
            return (Boolean)IS_BB_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isBufferType(Object target) {
        try {
            return (Boolean)IS_BUFFER_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isDirectType(Object target) {
        try {
            return (Boolean)IS_DIRECT_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isDuplicateType(Object target) {
        try {
            return (Boolean)IS_DUPLICATE_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isFileReadOnly(File file) {
        try {
            return (Boolean)IS_FILE_READ_ONLY.invoke(null, file);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isHeapType(Object target) {
        try {
            return (Boolean)IS_HEAP_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isMapType(Object target) {
        try {
            return (Boolean)IS_MAP_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isNonNativeType(Object target) {
        try {
            return (Boolean)IS_NON_NATIVE_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isPageAligned() {
        try {
            return (Boolean)IS_PAGE_ALIGHED.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isReadOnlyType(Object target) {
        try {
            return (Boolean)IS_READ_ONLY_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isRegionType(Object target) {
        try {
            return (Boolean)IS_REGION_TYPE.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static int pageCount(long bytes) {
        try {
            return (Integer)PAGE_COUNT.invoke(null, bytes);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static int pageSize() {
        try {
            return (Integer)PAGE_SIZE.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void reserveMemory(long allocationSize, long capacity) {
        try {
            RESERVE_MEMORY.invoke(null, allocationSize, capacity);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void unreserveMemory(long allocationSize, long capacity) {
        try {
            UNRESERVE_MEMORY.invoke(null, allocationSize, capacity);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

