/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.util.ArrayList;
import org.apache.datasketches.memory.internal.Ints;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnsafeUtilTest {
    long testField = 1L;

    @Test
    public void checkJdkString() {
        String jdkVer2;
        int[] p = new int[2];
        for (String jdkVer2 : new String[]{"1.8.0_121", "8", "9", "10", "11", "12", "13"}) {
            int jdkMajor;
            p = UnsafeUtil.parseJavaVersion((String)jdkVer2);
            UnsafeUtil.checkJavaVersion((String)jdkVer2, (int)p[0], (int)p[1]);
            int n = jdkMajor = p[0] == 1 ? p[1] : p[0];
            if (p[0] == 1) {
                Assert.assertTrue((jdkMajor == p[1] ? 1 : 0) != 0);
            }
            if (p[0] <= 1) continue;
            Assert.assertTrue((jdkMajor == p[0] ? 1 : 0) != 0);
        }
        try {
            jdkVer2 = "14.0.4";
            p = UnsafeUtil.parseJavaVersion((String)jdkVer2);
            UnsafeUtil.checkJavaVersion((String)jdkVer2, (int)p[0], (int)p[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            UnsafeUtilTest.println("" + e);
        }
        try {
            jdkVer2 = "1.7.0_80";
            p = UnsafeUtil.parseJavaVersion((String)jdkVer2);
            UnsafeUtil.checkJavaVersion((String)jdkVer2, (int)p[0], (int)p[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            UnsafeUtilTest.println("" + e);
        }
        try {
            jdkVer2 = "1.6.0_65";
            p = UnsafeUtil.parseJavaVersion((String)jdkVer2);
            UnsafeUtil.checkJavaVersion((String)jdkVer2, (int)p[0], (int)p[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            UnsafeUtilTest.println("" + e);
        }
        try {
            jdkVer2 = "b";
            p = UnsafeUtil.parseJavaVersion((String)jdkVer2);
            UnsafeUtil.checkJavaVersion((String)jdkVer2, (int)p[0], (int)p[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            UnsafeUtilTest.println("" + e);
        }
        try {
            jdkVer2 = "";
            p = UnsafeUtil.parseJavaVersion((String)jdkVer2);
            UnsafeUtil.checkJavaVersion((String)jdkVer2, (int)p[0], (int)p[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            UnsafeUtilTest.println("" + e);
        }
    }

    @Test
    public void checkFieldOffset() {
        Assert.assertEquals((long)this.testField, (long)1L);
        long offset = UnsafeUtil.getFieldOffset(this.getClass(), (String)"testField");
        Assert.assertEquals((long)offset, (long)16L);
        try {
            offset = UnsafeUtil.getFieldOffset(this.getClass(), (String)"testField2");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkInts() {
        Ints.checkedCast((long)0x100000000L);
    }

    @Test
    public void checkArrayBaseOffset() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(byte[].class);
        classes.add(int[].class);
        classes.add(long[].class);
        classes.add(float[].class);
        classes.add(double[].class);
        classes.add(boolean[].class);
        classes.add(short[].class);
        classes.add(char[].class);
        classes.add(Object[].class);
        classes.add(byte[][].class);
        for (Class clazz : classes) {
            Assert.assertEquals((long)UnsafeUtil.getArrayBaseOffset((Class)clazz), (long)UnsafeUtil.unsafe.arrayBaseOffset(clazz), (String)clazz.getTypeName());
        }
    }

    @Test
    public void printlnTest() {
        UnsafeUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

