/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import jdk.incubator.foreign.MemorySegment;
import org.apache.datasketches.memory.BufferPositionInvariantsException;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Positional;
import org.apache.datasketches.memory.internal.ResourceImpl;

abstract class PositionalImpl
extends ResourceImpl
implements Positional {
    private long capacity;
    private long start = 0L;
    private long pos = 0L;
    private long end;

    PositionalImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr) {
        super(seg, typeId, memReqSvr);
        this.capacity = this.end = seg.byteSize();
    }

    @Override
    public final PositionalImpl incrementPosition(long increment) {
        long newPos = this.getPosition() + increment;
        PositionalImpl.checkInvariants(this.start, newPos, this.end, this.capacity);
        this.pos = newPos;
        return this;
    }

    @Override
    public final long getEnd() {
        return this.end;
    }

    @Override
    public final long getPosition() {
        return this.pos;
    }

    @Override
    public final long getStart() {
        return this.start;
    }

    @Override
    public final long getRemaining() {
        return this.end - this.pos;
    }

    @Override
    public final boolean hasRemaining() {
        return this.end - this.pos > 0L;
    }

    @Override
    public final PositionalImpl resetPosition() {
        this.pos = this.start;
        return this;
    }

    @Override
    public final PositionalImpl setPosition(long position) {
        PositionalImpl.checkInvariants(this.start, position, this.end, this.capacity);
        this.pos = position;
        return this;
    }

    @Override
    public final PositionalImpl setStartPositionEnd(long start, long position, long end) {
        PositionalImpl.checkInvariants(start, position, end, this.capacity);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    static final void checkInvariants(long start, long pos, long end, long cap) {
        if ((start | pos | end | cap | pos - start | end - pos | cap - end) < 0L) {
            throw new BufferPositionInvariantsException("Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end));
        }
    }
}

