/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.NonNativeValueLayouts;
import org.apache.datasketches.memory.internal.WritableMemoryImpl;

final class NonNativeWritableMemoryImpl
extends WritableMemoryImpl {
    NonNativeWritableMemoryImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr, Arena arena) {
        super(seg, typeId, memReqSvr, arena);
    }

    @Override
    public char getChar(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        NonNativeWritableMemoryImpl.getCharArr(this.seg, offsetBytes, dstArray, dstOffsetChars, lengthChars);
    }

    static void getCharArr(MemorySegment seg, long offsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        long dstOffsetBytes = (long)dstOffsetChars << 1;
        MemorySegment.copy(seg, NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes, dstSeg, ValueLayout.JAVA_CHAR, dstOffsetBytes, lengthChars);
    }

    @Override
    public double getDouble(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        NonNativeWritableMemoryImpl.getDoubleArr(this.seg, offsetBytes, dstArray, dstOffsetDoubles, lengthDoubles);
    }

    static void getDoubleArr(MemorySegment seg, long offsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        long dstOffsetBytes = (long)dstOffsetDoubles << 3;
        MemorySegment.copy(seg, NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes, dstSeg, ValueLayout.JAVA_DOUBLE, dstOffsetBytes, lengthDoubles);
    }

    @Override
    public float getFloat(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        NonNativeWritableMemoryImpl.getFloatArr(this.seg, offsetBytes, dstArray, dstOffsetFloats, lengthFloats);
    }

    static void getFloatArr(MemorySegment seg, long offsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        long dstOffsetBytes = (long)dstOffsetFloats << 2;
        MemorySegment.copy(seg, NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes, dstSeg, ValueLayout.JAVA_FLOAT, dstOffsetBytes, lengthFloats);
    }

    @Override
    public int getInt(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        NonNativeWritableMemoryImpl.getIntArr(this.seg, offsetBytes, dstArray, dstOffsetInts, lengthInts);
    }

    static void getIntArr(MemorySegment seg, long offsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        long dstOffsetBytes = (long)dstOffsetInts << 2;
        MemorySegment.copy(seg, NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes, dstSeg, ValueLayout.JAVA_INT, dstOffsetBytes, lengthInts);
    }

    @Override
    public long getLong(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        NonNativeWritableMemoryImpl.getLongArr(this.seg, offsetBytes, dstArray, dstOffsetLongs, lengthLongs);
    }

    static void getLongArr(MemorySegment seg, long offsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        long dstOffsetBytes = (long)dstOffsetLongs << 3;
        MemorySegment.copy(seg, NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes, dstSeg, ValueLayout.JAVA_LONG, dstOffsetBytes, lengthLongs);
    }

    @Override
    public short getShort(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        NonNativeWritableMemoryImpl.getShortArr(this.seg, offsetBytes, dstArray, dstOffsetShorts, lengthShorts);
    }

    static void getShortArr(MemorySegment seg, long offsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        long dstOffsetBytes = (long)dstOffsetShorts << 1;
        MemorySegment.copy(seg, NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes, dstSeg, ValueLayout.JAVA_SHORT, dstOffsetBytes, lengthShorts);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.seg.set(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffsetChars, int lengthChars) {
        NonNativeWritableMemoryImpl.putCharArr(this.seg, offsetBytes, srcArray, srcOffsetChars, lengthChars);
    }

    static void putCharArr(MemorySegment seg, long offsetBytes, char[] srcArray, int srcOffsetChars, int lengthChars) {
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        long srcOffsetBytes = (long)srcOffsetChars << 1;
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_CHAR, srcOffsetBytes, seg, NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes, lengthChars);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.seg.set(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        NonNativeWritableMemoryImpl.putDoubleArr(this.seg, offsetBytes, srcArray, srcOffsetDoubles, lengthDoubles);
    }

    static void putDoubleArr(MemorySegment seg, long offsetBytes, double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        long srcOffsetBytes = (long)srcOffsetDoubles << 3;
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_DOUBLE, srcOffsetBytes, seg, NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes, lengthDoubles);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.seg.set(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        NonNativeWritableMemoryImpl.putFloatArr(this.seg, offsetBytes, srcArray, srcOffsetFloats, lengthFloats);
    }

    static void putFloatArr(MemorySegment seg, long offsetBytes, float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        long srcOffsetBytes = (long)srcOffsetFloats << 2;
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_FLOAT, srcOffsetBytes, seg, NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes, lengthFloats);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.seg.set(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffsetInts, int lengthInts) {
        NonNativeWritableMemoryImpl.putIntArr(this.seg, offsetBytes, srcArray, srcOffsetInts, lengthInts);
    }

    static void putIntArr(MemorySegment seg, long offsetBytes, int[] srcArray, int srcOffsetInts, int lengthInts) {
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        long srcOffsetBytes = (long)srcOffsetInts << 2;
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_INT, srcOffsetBytes, seg, NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes, lengthInts);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.seg.set(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        NonNativeWritableMemoryImpl.putLongArr(this.seg, offsetBytes, srcArray, srcOffsetLongs, lengthLongs);
    }

    static void putLongArr(MemorySegment seg, long offsetBytes, long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        long srcOffsetBytes = (long)srcOffsetLongs << 3;
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_LONG, srcOffsetBytes, seg, NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes, lengthLongs);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.seg.set(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        NonNativeWritableMemoryImpl.putShortArr(this.seg, offsetBytes, srcArray, srcOffsetShorts, lengthShorts);
    }

    static void putShortArr(MemorySegment seg, long offsetBytes, short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        long srcOffsetBytes = (long)srcOffsetShorts << 1;
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_SHORT, srcOffsetBytes, seg, NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes, lengthShorts);
    }
}

