/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.owb;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.cdise.owb.OpenWebBeansContextControl;
import org.apache.deltaspike.cdise.owb.OwbHelper;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContainerLifecycle;

public class OpenWebBeansContainerControl
implements CdiContainer {
    private static final Logger LOG = Logger.getLogger(OpenWebBeansContainerControl.class.getName());
    private ContainerLifecycle lifecycle;
    private ContextControl ctxCtrl = null;
    private Bean<ContextControl> ctxCtrlBean = null;
    private CreationalContext<ContextControl> ctxCtrlCreationalContext = null;

    public BeanManager getBeanManager() {
        if (this.lifecycle == null) {
            return null;
        }
        return this.lifecycle.getBeanManager();
    }

    public synchronized void boot() {
        this.lifecycle = (ContainerLifecycle)WebBeansContext.currentInstance().getService(ContainerLifecycle.class);
        Object mockServletContextEvent = null;
        if (OpenWebBeansContextControl.isServletApiAvailable()) {
            mockServletContextEvent = OwbHelper.getMockServletContextEvent();
        }
        this.lifecycle.startApplication(mockServletContextEvent);
    }

    public void boot(Map<?, ?> properties) {
        this.boot();
    }

    public synchronized void shutdown() {
        if (this.ctxCtrl != null) {
            try {
                this.ctxCtrl.stopContexts();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.ctxCtrlBean.destroy((Object)this.ctxCtrl, this.ctxCtrlCreationalContext);
            this.ctxCtrl = null;
        }
        if (this.lifecycle != null) {
            Object mockServletContextEvent = null;
            if (OpenWebBeansContextControl.isServletApiAvailable()) {
                mockServletContextEvent = OwbHelper.getMockServletContextEvent();
            }
            this.lifecycle.stopApplication(mockServletContextEvent);
        }
        this.lifecycle = null;
    }

    public synchronized ContextControl getContextControl() {
        if (this.ctxCtrl == null) {
            BeanManager beanManager = this.getBeanManager();
            if (beanManager == null) {
                LOG.warning("If the CDI-container was started by the environment, you can't use this helper.Instead you can resolve ContextControl manually (e.g. via BeanProvider.getContextualReference(ContextControl.class) ). If the container wasn't started already, you have to use CdiContainer#boot before.");
                return null;
            }
            Set beans = beanManager.getBeans(ContextControl.class, new Annotation[0]);
            this.ctxCtrlBean = beanManager.resolve(beans);
            this.ctxCtrlCreationalContext = this.getBeanManager().createCreationalContext(this.ctxCtrlBean);
            this.ctxCtrl = (ContextControl)this.getBeanManager().getReference(this.ctxCtrlBean, ContextControl.class, this.ctxCtrlCreationalContext);
        }
        return this.ctxCtrl;
    }

    public String toString() {
        return "OpenWebBeansContainerControl";
    }
}

