/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ShrinkWrapArchiveUtil {
    private static final Logger LOG = Logger.getLogger(ShrinkWrapArchiveUtil.class.getName());

    private ShrinkWrapArchiveUtil() {
    }

    public static JavaArchive[] getArchives(ClassLoader classLoader, String markerFile, String[] includeIfPackageExists, String[] excludeIfPackageExists, String archiveName) {
        if (classLoader == null) {
            classLoader = ShrinkWrapArchiveUtil.class.getClassLoader();
        }
        try {
            Enumeration<URL> foundFiles = classLoader.getResources(markerFile);
            ArrayList<JavaArchive> archives = new ArrayList<JavaArchive>();
            int numArchives = 0;
            while (foundFiles.hasMoreElements()) {
                String suffix;
                URL foundFile = foundFiles.nextElement();
                LOG.fine("Evaluating Java ClassPath URL " + foundFile.toExternalForm());
                String string = suffix = numArchives == 0 ? "" : Integer.toString(numArchives);
                JavaArchive archive = ShrinkWrapArchiveUtil.createArchive(foundFile, markerFile, includeIfPackageExists, excludeIfPackageExists, archiveName + suffix);
                if (archive == null) continue;
                LOG.info("Test " + ShrinkWrapArchiveUtil.getTestName() + " Adding Java ClassPath URL as JavaArchive " + foundFile.toExternalForm());
                archives.add(archive);
                ++numArchives;
            }
            return archives.toArray(new JavaArchive[archives.size()]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static JavaArchive createArchive(URL foundFile, String markerFile, String[] includeIfPackageExists, String[] excludeIfPackageExists, String archiveName) throws IOException {
        String urlString = foundFile.toString();
        int idx = urlString.lastIndexOf(markerFile);
        String jarUrlPath = ShrinkWrapArchiveUtil.isJarUrl(urlString = urlString.substring(0, idx));
        if (jarUrlPath != null) {
            JavaArchive foundJar = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)new File(URI.create(jarUrlPath)));
            if (excludeIfPackageExists != null) {
                for (String excludePackage : excludeIfPackageExists) {
                    if (!foundJar.contains(excludePackage.replaceAll("\\.", "\\/"))) continue;
                    return null;
                }
            }
            if (includeIfPackageExists != null) {
                for (String includePackage : includeIfPackageExists) {
                    if (!foundJar.contains(includePackage.replaceAll("\\.", "\\/"))) continue;
                    return foundJar;
                }
            }
            return null;
        }
        File f = new File(new URL(ShrinkWrapArchiveUtil.ensureCorrectUrlFormat(urlString)).getFile());
        if (!f.exists() && urlString.contains("%20")) {
            urlString = urlString.replaceAll("%20", " ");
            f = new File(new URL(ShrinkWrapArchiveUtil.ensureCorrectUrlFormat(urlString)).getFile());
        }
        return ShrinkWrapArchiveUtil.addFileArchive(f, includeIfPackageExists, excludeIfPackageExists, archiveName);
    }

    private static JavaArchive addFileArchive(File archiveBasePath, String[] includeIfPackageExists, String[] excludeIfPackageExists, String archiveName) throws IOException {
        if (!archiveBasePath.exists()) {
            return null;
        }
        if (archiveName == null) {
            archiveName = UUID.randomUUID().toString();
        }
        JavaArchive ret = null;
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(archiveName + ".jar"));
        if (includeIfPackageExists == null) {
            ret = javaArchive;
        }
        int basePathLength = archiveBasePath.getAbsolutePath().length() + 1;
        for (File archiveEntry : ShrinkWrapArchiveUtil.collectArchiveEntries(archiveBasePath)) {
            String entryName = archiveEntry.getAbsolutePath().substring(basePathLength);
            if (ShrinkWrapArchiveUtil.excludeIfPackageExists(entryName, excludeIfPackageExists)) continue;
            if (ret == null && ShrinkWrapArchiveUtil.includeIfPackageExists(entryName, includeIfPackageExists)) {
                ret = javaArchive;
            }
            if (entryName.endsWith(".class")) {
                String className = ShrinkWrapArchiveUtil.pathToClassName(entryName.substring(0, entryName.length() - ".class".length()));
                javaArchive.addClass(className);
                continue;
            }
            javaArchive.addAsResource(archiveEntry, entryName.replace('\\', '/'));
        }
        return ret;
    }

    private static List<File> collectArchiveEntries(File archiveBasePath) {
        if (archiveBasePath.isDirectory()) {
            File[] files;
            ArrayList<File> archiveEntries = new ArrayList<File>();
            for (File file : files = archiveBasePath.listFiles()) {
                if (file.isDirectory()) {
                    archiveEntries.addAll(ShrinkWrapArchiveUtil.collectArchiveEntries(file));
                    continue;
                }
                archiveEntries.add(file);
            }
            return archiveEntries;
        }
        return Collections.emptyList();
    }

    private static boolean excludeIfPackageExists(String jarEntryName, String[] excludeOnPackages) {
        if (excludeOnPackages != null) {
            String packageName = ShrinkWrapArchiveUtil.pathToClassName(jarEntryName);
            for (String excludeOnPackage : excludeOnPackages) {
                if (!packageName.startsWith(excludeOnPackage)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean includeIfPackageExists(String jarEntryName, String[] includeOnPackages) {
        if (includeOnPackages == null) {
            return true;
        }
        String packageName = ShrinkWrapArchiveUtil.pathToClassName(jarEntryName);
        for (String includeOnPackage : includeOnPackages) {
            if (!packageName.startsWith(includeOnPackage)) continue;
            return true;
        }
        return false;
    }

    private static String isJarUrl(String urlPath) {
        int jarColon = urlPath.indexOf(58);
        if (urlPath.endsWith("!/") && jarColon > 0) {
            urlPath = urlPath.substring(jarColon + 1, urlPath.length() - 2);
            return urlPath;
        }
        return null;
    }

    private static String ensureCorrectUrlFormat(String url) {
        if (!url.startsWith("file:/")) {
            url = "file:/" + url;
        }
        return url;
    }

    private static String pathToClassName(String pathName) {
        return pathName.replace('/', '.').replace('\\', '.');
    }

    public static String getTestName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String testName = "unknown";
        for (StackTraceElement ste : stackTraceElements) {
            if (!ste.getClassName().contains("Test")) continue;
            testName = ste.getClassName();
            break;
        }
        return testName;
    }
}

