/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.Savepoint;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.am.Utils;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDataSource;

public abstract class Connection
implements java.sql.Connection,
ConnectionCallbackInterface {
    public Agent agent_;
    public DatabaseMetaData databaseMetaData_;
    final WeakHashMap openStatements_ = new WeakHashMap();
    final WeakHashMap CommitAndRollbackListeners_ = new WeakHashMap();
    private SqlWarning warnings_ = null;
    private static final int INVALID_LOCATOR = -1;
    protected final String user_;
    public boolean retrieveMessageText_;
    protected boolean jdbcReadOnly_;
    private int holdability = 1;
    public String databaseName_;
    public String productID_;
    protected EncryptionManager encryptionManager_;
    private Statement setTransactionIsolationStmt = null;
    private Statement getTransactionIsolationStmt = null;
    protected boolean open_ = true;
    private boolean availableForReuse_ = false;
    private static final int TRANSACTION_UNKNOWN = -1;
    private int isolation_ = -1;
    private String currentSchemaName_ = null;
    public boolean autoCommit_ = true;
    protected boolean inUnitOfWork_ = false;
    private boolean accumulated440ForMessageProcFailure_ = false;
    private boolean accumulated444ForMessageProcFailure_ = false;
    private int transactionID_ = 0;
    protected boolean isXAConnection_ = false;
    public static final int XA_T0_NOT_ASSOCIATED = 0;
    public static final int XA_T1_ASSOCIATED = 1;
    private int xaState_ = 0;
    public int xaHostVersion_ = 0;
    public int loginTimeout_;
    public ClientBaseDataSource dataSource_;
    public String serverNameIP_;
    public int portNumber_;
    public int clientSSLMode_ = 0;
    Hashtable clientCursorNameCache_ = new Hashtable();
    public int commBufferSize_ = Short.MAX_VALUE;
    public boolean resetConnectionAtFirstSql_ = false;
    private static String DERBY_TRANSACTION_REPEATABLE_READ = "RS";
    private static String DERBY_TRANSACTION_SERIALIZABLE = "RR";
    private static String DERBY_TRANSACTION_READ_COMMITTED = "CS";
    private static String DERBY_TRANSACTION_READ_UNCOMMITTED = "UR";
    public int dncGeneratedSavepointId_;
    public static final String dncGeneratedSavepointNamePrefix__ = "DNC_GENENERATED_NAME_";
    private CallableLocatorProcedures lobProcs;

    protected Connection(LogWriter logWriter, String string, String string2, ClientBaseDataSource clientBaseDataSource) throws SqlException {
        this.user_ = string;
        this.initConnection(logWriter, clientBaseDataSource);
    }

    protected Connection(LogWriter logWriter, String string, String string2, boolean bl, ClientBaseDataSource clientBaseDataSource) throws SqlException {
        this.user_ = string;
        this.isXAConnection_ = bl;
        this.initConnection(logWriter, clientBaseDataSource);
    }

    protected void initConnection(LogWriter logWriter, ClientBaseDataSource clientBaseDataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(clientBaseDataSource);
        }
        this.databaseName_ = clientBaseDataSource.getDatabaseName();
        String string = clientBaseDataSource.getConnectionAttributes();
        if (clientBaseDataSource.getCreateDatabase() != null) {
            string = string == null ? "create=true" : string + ";create=true";
        }
        if (clientBaseDataSource.getShutdownDatabase() != null) {
            string = string == null ? "shutdown=true" : string + ";shutdown=true";
        }
        if (this.databaseName_ != null && string != null) {
            this.databaseName_ = this.databaseName_ + ";" + string;
        }
        this.retrieveMessageText_ = clientBaseDataSource.getRetrieveMessageText();
        this.loginTimeout_ = clientBaseDataSource.getLoginTimeout();
        this.dataSource_ = clientBaseDataSource;
        this.serverNameIP_ = clientBaseDataSource.getServerName();
        this.portNumber_ = clientBaseDataSource.getPortNumber();
        this.clientSSLMode_ = ClientBaseDataSource.getSSLModeFromString(clientBaseDataSource.getSsl());
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected Connection(LogWriter logWriter, boolean bl, ClientBaseDataSource clientBaseDataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(clientBaseDataSource);
        }
        this.isXAConnection_ = bl;
        this.user_ = "APP";
        this.databaseName_ = clientBaseDataSource.getDatabaseName();
        this.retrieveMessageText_ = clientBaseDataSource.getRetrieveMessageText();
        this.loginTimeout_ = clientBaseDataSource.getLoginTimeout();
        this.dataSource_ = clientBaseDataSource;
        this.serverNameIP_ = clientBaseDataSource.getServerName();
        this.portNumber_ = clientBaseDataSource.getPortNumber();
        this.clientSSLMode_ = ClientBaseDataSource.getSSLModeFromString(clientBaseDataSource.getSsl());
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected void resetConnection(LogWriter logWriter) throws SqlException {
        this.clearWarningsX();
        this.encryptionManager_ = null;
        this.currentSchemaName_ = this.user_;
        this.autoCommit_ = true;
        this.inUnitOfWork_ = false;
        this.holdability = 1;
        this.agent_.resetAgent(this, logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
    }

    protected Connection(LogWriter logWriter, int n, String string, int n2, String string2, Properties properties) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(string, n2, string2, properties);
        }
        this.databaseName_ = string2;
        this.user_ = ClientDataSource.getUser(properties);
        this.retrieveMessageText_ = ClientDataSource.getRetrieveMessageText(properties);
        this.loginTimeout_ = n;
        this.serverNameIP_ = string;
        this.portNumber_ = n2;
        this.clientSSLMode_ = ClientDataSource.getClientSSLMode(properties);
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        if (!this.open_) {
            return;
        }
        this.agent_.disconnectEvent();
        super.finalize();
    }

    public synchronized java.sql.Statement createStatement() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "createStatement");
            }
            Statement statement = this.createStatementX(1003, 1007, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", statement);
            }
            return statement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", string);
            }
            PreparedStatement preparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
            }
            return preparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized PreparedStatement preparePositionedUpdateStatement(String string, Section section) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.newPositionedUpdatePreparedStatement_(string, section);
        preparedStatement.flowPrepareDescribeInputOutput();
        return preparedStatement;
    }

    public synchronized java.sql.CallableStatement prepareCall(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", string);
            }
            CallableStatement callableStatement = this.prepareCallX(string, 1003, 1007, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", callableStatement);
            }
            return callableStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    synchronized PreparedStatement prepareDynamicCatalogQuery(String string) throws SqlException {
        PreparedStatement preparedStatement = this.newPreparedStatement_(string, 1003, 1007, this.holdability(), 2, null, null);
        preparedStatement.isCatalogQuery_ = true;
        preparedStatement.prepare();
        this.openStatements_.put(preparedStatement, null);
        return preparedStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "nativeSQL", string);
            }
            String string2 = this.nativeSQLX(string);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "nativeSQL", string2);
            }
            return string2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized String nativeSQLX(String string) throws SqlException {
        this.checkForClosedConnection();
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ067.S"));
        }
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.lastIndexOf("}") >= 0) {
            return string2.substring(1, string2.lastIndexOf("}"));
        }
        return string2;
    }

    protected abstract boolean allowLocalCommitRollback_() throws SqlException;

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setAutoCommit", bl);
            }
            this.checkForClosedConnection();
            if (!this.allowLocalCommitRollback_()) {
                if (bl) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("2D521.S.1"));
                }
            } else {
                if (bl == this.autoCommit_) {
                    return;
                }
                if (this.inUnitOfWork_) {
                    this.flowCommit();
                }
            }
            this.autoCommit_ = bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getAutoCommit", this.autoCommit_);
            }
            if (!this.allowLocalCommitRollback_()) {
                return false;
            }
            return this.autoCommit_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized void commit() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "commit");
            }
            this.checkForClosedConnection();
            this.checkForInvalidXAStateOnCommitOrRollback();
            this.flowCommit();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void checkForInvalidXAStateOnCommitOrRollback() throws SqlException {
        if (!this.allowLocalCommitRollback_()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("2D521.S.2"));
        }
    }

    public void flowCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeCommit();
            this.agent_.flowOutsideUOW();
            this.readCommit();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeCommit();
            this.agent_.flow(null);
            this.readCommit();
            this.agent_.endReadChain();
        }
    }

    public boolean flowAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.flowCommit();
            return true;
        }
        return false;
    }

    public boolean willAutoCommitGenerateFlow() throws SqlException {
        if (!this.autoCommit_) {
            return false;
        }
        return this.allowLocalCommitRollback_();
    }

    void writeAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.writeCommit();
        }
    }

    public void writeCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.writeXACommit_();
        } else {
            this.writeLocalCommit_();
        }
    }

    void readAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.readCommit();
        }
    }

    public void readCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.readXACommit_();
        } else {
            this.readLocalCommit_();
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "rollback");
            }
            this.checkForClosedConnection();
            this.checkForInvalidXAStateOnCommitOrRollback();
            this.flowRollback();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    protected void flowRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeRollback();
            this.agent_.flowOutsideUOW();
            this.readRollback();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeRollback();
            this.agent_.flow(null);
            this.readRollback();
            this.agent_.endReadChain();
        }
    }

    public void writeRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.writeXARollback_();
        } else {
            this.writeLocalRollback_();
        }
    }

    public void readRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.readLocalXARollback_();
        } else {
            this.readLocalRollback_();
        }
    }

    public synchronized void close() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "close");
        }
        this.closeX();
    }

    void checkForTransactionInProgress() throws SqlException {
        if (this.transactionInProgress() && !this.allowCloseInUOW_()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("25001"));
        }
    }

    public boolean transactionInProgress() {
        return !this.autoCommit_ && this.inUnitOfWork_;
    }

    public synchronized void closeX() throws SQLException {
        if (!this.open_) {
            return;
        }
        this.closeResourcesX();
    }

    public synchronized void closeResources() throws SQLException {
        if (this.open_ || !this.open_ && this.availableForReuse_) {
            this.availableForReuse_ = false;
            this.closeResourcesX();
        }
    }

    private void closeResourcesX() throws SQLException {
        try {
            this.checkForTransactionInProgress();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        this.resetConnectionAtFirstSql_ = false;
        SQLException sQLException = null;
        if (this.setTransactionIsolationStmt != null) {
            try {
                this.setTransactionIsolationStmt.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        this.setTransactionIsolationStmt = null;
        if (this.getTransactionIsolationStmt != null) {
            try {
                this.getTransactionIsolationStmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException = Utils.accumulateSQLException(sQLException3, sQLException);
            }
        }
        this.getTransactionIsolationStmt = null;
        try {
            this.flowClose();
        }
        catch (SqlException sqlException) {
            sQLException = Utils.accumulateSQLException(sqlException.getSQLException(), sQLException);
        }
        this.markClosed(false);
        try {
            this.agent_.close();
        }
        catch (SqlException sqlException) {
            throw Utils.accumulateSQLException(sqlException.getSQLException(), sQLException);
        }
    }

    protected abstract boolean isGlobalPending_();

    public synchronized void closeForReuse(boolean bl) throws SqlException {
        if (!this.open_) {
            return;
        }
        this.resetConnectionAtFirstSql_ = false;
        SqlException sqlException = null;
        try {
            this.flowClose();
        }
        catch (SqlException sqlException2) {
            sqlException = sqlException2;
        }
        if (this.open_) {
            this.markClosedForReuse(bl);
        }
        if (sqlException != null) {
            throw sqlException;
        }
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.writeCloseStatements();
        }
        if (this.autoCommit_) {
            this.writeAutoCommit();
        }
        this.agent_.flowOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.readCloseStatements();
        }
        if (this.autoCommit_) {
            this.readAutoCommit();
        }
        this.agent_.endReadChain();
    }

    protected abstract void markClosed_();

    public void markClosed(boolean bl) {
        this.open_ = false;
        this.inUnitOfWork_ = false;
        if (!bl) {
            this.markStatementsClosed();
        }
        this.CommitAndRollbackListeners_.clear();
        this.markClosed_();
    }

    private void markClosedForReuse(boolean bl) {
        this.availableForReuse_ = true;
        this.markClosed(bl);
    }

    private void markStatementsClosed() {
        Set set = this.openStatements_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            statement.markClosed();
            iterator.remove();
        }
    }

    private void writeCloseStatements() throws SqlException {
        Set set = this.openStatements_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((Statement)iterator.next()).writeClose(false);
        }
    }

    private void readCloseStatements() throws SqlException {
        Set set = this.openStatements_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((Statement)iterator.next()).readClose(false);
        }
    }

    public boolean isPhysicalConnClosed() {
        return !this.open_ && !this.availableForReuse_;
    }

    public boolean isClosed() {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.open_);
        }
        return !this.open_;
    }

    public boolean isClosedX() {
        return !this.open_;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTransactionIsolation", n);
        }
        try {
            this.checkForClosedConnection();
            this.setTransactionIsolationX(n);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void setTransactionIsolationX(int n) throws SqlException {
        String string = null;
        switch (n) {
            case 4: {
                string = DERBY_TRANSACTION_REPEATABLE_READ;
                break;
            }
            case 2: {
                string = DERBY_TRANSACTION_READ_COMMITTED;
                break;
            }
            case 8: {
                string = DERBY_TRANSACTION_SERIALIZABLE;
                break;
            }
            case 1: {
                string = DERBY_TRANSACTION_READ_UNCOMMITTED;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ045.S"), new Integer(n));
            }
        }
        if (this.setTransactionIsolationStmt == null || !this.setTransactionIsolationStmt.openOnClient_ || !this.setTransactionIsolationStmt.openOnServer_) {
            this.setTransactionIsolationStmt = this.createStatementX(1003, 1007, this.holdability());
        }
        try {
            this.setTransactionIsolationStmt.executeUpdate("SET CURRENT ISOLATION = " + string);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        this.completeLocalCommit();
    }

    protected abstract boolean supportsSessionDataCaching();

    protected abstract boolean serverSupportsLocators();

    public int getTransactionIsolation() throws SQLException {
        boolean bl = this.autoCommit_;
        ResultSet resultSet = null;
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTransactionIsolation", this.isolation_);
            }
            if (this.isolation_ != -1) {
                int n = this.isolation_;
                return n;
            }
            this.autoCommit_ = false;
            if (this.getTransactionIsolationStmt == null || !this.getTransactionIsolationStmt.openOnClient_ || !this.getTransactionIsolationStmt.openOnServer_) {
                this.getTransactionIsolationStmt = this.createStatementX(1003, 1007, this.holdability());
            }
            boolean bl2 = this.inUnitOfWork_;
            resultSet = this.getTransactionIsolationStmt.executeQuery("values current isolation");
            resultSet.next();
            String string = resultSet.getString(1);
            int n = this.translateIsolation(string);
            if (this.isolation_ == -1 && this.supportsSessionDataCaching()) {
                this.isolation_ = n;
            }
            resultSet.close();
            this.inUnitOfWork_ = bl2;
            int n2 = n;
            return n2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        finally {
            this.autoCommit_ = bl;
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public int getTransactionID() {
        return this.transactionID_;
    }

    public String getCurrentSchemaName() throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.currentSchemaName_ == null) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCurrentSchemaName() executes query");
            }
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("VALUES CURRENT SCHEMA");
            resultSet.next();
            String string = resultSet.getString(1);
            resultSet.close();
            statement.close();
            return string;
        }
        return this.currentSchemaName_;
    }

    private int translateIsolation(String string) {
        if (string.compareTo(DERBY_TRANSACTION_REPEATABLE_READ) == 0) {
            return 4;
        }
        if (string.compareTo(DERBY_TRANSACTION_SERIALIZABLE) == 0) {
            return 8;
        }
        if (string.compareTo(DERBY_TRANSACTION_READ_COMMITTED) == 0) {
            return 2;
        }
        if (string.compareTo(DERBY_TRANSACTION_READ_UNCOMMITTED) == 0) {
            return 1;
        }
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    public synchronized void clearWarnings() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings");
            }
            this.checkForClosedConnection();
            this.clearWarningsX();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void clearWarningsX() throws SqlException {
        this.warnings_ = null;
        this.accumulated440ForMessageProcFailure_ = false;
        this.accumulated444ForMessageProcFailure_ = false;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMetaData", this.databaseMetaData_);
            }
            return this.databaseMetaData_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setReadOnly", bl);
            }
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isReadOnly", this.jdbcReadOnly_);
            }
            return false;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setCatalog", string);
            }
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCatalog", (Object)null);
            }
            return null;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized java.sql.Statement createStatement(int n, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "createStatement", n, n2);
            }
            Statement statement = this.createStatementX(n, n2, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", statement);
            }
            return statement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, n, n2);
            }
            PreparedStatement preparedStatement = this.prepareStatementX(string, n, n2, this.holdability(), 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
            }
            return preparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized java.sql.CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", (Object)string, n, n2);
            }
            CallableStatement callableStatement = this.prepareCallX(string, n, n2, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", callableStatement);
            }
            return callableStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized CallableStatement prepareMessageProc(String string) throws SqlException {
        this.checkForClosedConnection();
        CallableStatement callableStatement = this.prepareCallX(string, 1003, 1007, this.holdability());
        return callableStatement;
    }

    private int downgradeResultSetType(int n) {
        if (n == 1005) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J10")));
            return 1004;
        }
        return n;
    }

    public Map getTypeMap() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTypeMap");
            }
            this.checkForClosedConnection();
            HashMap hashMap = new HashMap();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTypeMap", hashMap);
            }
            return hashMap;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setTypeMap", map);
            }
            this.checkForClosedConnection();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "setTypeMap");
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized void setHoldability(int n) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setHoldability", n);
            }
            this.checkForClosedConnection();
            if (this.isXAConnection_ && this.xaState_ == 1 && n == 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ05C.S"));
            }
            this.holdability = n;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getHoldability", this.holdability());
            }
            return this.holdability();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized java.sql.Savepoint setSavepoint() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setSavepoint");
            }
            this.checkForClosedConnection();
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ010.S"));
            }
            if (++this.dncGeneratedSavepointId_ < 0) {
                this.dncGeneratedSavepointId_ = 1;
            }
            Savepoint savepoint = this.setSavepointX(new Savepoint(this.agent_, this.dncGeneratedSavepointId_));
            return savepoint;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized java.sql.Savepoint setSavepoint(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setSavepoint", string);
            }
            this.checkForClosedConnection();
            if (string == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ011.S"));
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ010.S"));
            }
            Savepoint savepoint = this.setSavepointX(new Savepoint(this.agent_, string));
            return savepoint;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private Savepoint setSavepointX(Savepoint savepoint) throws SQLException {
        Statement statement = null;
        try {
            String string;
            statement = this.createStatementX(1003, 1007, this.holdability());
            try {
                string = savepoint.getSavepointName();
            }
            catch (SQLException sQLException) {
                string = dncGeneratedSavepointNamePrefix__ + savepoint.getSavepointId();
            }
            String string2 = "SAVEPOINT \"" + string + "\" ON ROLLBACK RETAIN CURSORS";
            statement.executeX(string2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        finally {
            if (statement != null) {
                try {
                    statement.closeX();
                }
                catch (SqlException sqlException) {}
            }
        }
        return savepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(java.sql.Savepoint savepoint) throws SQLException {
        try {
            int n = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "rollback", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("3B502.S"));
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ008.S"));
            }
            try {
                if (this != ((Savepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
                }
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
            }
            Statement statement = null;
            try {
                String string;
                statement = this.createStatementX(1003, 1007, this.holdability());
                try {
                    string = ((Savepoint)savepoint).getSavepointName();
                }
                catch (SQLException sQLException) {
                    string = dncGeneratedSavepointNamePrefix__ + ((Savepoint)savepoint).getSavepointId();
                }
                String string2 = "ROLLBACK TO SAVEPOINT \"" + string + "\"";
                statement.executeX(string2);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.closeX();
                    }
                    catch (SqlException sqlException) {}
                }
                this.xaState_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseSavepoint(java.sql.Savepoint savepoint) throws SQLException {
        try {
            int n = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "releaseSavepoint", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("3B502.S"));
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ008.S"));
            }
            try {
                if (this != ((Savepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
                }
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
            }
            Statement statement = null;
            try {
                String string;
                statement = this.createStatementX(1003, 1007, this.holdability());
                try {
                    string = ((Savepoint)savepoint).getSavepointName();
                }
                catch (SQLException sQLException) {
                    string = dncGeneratedSavepointNamePrefix__ + ((Savepoint)savepoint).getSavepointId();
                }
                String string2 = "RELEASE SAVEPOINT \"" + string + "\"";
                statement.executeX(string2);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.closeX();
                    }
                    catch (SqlException sqlException) {}
                }
                this.xaState_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized java.sql.Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "createStatement", n, n2, n3);
            }
            Statement statement = this.createStatementX(n, n2, n3);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", statement);
            }
            return statement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private Statement createStatementX(int n, int n2, int n3) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        if (this.isXAConnection_ && this.xaState_ == 1 && n3 == 1) {
            n3 = 2;
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J07")));
        }
        Statement statement = this.newStatement_(n, n2, n3);
        statement.cursorAttributesToSendOnPrepare_ = statement.cacheCursorAttributesToSendOnPrepare();
        this.openStatements_.put(statement, null);
        return statement;
    }

    protected void resetStatement(Statement statement) throws SqlException {
        String string = statement.cursorAttributesToSendOnPrepare_;
        this.resetStatement_(statement, statement.resultSetType_, statement.resultSetConcurrency_, statement.resultSetHoldability_);
        statement.cursorAttributesToSendOnPrepare_ = string;
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, n, n2, n3);
            }
            PreparedStatement preparedStatement = this.prepareStatementX(string, n, n2, n3, 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
            }
            return preparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    PreparedStatement prepareStatementX(String string, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        PreparedStatement preparedStatement = this.newPreparedStatement_(string, n, n2, n3, n4, stringArray, nArray);
        preparedStatement.cursorAttributesToSendOnPrepare_ = preparedStatement.cacheCursorAttributesToSendOnPrepare();
        preparedStatement.prepare();
        this.openStatements_.put(preparedStatement, null);
        return preparedStatement;
    }

    protected void resetPrepareStatement(PreparedStatement preparedStatement) throws SqlException {
        String string = preparedStatement.cursorAttributesToSendOnPrepare_;
        this.resetPreparedStatement_(preparedStatement, preparedStatement.sql_, preparedStatement.resultSetType_, preparedStatement.resultSetConcurrency_, preparedStatement.resultSetHoldability_, preparedStatement.autoGeneratedKeys_, preparedStatement.generatedKeysColumnNames_, preparedStatement.generatedKeysColumnIndexes_);
        preparedStatement.cursorAttributesToSendOnPrepare_ = string;
        preparedStatement.prepare();
    }

    public synchronized java.sql.CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", (Object)string, n, n2, n3);
            }
            CallableStatement callableStatement = this.prepareCallX(string, n, n2, n3);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", callableStatement);
            }
            return callableStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    CallableStatement prepareCallX(String string, int n, int n2, int n3) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        CallableStatement callableStatement = this.newCallableStatement_(string, n, n2, n3);
        callableStatement.cursorAttributesToSendOnPrepare_ = callableStatement.cacheCursorAttributesToSendOnPrepare();
        callableStatement.prepare();
        this.openStatements_.put(callableStatement, null);
        return callableStatement;
    }

    protected void resetPrepareCall(CallableStatement callableStatement) throws SqlException {
        String string = callableStatement.cursorAttributesToSendOnPrepare_;
        this.resetCallableStatement_(callableStatement, callableStatement.sql_, callableStatement.resultSetType_, callableStatement.resultSetConcurrency_, callableStatement.resultSetHoldability_);
        callableStatement.cursorAttributesToSendOnPrepare_ = string;
        callableStatement.prepare();
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, n);
            }
            PreparedStatement preparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), n, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
            }
            return preparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, (Object)nArray);
            }
            int n = nArray == null || nArray.length == 0 ? 2 : 1;
            PreparedStatement preparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), n, null, nArray);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
            }
            return preparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, (Object)stringArray);
            }
            int n = stringArray == null || stringArray.length == 0 ? 2 : 1;
            PreparedStatement preparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), n, stringArray, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
            }
            return preparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    protected abstract boolean allowCloseInUOW_();

    protected abstract boolean doCloseStatementsOnClose_();

    public abstract SectionManager newSectionManager(String var1, Agent var2, String var3);

    protected abstract Agent newAgent_(LogWriter var1, int var2, String var3, int var4, int var5) throws SqlException;

    protected abstract DatabaseMetaData newDatabaseMetaData_();

    protected abstract Statement newStatement_(int var1, int var2, int var3) throws SqlException;

    protected abstract void resetStatement_(Statement var1, int var2, int var3, int var4) throws SqlException;

    protected abstract PreparedStatement newPositionedUpdatePreparedStatement_(String var1, Section var2) throws SqlException;

    protected abstract PreparedStatement newPreparedStatement_(String var1, int var2, int var3, int var4, int var5, String[] var6, int[] var7) throws SqlException;

    protected abstract void resetPreparedStatement_(PreparedStatement var1, String var2, int var3, int var4, int var5, int var6, String[] var7, int[] var8) throws SqlException;

    protected abstract CallableStatement newCallableStatement_(String var1, int var2, int var3, int var4) throws SqlException;

    protected abstract void resetCallableStatement_(CallableStatement var1, String var2, int var3, int var4, int var5) throws SqlException;

    public void completeConnect() throws SqlException {
        this.open_ = true;
        this.databaseMetaData_ = this.newDatabaseMetaData_();
        this.agent_.sectionManager_ = this.newSectionManager("NULLID", this.agent_, this.databaseName_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectExit(this);
        }
    }

    public abstract void writeCommitSubstitute_() throws SqlException;

    public abstract void readCommitSubstitute_() throws SqlException;

    public abstract void writeLocalXAStart_() throws SqlException;

    public abstract void readLocalXAStart_() throws SqlException;

    public abstract void writeLocalXACommit_() throws SqlException;

    protected abstract void writeXACommit_() throws SqlException;

    public abstract void readLocalXACommit_() throws SqlException;

    protected abstract void readXACommit_() throws SqlException;

    public abstract void writeLocalCommit_() throws SqlException;

    public abstract void readLocalCommit_() throws SqlException;

    protected abstract void writeXATransactionStart(Statement var1) throws SqlException;

    public void completeLocalCommit() {
        Set set = this.CommitAndRollbackListeners_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            UnitOfWorkListener unitOfWorkListener = (UnitOfWorkListener)iterator.next();
            unitOfWorkListener.completeLocalCommit(iterator);
        }
        this.inUnitOfWork_ = false;
        ++this.transactionID_;
    }

    public abstract void writeLocalRollback_() throws SqlException;

    public abstract void readLocalRollback_() throws SqlException;

    public void completeLocalRollback() {
        Set set = this.CommitAndRollbackListeners_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            UnitOfWorkListener unitOfWorkListener = (UnitOfWorkListener)iterator.next();
            unitOfWorkListener.completeLocalRollback(iterator);
        }
        this.inUnitOfWork_ = false;
        ++this.transactionID_;
    }

    public void completeSpecificRollback(UnitOfWorkListener unitOfWorkListener) {
        Set set = this.CommitAndRollbackListeners_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            UnitOfWorkListener unitOfWorkListener2 = (UnitOfWorkListener)iterator.next();
            if (unitOfWorkListener2 != unitOfWorkListener) continue;
            unitOfWorkListener2.completeLocalRollback(iterator);
            break;
        }
        this.inUnitOfWork_ = false;
    }

    public abstract void writeLocalXARollback_() throws SqlException;

    protected abstract void writeXARollback_() throws SqlException;

    public abstract void readLocalXARollback_() throws SqlException;

    protected abstract void readXARollback_() throws SqlException;

    public void writeTransactionStart(Statement statement) throws SqlException {
        if (this.isXAConnection_) {
            this.writeXATransactionStart(statement);
        }
    }

    public void readTransactionStart() throws SqlException {
        this.completeTransactionStart();
    }

    void completeTransactionStart() {
        this.inUnitOfWork_ = true;
    }

    public void completeAbnormalUnitOfWork() {
        this.completeLocalRollback();
    }

    public void completeAbnormalUnitOfWork(UnitOfWorkListener unitOfWorkListener) {
        this.completeSpecificRollback(unitOfWorkListener);
    }

    public void completeChainBreakingDisconnect() {
        this.open_ = false;
        this.completeLocalRollback();
        this.markStatementsClosed();
    }

    public void completeSqlca(Sqlca sqlca) {
        if (sqlca != null) {
            if (sqlca.getSqlCode() > 0) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            } else if (sqlca.getSqlCode() < 0) {
                this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
            }
        }
    }

    public void completePiggyBackIsolation(int n) {
        this.isolation_ = n;
    }

    public void completePiggyBackSchema(String string) {
        this.currentSchemaName_ = string;
    }

    public abstract void addSpecialRegisters(String var1);

    public synchronized void reset(LogWriter logWriter) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectResetEntry(this, logWriter, this.user_, this.dataSource_);
        }
        try {
            this.reset_(logWriter);
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException(this.agent_, new ClientMessageId("08006.C.1"));
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    public synchronized void lightReset() throws SqlException {
        if (!this.open_ && !this.availableForReuse_) {
            return;
        }
        this.open_ = true;
        this.availableForReuse_ = false;
    }

    protected abstract void reset_(LogWriter var1) throws SqlException;

    protected void completeReset(boolean bl, boolean bl2) throws SqlException {
        this.open_ = true;
        this.completeLocalRollback();
        if (bl2) {
            this.isolation_ = -1;
            Set set = this.openStatements_.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                ((Statement)k).reset(bl2);
            }
        } else if (this.isolation_ != 2) {
            this.setTransactionIsolationX(2);
        }
        if (!bl && this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    CallableLocatorProcedures locatorProcedureCall() {
        if (this.lobProcs == null) {
            this.lobProcs = new CallableLocatorProcedures(this);
        }
        return this.lobProcs;
    }

    protected void checkForClosedConnection() throws SqlException {
        if (!this.open_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"));
        }
        this.agent_.checkForDeferredExceptions();
    }

    public boolean isXAConnection() {
        return this.isXAConnection_;
    }

    public int getXAState() {
        return this.xaState_;
    }

    public void setXAState(int n) {
        this.xaState_ = n;
    }

    public void accumulateWarning(SqlWarning sqlWarning) {
        if (this.warnings_ == null) {
            this.warnings_ = sqlWarning;
        } else {
            this.warnings_.setNextException(sqlWarning);
        }
    }

    public void accumulate440WarningForMessageProcFailure(SqlWarning sqlWarning) {
        if (!this.accumulated440ForMessageProcFailure_) {
            this.accumulateWarning(sqlWarning);
            this.accumulated440ForMessageProcFailure_ = true;
        }
    }

    public void accumulate444WarningForMessageProcFailure(SqlWarning sqlWarning) {
        if (!this.accumulated444ForMessageProcFailure_) {
            this.accumulateWarning(sqlWarning);
            this.accumulated444ForMessageProcFailure_ = true;
        }
    }

    public int getServerVersion() {
        return this.databaseMetaData_.productLevel_.versionLevel_;
    }

    public void setInUnitOfWork(boolean bl) {
        this.inUnitOfWork_ = bl;
    }

    final int holdability() {
        if (this.isXAConnection_ && this.xaState_ == 1) {
            return 2;
        }
        return this.holdability;
    }

    public Clob createClob() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "createClob");
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        int n = -1;
        Clob clob = null;
        try {
            n = this.locatorProcedureCall().clobCreateLocator();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        clob = n != -1 ? new Clob(this.agent_, n) : new Clob(this.agent_, "");
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createClob", clob);
        }
        return clob;
    }

    public Blob createBlob() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "createBlob");
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        int n = -1;
        Blob blob = null;
        try {
            n = this.locatorProcedureCall().blobCreateLocator();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        blob = n != -1 ? new Blob(this.agent_, n) : new Blob(new byte[0], this.agent_, 0);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createBlob", blob);
        }
        return blob;
    }
}

