/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BatchUpdateException;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.CrossConverters;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.ParameterMetaData;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Types;
import org.apache.derby.jdbc.ClientDriver;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialPreparedStatement_ = null;
    public String sql_;
    public boolean outputRegistered_ = false;
    public Object[] parameters_;
    boolean[] parameterSet_;
    boolean[] parameterRegistered_;
    public ColumnMetaData parameterMetaData_;
    private ArrayList parameterTypeList;
    String positionedUpdateCursorName_ = null;
    protected final ClientPooledConnection pooledConnection_;
    boolean listenToUnitOfWork_ = false;

    void setInput(int n, Object object) {
        this.parameters_[n - 1] = object;
        this.parameterSet_[n - 1] = true;
    }

    private void initPreparedStatement() {
        this.materialPreparedStatement_ = null;
        this.sql_ = null;
        this.outputRegistered_ = false;
        this.parameters_ = null;
        this.parameterSet_ = null;
        this.parameterRegistered_ = null;
        this.parameterMetaData_ = null;
        this.parameterTypeList = null;
        this.isAutoCommittableStatement_ = true;
        this.isPreparedStatement_ = true;
    }

    protected void initResetPreparedStatement() {
        this.outputRegistered_ = false;
        this.isPreparedStatement_ = true;
        this.resetParameters();
    }

    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetPrepareStatement(this);
        } else {
            super.initResetPreparedStatement();
            this.initResetPreparedStatement();
        }
    }

    void resetForReuse() throws SqlException {
        this.resetParameters();
        super.resetForReuse();
    }

    private void resetParameters() {
        if (this.parameterMetaData_ != null) {
            Arrays.fill(this.parameters_, null);
            Arrays.fill(this.parameterSet_, false);
            Arrays.fill(this.parameterRegistered_, false);
        }
    }

    public PreparedStatement(Agent agent, Connection connection, String string, Section section, ClientPooledConnection clientPooledConnection) throws SqlException {
        super(agent, connection);
        this.isPoolable = true;
        this.initPreparedStatement(string, section);
        this.pooledConnection_ = clientPooledConnection;
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String string, Section section) throws SqlException {
        super.resetStatement(agent, connection);
        this.initPreparedStatement();
        this.initPreparedStatement(string, section);
    }

    private void initPreparedStatement(String string, Section section) throws SqlException {
        this.sql_ = string;
        this.isPreparedStatement_ = true;
        this.parseSqlAndSetSqlModes(this.sql_);
        this.section_ = section;
    }

    public PreparedStatement(Agent agent, Connection connection, String string, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray, ClientPooledConnection clientPooledConnection) throws SqlException {
        super(agent, connection, n, n2, n3, n4, stringArray, nArray);
        this.isPoolable = true;
        this.initPreparedStatement(string);
        this.pooledConnection_ = clientPooledConnection;
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String string, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        super.resetStatement(agent, connection, n, n2, n3, n4, stringArray, nArray);
        this.initPreparedStatement();
        this.initPreparedStatement(string);
    }

    private void initPreparedStatement(String string) throws SqlException {
        String[] stringArray;
        this.sql_ = super.escape(string);
        this.parseSqlAndSetSqlModes(this.sql_);
        this.isPreparedStatement_ = true;
        String string2 = null;
        if ((this.sqlUpdateMode_ == 64 || this.sqlUpdateMode_ == 128) && (stringArray = this.extractCursorNameFromWhereCurrentOf(this.sql_)) != null) {
            string2 = stringArray[0];
            this.sql_ = stringArray[1];
        }
        if (string2 != null) {
            this.positionedUpdateCursorName_ = string2;
            this.section_ = this.agent_.sectionManager_.getPositionedUpdateSection(string2, false);
            if (this.section_ == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ114.S"), string2);
            }
            if (this.section_.getClientCursorName() != null && string2.compareTo(this.section_.getClientCursorName()) == 0) {
                this.sql_ = this.substituteClientCursorNameWithServerCursorName(this.sql_, this.section_);
            }
        } else {
            this.section_ = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
        }
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String string, Section section, ColumnMetaData columnMetaData, ColumnMetaData columnMetaData2) throws SqlException {
        this.resetPreparedStatement(agent, connection, string, section);
        this.initPreparedStatement(columnMetaData, columnMetaData2);
    }

    private void initPreparedStatement(ColumnMetaData columnMetaData, ColumnMetaData columnMetaData2) throws SqlException {
        this.isPreparedStatement_ = true;
        this.parameterMetaData_ = columnMetaData;
        this.resultSetMetaData_ = columnMetaData2;
        if (this.parameterMetaData_ != null) {
            this.parameters_ = new Object[this.parameterMetaData_.columns_];
            this.parameterSet_ = new boolean[this.parameterMetaData_.columns_];
            this.parameterRegistered_ = new boolean[this.parameterMetaData_.columns_];
        }
    }

    void prepare() throws SqlException {
        try {
            this.flowPrepareDescribeInputOutput();
        }
        catch (SqlException sqlException) {
            this.markClosed();
            throw sqlException;
        }
    }

    public boolean execute(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", string);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String)").getSQLException();
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeQuery", string);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeQuery(String)").getSQLException();
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", string);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeUpdate(String)").getSQLException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet executeQuery() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeQuery");
                }
                ResultSet resultSet = this.executeQueryX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeQuery", resultSet);
                }
                return resultSet;
            }
        }
        catch (SqlException sqlException) {
            this.checkStatementValidity(sqlException);
            throw sqlException.getSQLException();
        }
    }

    ResultSet executeQueryX() throws SqlException {
        this.flowExecute(1);
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate");
                }
                int n = this.executeUpdateX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            this.checkStatementValidity(sqlException);
            throw sqlException.getSQLException();
        }
    }

    private int executeUpdateX() throws SqlException {
        this.flowExecute(2);
        return this.updateCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int n, int n2) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setNull", n, n2);
                }
                this.checkForClosedStatement();
                this.checkForSupportedDataType(n2);
                int n3 = this.getColumnMetaDataX().getColumnType(n);
                if (!PossibleTypes.getPossibleTypesForNull(n3).checkType(n2)) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, n2, n3);
                }
                this.setNullX(n, n2);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void setNullX(int n, int n2) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = n2;
        if (!this.parameterMetaData_.nullable_[n - 1]) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("23502"), new Integer(n));
        }
        this.setInput(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int n, int n2, String string) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setNull", n, n2, (Object)string);
            }
            this.setNull(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBoolean", n, bl);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 16, n2);
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = -7;
                this.setInput(n, new Short((short)(bl ? 1 : 0)));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(int n, byte by) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setByte", n, by);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, -6, n2);
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = -6;
                this.setInput(n, new Short(by));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(int n, short s) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setShort", n, s);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 5, n2);
                }
                this.setShortX(n, s);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void setShortX(int n, short s) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = 5;
        this.setInput(n, new Short(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int n, int n2) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n3;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setInt", n, n2);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n3 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 4, n3);
                }
                this.setIntX(n, n2);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void setIntX(int n, int n2) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = 4;
        this.setInput(n, new Integer(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int n, long l) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setLong", n, l);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 4, n2);
                }
                this.setLongX(n, l);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void setLongX(int n, long l) {
        this.parameterMetaData_.clientParamtertype_[n - 1] = -5;
        this.setInput(n, new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(int n, float f) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFloat", n, f);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 6, n2);
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = 7;
                this.setInput(n, new Float(f));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int n, double d) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setDouble", n, d);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 8, n2);
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = 8;
                this.setInput(n, new Double(d));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBigDecimal", n, (Object)bigDecimal);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, -5, n2);
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = 3;
                if (bigDecimal == null) {
                    this.setNull(n, 3);
                    return;
                }
                boolean bl = false;
                this.setInput(n, bigDecimal);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setDate", n, (Object)date, (Object)calendar);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_DATE.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 91, n2);
                }
                this.checkForClosedStatement();
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)"null", (Object)"calendar", "setDate()");
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = 91;
                if (date == null) {
                    this.setNull(n, 91);
                    return;
                }
                this.setInput(n, new DateTimeValue(date, calendar));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setTime", n, (Object)time);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_TIME.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 92, n2);
                }
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)"null", (Object)"calendar", "setTime()");
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = 92;
                if (time == null) {
                    this.setNull(n, 92);
                    return;
                }
                this.setInput(n, new DateTimeValue(time, calendar));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", n, (Object)timestamp);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_TIMESTAMP.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 93, n2);
                }
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)"null", (Object)"calendar", "setTimestamp()");
                }
                this.parameterMetaData_.clientParamtertype_[n - 1] = 93;
                if (timestamp == null) {
                    this.setNull(n, 93);
                    return;
                }
                this.setInput(n, new DateTimeValue(timestamp, calendar));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int n, String string) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setString", n, (Object)string);
                }
                int n2 = this.getColumnMetaDataX().getColumnType(n);
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_STRING.checkType(n2)) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, 12, n2);
                }
                this.setStringX(n, string);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void setStringX(int n, String string) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = -1;
        if (string == null) {
            this.setNullX(n, -1);
            return;
        }
        this.setInput(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBytes", n, byArray);
                }
                if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_BYTES.checkType(n2 = this.getColumnMetaDataX().getColumnType(n))) {
                    PossibleTypes.throw22005Exception(this.agent_.logWriter_, -3, n2);
                }
                this.setBytesX(n, byArray);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setBytesX(int n, byte[] byArray) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = -4;
        if (byArray == null) {
            this.setNullX(n, -4);
            return;
        }
        this.setInput(n, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", n, (Object)"<input stream>", (Object)new Long(l));
                }
                this.checkTypeForSetBinaryStream(n);
                this.checkStreamLength(l);
                this.setBinaryStreamX(n, inputStream, (int)l);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    protected void setBinaryStreamX(int n, InputStream inputStream, int n2) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = 2004;
        if (inputStream == null) {
            this.setNullX(n, 2004);
            return;
        }
        Blob blob = n2 == -1 ? new Blob(this.agent_, inputStream) : new Blob(this.agent_, inputStream, n2);
        this.setInput(n, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", n, (Object)"<input stream>", (Object)new Long(l));
                }
                this.checkTypeForSetAsciiStream(n);
                this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
                if (inputStream == null) {
                    this.setNull(n, -1);
                    return;
                }
                this.checkStreamLength(l);
                this.setInput(n, new Clob(this.agent_, inputStream, "ISO-8859-1", (int)l));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    private void checkStreamLength(long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), (Object)new Long(l), new Integer(Integer.MAX_VALUE)).getSQLException();
        }
        if (l < 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ025.S")).getSQLException();
        }
    }

    private void checkTypeForSetAsciiStream(int n) throws SqlException, SQLException {
        int n2 = this.getColumnMetaDataX().getColumnType(n);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_ASCIISTREAM.checkType(n2)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, -1, n2);
        }
    }

    private void checkTypeForSetBinaryStream(int n) throws SqlException, SQLException {
        int n2 = this.getColumnMetaDataX().getColumnType(n);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_BINARYSTREAM.checkType(n2)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, -3, n2);
        }
    }

    private void checkTypeForSetCharacterStream(int n) throws SqlException, SQLException {
        int n2 = this.getColumnMetaDataX().getColumnType(n);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_CHARACTERSTREAM.checkType(n2)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, -1, n2);
        }
    }

    private void checkTypeForSetBlob(int n) throws SqlException, SQLException {
        int n2 = this.getColumnMetaDataX().getColumnType(n);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_BLOB.checkType(n2)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, 2004, n2);
        }
    }

    private void checkTypeForSetClob(int n) throws SqlException, SQLException {
        int n2 = this.getColumnMetaDataX().getColumnType(n);
        if (!PossibleTypes.POSSIBLE_TYPES_IN_SET_CLOB.checkType(n2)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, 2005, n2);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry(this, "setUnicodeStream", n, "<input stream>", n2);
        }
        throw SQLExceptionFactory.notImplemented("setUnicodeStream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", n, (Object)reader);
            }
            try {
                this.checkTypeForSetCharacterStream(n);
                this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
                if (reader == null) {
                    this.setNull(n, -1);
                    return;
                }
                this.setInput(n, new Clob(this.agent_, reader));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", n, (Object)reader, (Object)new Long(l));
                }
                this.checkTypeForSetCharacterStream(n);
                this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
                if (reader == null) {
                    this.setNull(n, -1);
                    return;
                }
                this.checkStreamLength(l);
                this.setInput(n, new Clob(this.agent_, reader, (int)l));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, java.sql.Blob blob) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setBlob", n, (Object)blob);
                }
                this.checkTypeForSetBlob(n);
                this.setBlobX(n, blob);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setBlobX(int n, java.sql.Blob blob) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = 2004;
        if (blob == null) {
            this.setNullX(n, 2004);
            return;
        }
        this.setInput(n, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, java.sql.Clob clob) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setClob", n, (Object)clob);
                }
                this.checkTypeForSetClob(n);
                this.setClobX(n, clob);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void setClobX(int n, java.sql.Clob clob) throws SqlException {
        this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
        if (clob == null) {
            this.setNullX(n, 2005);
            return;
        }
        this.setInput(n, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setArray", n, (Object)array);
                }
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setRef", n, (Object)ref);
                }
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                int n2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setObject", n, object);
                }
                if ((n2 = this.getColumnMetaDataX().getColumnType(n)) == 2000) {
                    this.setUDTX(n, object);
                } else if (object == null) {
                    this.setNull(n, n2);
                } else if (object instanceof String) {
                    this.setString(n, (String)object);
                } else if (object instanceof Integer) {
                    this.setInt(n, (Integer)object);
                } else if (object instanceof Double) {
                    this.setDouble(n, (Double)object);
                } else if (object instanceof Float) {
                    this.setFloat(n, ((Float)object).floatValue());
                } else if (object instanceof Boolean) {
                    this.setBoolean(n, (Boolean)object);
                } else if (object instanceof Long) {
                    this.setLong(n, (Long)object);
                } else if (object instanceof byte[]) {
                    this.setBytes(n, (byte[])object);
                } else if (object instanceof BigDecimal) {
                    this.setBigDecimal(n, (BigDecimal)object);
                } else if (object instanceof Date) {
                    this.setDate(n, (Date)object);
                } else if (object instanceof Time) {
                    this.setTime(n, (Time)object);
                } else if (object instanceof Timestamp) {
                    this.setTimestamp(n, (Timestamp)object);
                } else if (object instanceof java.sql.Blob) {
                    this.setBlob(n, (java.sql.Blob)object);
                } else if (object instanceof java.sql.Clob) {
                    this.setClob(n, (java.sql.Clob)object);
                } else if (object instanceof Array) {
                    this.setArray(n, (Array)object);
                } else if (object instanceof Ref) {
                    this.setRef(n, (Ref)object);
                } else if (object instanceof Short) {
                    this.setShort(n, (Short)object);
                } else if (object instanceof Byte) {
                    this.setByte(n, (Byte)object);
                } else {
                    this.checkForClosedStatement();
                    this.checkForValidParameterIndex(n);
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ021.S"));
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void setUDTX(int n, Object object) throws SqlException, SQLException {
        int n2;
        int n3 = this.getColumnMetaDataX().getColumnType(n);
        if (n3 != (n2 = 2000)) {
            PossibleTypes.throw22005Exception(this.agent_.logWriter_, n2, n3);
        }
        this.parameterMetaData_.clientParamtertype_[n - 1] = n2;
        if (object == null) {
            this.setNullX(n, n2);
            return;
        }
        ClassNotFoundException classNotFoundException = null;
        String string = object.getClass().getName();
        String string2 = this.getColumnMetaDataX().getColumnClassName(n);
        try {
            Class<?> clazz = Class.forName(string2);
            if (clazz.isInstance(object)) {
                this.setInput(n, object);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XN021.S"), new Object[]{string, string2}, (Throwable)classNotFoundException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setObject", n, object, n2);
                }
                this.checkForClosedStatement();
                this.setObjectX(n, object, n2, 0);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setObject", n, object, n2, n3);
                }
                this.checkForClosedStatement();
                this.setObjectX(n, object, n2, n3);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void setObjectX(int n, Object object, int n2, int n3) throws SqlException {
        int n4;
        this.checkForValidParameterIndex(n);
        this.checkForValidScale(n3);
        this.checkForSupportedDataType(n2);
        if (object == null) {
            this.setNullX(n, n2);
            return;
        }
        this.parameterMetaData_.clientParamtertype_[n - 1] = n4 = CrossConverters.getInputJdbcType(n2);
        object = this.agent_.crossConverters_.setObject(n4, object);
        try {
            if (n2 == 3 || n2 == 2) {
                object = ((BigDecimal)object).setScale(n3, 1);
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), new Object[]{arithmeticException.getClass().getName(), arithmeticException.getMessage()}, (Throwable)arithmeticException);
        }
        try {
            this.setObject(n, object);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "clearParameters");
                }
                this.checkForClosedStatement();
                if (this.parameterMetaData_ != null) {
                    Arrays.fill(this.parameters_, null);
                    Arrays.fill(this.parameterSet_, false);
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute");
                }
                boolean bl = this.executeX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            this.checkStatementValidity(sqlException);
            throw sqlException.getSQLException();
        }
    }

    boolean executeX() throws SqlException {
        this.flowExecute(3);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "addBatch");
                }
                this.checkForClosedStatement();
                this.checkThatAllParametersAreSet();
                if (this.parameterTypeList == null) {
                    this.parameterTypeList = new ArrayList();
                }
                if (this.parameterMetaData_ != null) {
                    Object[] objectArray = new Object[this.parameters_.length];
                    System.arraycopy(this.parameters_, 0, objectArray, 0, this.parameters_.length);
                    this.batch_.add(objectArray);
                    this.parameterTypeList.add(this.parameterMetaData_.clientParamtertype_.clone());
                } else {
                    this.batch_.add(null);
                    this.parameterTypeList.add(null);
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeBatch");
                }
                int[] nArray = null;
                nArray = this.executeBatchX(false);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeBatch", nArray);
                }
                return nArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMetaData");
                }
                ColumnMetaData columnMetaData = this.getMetaDataX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMetaData", columnMetaData);
                }
                return columnMetaData;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private ColumnMetaData getMetaDataX() throws SqlException {
        super.checkForClosedStatement();
        return this.resultSetMetaData_;
    }

    public boolean execute(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, n);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, int)").getSQLException();
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, (Object)stringArray);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, String[])").getSQLException();
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, (Object)nArray);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, int[])").getSQLException();
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", n);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeUpdate(String, int)").getSQLException();
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", stringArray);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "executeUpdate(String, String[])").getSQLException();
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", nArray);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ016.S"), "execute(String, int[])").getSQLException();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setURL", n, (Object)uRL);
        }
        this.jdbc3FeatureNotSupported(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getParameterMetaData");
                }
                ParameterMetaData parameterMetaData = this.getParameterMetaDataX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getParameterMetaData", parameterMetaData);
                }
                return parameterMetaData;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private ParameterMetaData getParameterMetaDataX() throws SqlException {
        ParameterMetaData parameterMetaData = ClientDriver.getFactory().newParameterMetaData(this.getColumnMetaDataX());
        return parameterMetaData;
    }

    private ColumnMetaData getColumnMetaDataX() throws SqlException {
        this.checkForClosedStatement();
        return this.parameterMetaData_ != null ? this.parameterMetaData_ : ClientDriver.getFactory().newColumnMetaData(this.agent_.logWriter_, 0);
    }

    public void writeExecute(Section section, ColumnMetaData columnMetaData, Object[] objectArray, int n, boolean bl, boolean bl2) throws SqlException {
        this.materialPreparedStatement_.writeExecute_(section, columnMetaData, objectArray, n, bl, bl2);
    }

    public void readExecute() throws SqlException {
        this.materialPreparedStatement_.readExecute_();
    }

    private void writeOpenQuery(Section section, int n, int n2, int n3, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        this.materialPreparedStatement_.writeOpenQuery_(section, n, n2, n3, columnMetaData, objectArray);
    }

    public void writeDescribeInput(Section section) throws SqlException {
        this.materialPreparedStatement_.writeDescribeInput_(section);
    }

    public void readDescribeInput() throws SqlException {
        this.materialPreparedStatement_.readDescribeInput_();
    }

    public void completeDescribeInput(ColumnMetaData columnMetaData, Sqlca sqlca) {
        int n = super.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        this.parameterMetaData_ = columnMetaData;
        if (this.sqlMode_ != 2 && this.parameterMetaData_ != null) {
            Arrays.fill(this.parameterMetaData_.sqlxParmmode_, (short)1);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceParameterMetaData(this, this.parameterMetaData_);
        }
    }

    public void writeDescribeOutput(Section section) throws SqlException {
        this.materialPreparedStatement_.writeDescribeOutput_(section);
    }

    public void readDescribeOutput() throws SqlException {
        this.materialPreparedStatement_.readDescribeOutput_();
    }

    public void completeDescribeOutput(ColumnMetaData columnMetaData, Sqlca sqlca) {
        int n = super.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        this.resultSetMetaData_ = columnMetaData;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceResultSetMetaData(this, columnMetaData);
        }
    }

    void writePrepareDescribeInputOutput() throws SqlException {
        this.writePrepareDescribeOutput(this.sql_, this.section_);
        this.writeDescribeInput(this.section_);
    }

    void readPrepareDescribeInputOutput() throws SqlException {
        this.readPrepareDescribeOutput();
        this.readDescribeInput();
        this.completePrepareDescribe();
    }

    void writePrepareDescribeInput() throws SqlException {
        this.writePrepare(this.sql_, this.section_);
        this.writeDescribeInput(this.section_);
    }

    void readPrepareDescribeInput() throws SqlException {
        this.readPrepare();
        this.readDescribeInput();
        this.completePrepareDescribe();
    }

    void completePrepareDescribe() {
        if (this.parameterMetaData_ == null) {
            return;
        }
        this.parameters_ = this.expandObjectArray(this.parameters_, this.parameterMetaData_.columns_);
        this.parameterSet_ = this.expandBooleanArray(this.parameterSet_, this.parameterMetaData_.columns_);
        this.parameterRegistered_ = this.expandBooleanArray(this.parameterRegistered_, this.parameterMetaData_.columns_);
    }

    private Object[] expandObjectArray(Object[] objectArray, int n) {
        if (objectArray == null) {
            Object[] objectArray2 = new Object[n];
            return objectArray2;
        }
        if (objectArray.length < n) {
            Object[] objectArray3 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            return objectArray3;
        }
        return objectArray;
    }

    private boolean[] expandBooleanArray(boolean[] blArray, int n) {
        if (blArray == null) {
            boolean[] blArray2 = new boolean[n];
            return blArray2;
        }
        if (blArray.length < n) {
            boolean[] blArray3 = new boolean[n];
            System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
            return blArray3;
        }
        return blArray;
    }

    void writePrepareDescribeInputOutput(String string, Section section) throws SqlException {
        this.writePrepareDescribeOutput(string, section);
        this.writeDescribeInput(section);
    }

    void flowPrepareDescribeInputOutput() throws SqlException {
        this.agent_.beginWriteChain(this);
        if (this.sqlMode_ == 2) {
            this.writePrepareDescribeInput();
            this.agent_.flow(this);
            this.readPrepareDescribeInput();
            this.agent_.endReadChain();
        } else {
            this.writePrepareDescribeInputOutput();
            this.agent_.flow(this);
            this.readPrepareDescribeInputOutput();
            this.agent_.endReadChain();
        }
    }

    private void flowExecute(int n) throws SqlException {
        boolean bl;
        int n2;
        this.checkForClosedStatement();
        this.checkAutoGeneratedKeysParameters();
        this.clearWarningsX();
        this.checkForAppropriateSqlMode(n, this.sqlMode_);
        this.checkThatAllParametersAreSet();
        this.updateCount_ = this.sqlMode_ == 4 ? 0 : -1;
        if (this.sqlMode_ == 1) {
            this.checkForDuplicateCursorName();
        }
        this.agent_.beginWriteChain(this);
        boolean bl2 = this.writeCloseResultSets(true);
        try {
            n2 = this.parameterMetaData_ != null ? this.parameterMetaData_.getColumnCount() : 0;
            bl = this.resultSetMetaData_ != null && this.resultSetMetaData_.getColumnCount() > 0;
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        ResultSet resultSet = null;
        if (this.doWriteTimeout) {
            this.timeoutArrayList.set(0, "SET STATEMENT_TIMEOUT " + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            this.doWriteTimeout = false;
            bl6 = true;
        }
        switch (this.sqlMode_) {
            case 4: {
                if (this.positionedUpdateCursorName_ != null) {
                    resultSet = this.agent_.sectionManager_.getPositionedUpdateResultSet(this.positionedUpdateCursorName_);
                }
                if (resultSet != null && !resultSet.isRowsetCursor_ && !(bl5 = resultSet.repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete())) {
                    resultSet = null;
                }
                bl3 = this.connection_.willAutoCommitGenerateFlow() && this.isAutoCommittableStatement_;
                boolean bl7 = this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1;
                this.writeExecute(this.section_, this.parameterMetaData_, this.parameters_, n2, bl, bl3 || bl7);
                if (bl7) {
                    this.prepareAutoGeneratedKeysStatement();
                    this.writeOpenQuery(this.preparedStatementForAutoGeneratedKeys_.section_, this.preparedStatementForAutoGeneratedKeys_.fetchSize_, this.preparedStatementForAutoGeneratedKeys_.resultSetType_);
                }
                if (!bl3) break;
                if (this.agent_.accumulatedReadExceptions_ != null) {
                    this.connection_.writeCommitSubstitute_();
                    bl4 = true;
                    break;
                }
                this.connection_.writeCommit();
                break;
            }
            case 1: {
                this.writeOpenQuery(this.section_, this.fetchSize_, this.resultSetType_, n2, this.parameterMetaData_, this.parameters_);
                break;
            }
            case 2: {
                this.writeExecuteCall(this.outputRegistered_, null, this.section_, this.fetchSize_, false, this.resultSetType_, this.parameterMetaData_, this.parameters_);
            }
        }
        this.agent_.flow(this);
        super.readCloseResultSets(true);
        if (bl2) {
            this.connection_.completeTransactionStart();
        }
        this.markResultSetsClosed(true);
        if (bl6) {
            this.readSetSpecialRegister();
        }
        switch (this.sqlMode_) {
            case 4: {
                if (resultSet != null && !resultSet.isRowsetCursor_) {
                    resultSet.readPositioningFetch_();
                } else {
                    this.readExecute();
                    if (this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1) {
                        this.readPrepareAutoGeneratedKeysStatement();
                        this.preparedStatementForAutoGeneratedKeys_.readOpenQuery();
                        this.generatedKeysResultSet_ = this.preparedStatementForAutoGeneratedKeys_.resultSet_;
                        this.preparedStatementForAutoGeneratedKeys_.resultSet_ = null;
                    }
                }
                if (!bl3) break;
                if (bl4) {
                    this.connection_.readCommitSubstitute_();
                    break;
                }
                this.connection_.readCommit();
                break;
            }
            case 1: {
                try {
                    this.readOpenQuery();
                }
                catch (DisconnectException disconnectException) {
                    throw disconnectException;
                }
                catch (SqlException sqlException) {
                    throw sqlException;
                }
                if (this.resultSet_ == null) break;
                this.resultSet_.parseScrollableRowset();
                this.setupCursorNameCacheAndMappings();
                break;
            }
            case 2: {
                this.readExecuteCall();
            }
        }
        this.agent_.endReadChain();
        if (this.sqlMode_ == 2) {
            this.parseStorProcReturnedScrollableRowset();
            this.checkForStoredProcResultSetCount(n);
            if (this.connection_.autoCommit_ && this.resultSet_ == null && this.resultSetList_ == null && this.isAutoCommittableStatement_) {
                this.connection_.flowAutoCommit();
            }
        }
        if (n == 2 && this.updateCount_ < 0) {
            this.updateCount_ = 0;
        }
        if (this.resultSet_ != null && this.resultSet_.resultSetHoldability_ != this.resultSetHoldability_ && this.sqlMode_ != 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ115.S"), new Integer(this.resultSetHoldability_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatchX(boolean bl) throws SqlException, SQLException, BatchUpdateException {
        Connection connection = this.connection_;
        synchronized (connection) {
            this.checkForClosedStatement();
            this.clearWarningsX();
            return this.executeBatchRequestX(bl);
        }
    }

    private int[] executeBatchRequestX(boolean bl) throws SqlException, BatchUpdateException {
        int n;
        int n2;
        int n3;
        int n4;
        SqlException sqlException = null;
        int n5 = this.batch_.size();
        int[] nArray = new int[n5];
        try {
            n4 = this.parameterMetaData_ == null ? 0 : this.parameterMetaData_.getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        Object[] objectArray = null;
        boolean bl2 = false;
        if (n5 == 0) {
            return nArray;
        }
        if (n5 > 65534) {
            throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ116.S"), new Integer(65534), nArray);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = -3;
        }
        if (!bl && this.sqlMode_ == 1) {
            throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ117.S"), nArray);
        }
        if (bl && this.sqlMode_ != 1) {
            throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ118.S"), nArray);
        }
        this.resultSetList_ = null;
        if (this.sqlMode_ == 1) {
            this.indexOfCurrentResultSet_ = -1;
            this.resultSetList_ = new ResultSet[n5];
        }
        objectArray = this.parameters_;
        this.agent_.beginBatchedWriteChain(this);
        int n6 = n3 = this.connection_.willAutoCommitGenerateFlow() && this.isAutoCommittableStatement_ ? 1 : 0;
        if (this.doWriteTimeout) {
            this.timeoutArrayList.set(0, "SET STATEMENT_TIMEOUT " + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            this.doWriteTimeout = false;
            bl2 = true;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (this.parameterMetaData_ != null) {
                this.parameterMetaData_.clientParamtertype_ = (int[])this.parameterTypeList.get(n2);
                this.parameters_ = (Object[])this.batch_.get(n2);
            }
            if (this.sqlMode_ != 2) {
                try {
                    n = this.resultSetMetaData_ != null && this.resultSetMetaData_.getColumnCount() > 0 ? 1 : 0;
                }
                catch (SQLException sQLException) {
                    throw new SqlException(sQLException);
                }
                this.writeExecute(this.section_, this.parameterMetaData_, this.parameters_, n4, n != 0, n3 != 0 || n2 != n5 - 1);
                continue;
            }
            if (this.outputRegistered_) {
                throw new BatchUpdateException(this.agent_.logWriter_, new ClientMessageId("XJ04C.S"), nArray);
            }
            this.writeExecuteCall(false, null, this.section_, this.fetchSize_, true, this.resultSetType_, this.parameterMetaData_, this.parameters_);
        }
        n2 = 0;
        if (n3 != 0) {
            if (this.agent_.accumulatedReadExceptions_ != null) {
                this.connection_.writeCommitSubstitute_();
                n2 = 1;
            } else {
                this.connection_.writeCommit();
            }
        }
        this.agent_.flowBatch(this, n5);
        if (bl2) {
            this.readSetSpecialRegister();
        }
        try {
            for (n = 0; n < n5; ++n) {
                this.agent_.setBatchedExceptionLabelIndex(n);
                this.parameters_ = (Object[])this.batch_.get(n);
                if (this.sqlMode_ != 2) {
                    this.readExecute();
                } else {
                    this.readExecuteCall();
                }
                nArray[n] = this.updateCount_;
            }
            this.agent_.disableBatchedExceptionTracking();
            if (n3 != 0) {
                if (n2 == 0) {
                    this.connection_.readCommit();
                } else {
                    this.connection_.readCommitSubstitute_();
                }
            }
        }
        catch (SqlException sqlException2) {
            sqlException = sqlException2;
            sqlException.setNextException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ211.S")));
        }
        this.batch_.clear();
        this.parameterTypeList = null;
        this.parameters_ = objectArray;
        this.agent_.endBatchedReadChain(nArray, sqlException);
        return nArray;
    }

    public void listenToUnitOfWork() {
        if (!this.listenToUnitOfWork_) {
            this.listenToUnitOfWork_ = true;
            this.connection_.CommitAndRollbackListeners_.put(this, null);
        }
    }

    public void completeLocalCommit(Iterator iterator) {
        if (this.section_ != null) {
            this.openOnServer_ = false;
        }
        iterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    public void completeLocalRollback(Iterator iterator) {
        if (this.section_ != null) {
            this.openOnServer_ = false;
        }
        iterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.PreparedStatement";
    }

    void checkForValidParameterIndex(int n) throws SqlException {
        if (this.parameterMetaData_ == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("07009"));
        }
        if (n < 1 || n > this.parameterMetaData_.columns_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL13.S"), (Object)new Integer(n), new Integer(this.parameterMetaData_.columns_));
        }
    }

    private void checkThatAllParametersAreSet() throws SqlException {
        if (this.parameterMetaData_ != null) {
            for (int i = 0; i < this.parameterMetaData_.columns_; ++i) {
                if (this.parameterSet_[i] || this.parameterRegistered_[i]) continue;
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("07000"));
            }
        }
    }

    void checkForValidScale(int n) throws SqlException {
        if (n < 0 || n > 31) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ044.S"), new Integer(n));
        }
    }

    private void checkForSupportedDataType(int n) throws SqlException {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.7"), Types.getTypeString(n));
            }
        }
    }

    void checkScaleForINOUTDecimal(int n, int n2) throws SqlException {
        BigDecimal bigDecimal = (BigDecimal)this.parameters_[n - 1];
        if (bigDecimal == null) {
            return;
        }
        if (n2 > this.parameterMetaData_.sqlScale_[n - 1]) {
            int n3 = bigDecimal.toString().length();
            int n4 = n2 - bigDecimal.scale();
            if (bigDecimal.signum() == -1) {
                --n3;
            }
            if (32 - n4 < n3) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ100.S"));
            }
            this.parameters_[n - 1] = bigDecimal.setScale(n2);
            this.parameterMetaData_.sqlScale_[n - 1] = n2;
        } else if (n2 < this.parameterMetaData_.sqlScale_[n - 1]) {
            try {
                this.parameters_[n - 1] = bigDecimal.setScale(n2);
                this.parameterMetaData_.sqlScale_[n - 1] = n2;
            }
            catch (ArithmeticException arithmeticException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ100.S"));
            }
        }
    }

    protected void markClosed(boolean bl) {
        if (this.pooledConnection_ != null) {
            this.pooledConnection_.onStatementClose(this);
        }
        super.markClosed(bl);
        if (this.parameterMetaData_ != null) {
            this.parameterMetaData_.markClosed();
            this.parameterMetaData_ = null;
        }
        this.sql_ = null;
        if (this.parameters_ != null) {
            Arrays.fill(this.parameters_, null);
        }
        this.parameters_ = null;
        if (bl) {
            this.connection_.CommitAndRollbackListeners_.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", n, (Object)inputStream);
            }
            try {
                this.checkTypeForSetAsciiStream(n);
                this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
                if (inputStream == null) {
                    this.setNull(n, -1);
                    return;
                }
                this.setInput(n, new Clob(this.agent_, inputStream, "ISO-8859-1"));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", n, (Object)inputStream);
            }
            try {
                this.checkTypeForSetBinaryStream(n);
                this.setBinaryStreamX(n, inputStream, -1);
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Reader reader) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setClob", n, (Object)reader);
            }
            try {
                this.checkTypeForSetClob(n);
                this.checkForClosedStatement();
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            this.setInput(n, new Clob(this.agent_, reader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Reader reader, long l) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setClob", n, (Object)reader, (Object)new Long(l));
            }
            try {
                this.checkForClosedStatement();
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            if (l > Integer.MAX_VALUE) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ093.S"), (Object)new Long(l), new Integer(Integer.MAX_VALUE)).getSQLException();
            }
            this.setInput(n, new Clob(this.agent_, reader, (int)l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBlob", n, (Object)inputStream);
            }
            try {
                this.checkTypeForSetBlob(n);
                this.setBinaryStreamX(n, inputStream, -1);
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBlob", n, (Object)inputStream, (Object)new Long(l));
            }
            if (l > Integer.MAX_VALUE) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ093.S"), (Object)new Long(l), new Integer(Integer.MAX_VALUE)).getSQLException();
            }
            try {
                this.checkTypeForSetBlob(n);
                this.setBinaryStreamX(n, inputStream, (int)l);
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    private void checkStatementValidity(SqlException sqlException) throws SQLException {
        if (this.pooledConnection_ != null && this.isClosed()) {
            this.pooledConnection_.onStatementErrorOccurred(this, sqlException.getSQLException());
        }
    }

    private static class PossibleTypes {
        private final int[] possibleTypes;
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_GENERIC_SCALAR = new PossibleTypes(new int[]{-5, -1, 1, 3, 4, 5, 7, 8, 12, 16});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_DATE = new PossibleTypes(new int[]{-1, 1, 12, 91, 93});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_TIME = new PossibleTypes(new int[]{-1, 1, 12, 92});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_TIMESTAMP = new PossibleTypes(new int[]{-1, 1, 12, 91, 92, 93});
        private static final PossibleTypes POSSIBLE_TYPES_IN_SET_STRING = new PossibleTypes(new int[]{-5, -1, 1, 3, 4, 5, 7, 8, 12, 16, 91, 92, 93, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_BYTES = new PossibleTypes(new int[]{-4, -3, -2, -1, 1, 12, 2004});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_BINARYSTREAM = new PossibleTypes(new int[]{-4, -3, -2, 2004});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_ASCIISTREAM = new PossibleTypes(new int[]{-1, 1, 12, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_CHARACTERSTREAM = new PossibleTypes(new int[]{-1, 1, 12, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_BLOB = new PossibleTypes(new int[]{2004});
        public static final PossibleTypes POSSIBLE_TYPES_IN_SET_CLOB = new PossibleTypes(new int[]{2005});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL = new PossibleTypes(new int[]{-7, -6, -5, -1, 1, 2, 3, 4, 5, 6, 7, 8, 12});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL = new PossibleTypes(new int[]{-7, -6, -5, -1, 1, 2, 3, 4, 5, 6, 7, 8, 12, 91, 92, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_VARBINARY_NULL = new PossibleTypes(new int[]{-3, -2, -4});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_BINARY_NULL = new PossibleTypes(new int[]{-3, -2, -4});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_LONGVARBINARY_NULL = new PossibleTypes(new int[]{-3, -2, -4});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_DATE_NULL = new PossibleTypes(new int[]{-1, 1, 12, 91, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_TIME_NULL = new PossibleTypes(new int[]{-1, 1, 12, 92, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_TIMESTAMP_NULL = new PossibleTypes(new int[]{-1, 1, 12, 91, 93});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_CLOB_NULL = new PossibleTypes(new int[]{-1, 1, 12, 2005});
        public static final PossibleTypes POSSIBLE_TYPES_FOR_BLOB_NULL = new PossibleTypes(new int[]{2004});
        public static final PossibleTypes DEFAULT_POSSIBLE_TYPES_FOR_NULL = new PossibleTypes(new int[]{-7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 16, 70, 91, 92, 93, 1111, 2000, 2001, 2002, 2003, 2004, 2005, 2006});

        private PossibleTypes(int[] nArray) {
            this.possibleTypes = nArray;
            Arrays.sort(this.possibleTypes);
        }

        boolean checkType(int n) {
            return Arrays.binarySearch(this.possibleTypes, n) >= 0;
        }

        static SqlException throw22005Exception(LogWriter logWriter, int n, int n2) throws SqlException {
            throw new SqlException(logWriter, new ClientMessageId("22005"), new Object[]{Types.getTypeString(n), Types.getTypeString(n2)}, (Throwable)null);
        }

        static PossibleTypes getPossibleTypesForNull(int n) {
            switch (n) {
                case 5: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 4: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case -5: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 7: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 6: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 8: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 3: {
                    return POSSIBLE_TYPES_FOR_GENERIC_SCALAR_NULL;
                }
                case 1: {
                    return POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL;
                }
                case 12: {
                    return POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL;
                }
                case -1: {
                    return POSSIBLE_TYPES_FOR_GENERIC_CHARACTERS_NULL;
                }
                case -3: {
                    return POSSIBLE_TYPES_FOR_VARBINARY_NULL;
                }
                case -2: {
                    return POSSIBLE_TYPES_FOR_BINARY_NULL;
                }
                case -4: {
                    return POSSIBLE_TYPES_FOR_LONGVARBINARY_NULL;
                }
                case 91: {
                    return POSSIBLE_TYPES_FOR_DATE_NULL;
                }
                case 92: {
                    return POSSIBLE_TYPES_FOR_TIME_NULL;
                }
                case 93: {
                    return POSSIBLE_TYPES_FOR_TIMESTAMP_NULL;
                }
                case 2005: {
                    return POSSIBLE_TYPES_FOR_CLOB_NULL;
                }
                case 2004: {
                    return POSSIBLE_TYPES_FOR_BLOB_NULL;
                }
            }
            return DEFAULT_POSSIBLE_TYPES_FOR_NULL;
        }
    }
}

