/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.drda.ConsistencyToken;
import org.apache.derby.impl.drda.DRDAResultSet;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;
import org.apache.derby.impl.drda.FdocaConstants;
import org.apache.derby.impl.drda.Pkgnamcsn;
import org.apache.derby.impl.jdbc.Util;

class DRDAStatement {
    protected String typDefNam;
    protected int byteOrder;
    protected int ccsidSBC;
    protected int ccsidDBC;
    protected int ccsidMBC;
    protected String ccsidSBCEncoding;
    protected String ccsidDBCEncoding;
    protected String ccsidMBCEncoding;
    protected Database database;
    private Pkgnamcsn pkgnamcsn;
    int withHoldCursor = -1;
    protected int isolationLevel;
    protected String cursorName;
    protected int scrollType = 1003;
    protected int concurType = 1007;
    protected long rowCount;
    protected byte[] rslsetflg;
    protected int maxrslcnt;
    protected EnginePreparedStatement ps;
    protected ParameterMetaData stmtPmeta;
    protected boolean isCall;
    protected String procName;
    private int[] outputTypes;
    private int[] outputPrecision;
    private int[] outputScale;
    protected static int NOT_OUTPUT_PARAM = -100000;
    protected boolean outputExpected;
    private EngineStatement stmt;
    private DRDAResultSet currentDrdaRs;
    private Hashtable<ConsistencyToken, DRDAResultSet> resultSetTable;
    private ArrayList<ConsistencyToken> resultSetKeyList;
    private int numResultSets = 0;
    private DataTruncation truncationWarnings;
    private DrdaParamState drdaParamState_ = new DrdaParamState();
    protected int nbrrow;
    protected int qryrowset;
    protected int blksize;
    protected int maxblkext;
    protected int outovropt;
    protected boolean qryrfrtbl;
    private int qryprctyp = 9239;
    boolean needsToSendParamData = false;
    boolean explicitlyPrepared = false;
    long versionCounter;
    int sqldaType;

    DRDAStatement(Database database) {
        this.database = database;
        this.setTypDefValues();
        this.currentDrdaRs = new DRDAResultSet();
    }

    protected void setTypDefValues() {
        this.typDefNam = this.database.typDefNam;
        this.byteOrder = this.database.byteOrder;
        this.ccsidSBC = this.database.ccsidSBC;
        this.ccsidDBC = this.database.ccsidDBC;
        this.ccsidMBC = this.database.ccsidMBC;
        this.ccsidSBCEncoding = this.database.ccsidSBCEncoding;
        this.ccsidDBCEncoding = this.database.ccsidDBCEncoding;
        this.ccsidMBCEncoding = this.database.ccsidMBCEncoding;
    }

    protected void setDatabase(Database database) {
        this.database = database;
        this.setTypDefValues();
    }

    protected void setStatement(Connection connection) throws SQLException {
        this.stmt = (EngineStatement)connection.createStatement();
        if (this.cursorName != null) {
            this.stmt.setCursorName(this.cursorName);
        }
    }

    protected EngineStatement getStatement() throws SQLException {
        return this.stmt;
    }

    protected void addTruncationWarning(DataTruncation dataTruncation) {
        if (this.truncationWarnings == null) {
            this.truncationWarnings = dataTruncation;
        } else {
            this.truncationWarnings.setNextWarning(dataTruncation);
        }
    }

    protected DataTruncation getTruncationWarnings() {
        return this.truncationWarnings;
    }

    protected void clearTruncationWarnings() {
        this.truncationWarnings = null;
    }

    protected void setRsDefaultOptions(DRDAResultSet dRDAResultSet) {
        dRDAResultSet.nbrrow = this.nbrrow;
        dRDAResultSet.qryrowset = this.qryrowset;
        dRDAResultSet.blksize = this.blksize;
        dRDAResultSet.maxblkext = this.maxblkext;
        dRDAResultSet.outovropt = this.outovropt;
        dRDAResultSet.rslsetflg = this.rslsetflg;
        dRDAResultSet.scrollType = this.scrollType;
        dRDAResultSet.concurType = this.concurType;
        dRDAResultSet.setQryprctyp(this.qryprctyp);
        dRDAResultSet.qryrowset = this.qryrowset;
    }

    protected ArrayList<Object> getExtDtaObjects() {
        return this.currentDrdaRs.getExtDtaObjects();
    }

    public void setSplitQRYDTA(byte[] byArray) {
        this.currentDrdaRs.setSplitQRYDTA(byArray);
    }

    public byte[] getSplitQRYDTA() {
        return this.currentDrdaRs.getSplitQRYDTA();
    }

    protected void addExtDtaObject(Object object, int n) {
        this.currentDrdaRs.addExtDtaObject(object, n);
    }

    protected void clearExtDtaObjects() {
        this.currentDrdaRs.clearExtDtaObjects();
    }

    protected boolean isExtDtaValueNullable(int n) {
        return this.currentDrdaRs.isExtDtaValueNullable(n);
    }

    protected void setOPNQRYOptions(int n, int n2, int n3, int n4, int n5, int n6) {
        this.blksize = n;
        this.qryprctyp = n2;
        this.maxblkext = n3;
        this.outovropt = n4;
        this.qryrowset = n5;
        this.currentDrdaRs.setOPNQRYOptions(n, n2, n3, n4, n5, n6);
    }

    protected void setQueryOptions(int n, boolean bl, long l, boolean bl2, int n2, int n3, int n4, boolean bl3, boolean bl4, boolean bl5, int n5, int n6) {
        this.currentDrdaRs.blksize = n;
        this.currentDrdaRs.qryrelscr = bl;
        this.currentDrdaRs.qryrownbr = l;
        this.currentDrdaRs.qryrfrtbl = this.qryrfrtbl;
        this.currentDrdaRs.nbrrow = n2;
        this.currentDrdaRs.maxblkext = n3;
        this.currentDrdaRs.qryscrorn = n4;
        this.currentDrdaRs.qryrowsns = bl3;
        this.currentDrdaRs.qryblkrst = bl4;
        this.currentDrdaRs.qryrtndta = bl5;
        this.currentDrdaRs.qryrowset = n5;
        this.currentDrdaRs.rtnextdta = n6;
    }

    protected void setQryprctyp(int n) {
        this.qryprctyp = n;
        this.currentDrdaRs.setQryprctyp(n);
    }

    protected int getQryprctyp() throws SQLException {
        return this.currentDrdaRs.getQryprctyp();
    }

    protected void setQryrownbr(long l) {
        this.currentDrdaRs.qryrownbr = l;
    }

    protected long getQryrownbr() {
        return this.currentDrdaRs.qryrownbr;
    }

    protected int getQryrowset() {
        return this.currentDrdaRs.qryrowset;
    }

    protected int getBlksize() {
        return this.currentDrdaRs.blksize;
    }

    protected void setQryrtndta(boolean bl) {
        this.currentDrdaRs.qryrtndta = bl;
    }

    protected boolean getQryrtndta() {
        return this.currentDrdaRs.qryrtndta;
    }

    protected void setQryscrorn(int n) {
        this.currentDrdaRs.qryscrorn = n;
    }

    protected int getQryscrorn() {
        return this.currentDrdaRs.qryscrorn;
    }

    protected void setScrollType(int n) {
        this.currentDrdaRs.scrollType = n;
    }

    protected int getScrollType() {
        return this.currentDrdaRs.scrollType;
    }

    protected boolean isScrollable() {
        return this.getScrollType() != 1003;
    }

    protected void setConcurType(int n) {
        this.currentDrdaRs.concurType = n;
    }

    protected int getConcurType() {
        return this.currentDrdaRs.concurType;
    }

    protected void setOutovr_drdaType(int[] nArray) {
        this.currentDrdaRs.outovr_drdaType = nArray;
    }

    protected int[] getOutovr_drdaType() {
        return this.currentDrdaRs.outovr_drdaType;
    }

    protected boolean hasdata() {
        return this.currentDrdaRs.hasdata;
    }

    protected void setHasdata(boolean bl) {
        this.currentDrdaRs.hasdata = bl;
    }

    protected void initialize() {
        this.setTypDefValues();
    }

    protected PreparedStatement explicitPrepare(String string) throws SQLException {
        this.explicitlyPrepared = true;
        return this.prepare(string);
    }

    protected boolean wasExplicitlyPrepared() {
        return this.explicitlyPrepared;
    }

    protected PreparedStatement prepare(String string) throws SQLException {
        int n = -1;
        boolean bl = false;
        if (this.pkgnamcsn != null && this.isolationLevel != 0) {
            n = this.database.getPrepareIsolation();
            this.database.setPrepareIsolation(this.isolationLevel);
            bl = true;
        }
        this.parsePkgidToFindHoldability();
        if (this.isCallableSQL(string)) {
            this.isCall = true;
            this.ps = (EnginePreparedStatement)this.database.getConnection().prepareCall(string, this.scrollType, this.concurType, this.withHoldCursor);
            this.setupCallableStatementParams((CallableStatement)this.ps);
        } else {
            this.ps = (EnginePreparedStatement)this.database.getConnection().prepareStatement(string, this.scrollType, this.concurType, this.withHoldCursor);
        }
        if (this.cursorName != null) {
            this.ps.setCursorName(this.cursorName);
        }
        if (bl) {
            this.database.setPrepareIsolation(n);
        }
        this.versionCounter = this.ps.getVersionCounter();
        return this.ps;
    }

    protected EnginePreparedStatement getPreparedStatement() throws SQLException {
        return this.ps;
    }

    protected boolean execute() throws SQLException {
        boolean bl = this.ps.execute();
        try {
            this.drdaParamState_.drainStreamedParameter();
        }
        catch (IOException iOException) {
            throw Util.javaException((Throwable)iOException);
        }
        this.numResultSets = 0;
        ResultSet resultSet = null;
        boolean bl2 = this.ps instanceof CallableStatement;
        if (bl2) {
            this.needsToSendParamData = true;
        }
        do {
            if ((resultSet = this.ps.getResultSet()) == null) continue;
            if (bl2) {
                this.addResultSet(resultSet, resultSet.getHoldability());
            } else {
                this.addResultSet(resultSet, this.withHoldCursor);
            }
            bl = true;
        } while (bl2 && this.getMoreResults(2));
        return bl;
    }

    protected void finishParams() {
        this.needsToSendParamData = false;
    }

    protected void setPkgnamcsn(Pkgnamcsn pkgnamcsn) {
        this.pkgnamcsn = pkgnamcsn;
        String string = pkgnamcsn.getPkgid();
        if (this.isDynamicPkgid(string)) {
            this.isolationLevel = Integer.parseInt(string.substring(5, 6));
            String string2 = string.substring(string.length() - 5, string.length());
            int n = pkgnamcsn.getPkgsn();
            this.cursorName = "SQL_CUR" + string2 + "C" + n;
        } else {
            this.isolationLevel = this.getStaticPackageIsolation(string);
        }
    }

    private int getStaticPackageIsolation(String string) {
        if (string.equals("SYSSTAT")) {
            return 1;
        }
        return 0;
    }

    protected Pkgnamcsn getPkgnamcsn() {
        return this.pkgnamcsn;
    }

    protected ResultSet getResultSet() {
        return this.currentDrdaRs.getResultSet();
    }

    protected DRDAResultSet getCurrentDrdaResultSet() {
        return this.currentDrdaRs;
    }

    protected void setCurrentDrdaResultSet(int n) {
        ConsistencyToken consistencyToken = this.getResultSetPkgcnstkn(n);
        if (this.currentDrdaRs.pkgcnstkn == consistencyToken) {
            return;
        }
        this.currentDrdaRs = this.getDrdaResultSet(consistencyToken);
    }

    protected void setCurrentDrdaResultSet(Pkgnamcsn pkgnamcsn) {
        this.pkgnamcsn = pkgnamcsn;
        ConsistencyToken consistencyToken = pkgnamcsn.getPkgcnstkn();
        DRDAResultSet dRDAResultSet = this.getDrdaResultSet(consistencyToken);
        if (dRDAResultSet != null) {
            this.currentDrdaRs = dRDAResultSet;
        }
    }

    private DRDAResultSet getDrdaResultSet(ConsistencyToken consistencyToken) {
        if (this.resultSetTable == null || this.currentDrdaRs != null && this.currentDrdaRs.pkgcnstkn == consistencyToken) {
            return this.currentDrdaRs;
        }
        return this.resultSetTable.get(consistencyToken);
    }

    private DRDAResultSet getDrdaResultSet(int n) {
        ConsistencyToken consistencyToken = this.getResultSetPkgcnstkn(n);
        return this.getDrdaResultSet(consistencyToken);
    }

    protected ConsistencyToken addResultSet(ResultSet resultSet, int n) throws SQLException {
        DRDAResultSet dRDAResultSet = null;
        int n2 = this.numResultSets;
        ConsistencyToken consistencyToken = this.calculateResultSetPkgcnstkn(n2);
        if (n2 == 0) {
            dRDAResultSet = this.currentDrdaRs;
        } else {
            dRDAResultSet = new DRDAResultSet();
            if (this.resultSetTable == null) {
                this.resultSetTable = new Hashtable();
                ConsistencyToken consistencyToken2 = this.pkgnamcsn.getPkgcnstkn();
                this.resultSetTable.put(consistencyToken2, this.currentDrdaRs);
                this.resultSetKeyList = new ArrayList();
                this.resultSetKeyList.add(0, consistencyToken2);
            }
            this.resultSetTable.put(consistencyToken, dRDAResultSet);
            this.resultSetKeyList.add(n2, consistencyToken);
        }
        dRDAResultSet.setResultSet(resultSet);
        dRDAResultSet.setPkgcnstkn(consistencyToken);
        dRDAResultSet.withHoldCursor = n;
        this.setRsDefaultOptions(dRDAResultSet);
        dRDAResultSet.suspend();
        ++this.numResultSets;
        return consistencyToken;
    }

    protected int getNumResultSets() {
        return this.numResultSets;
    }

    protected ConsistencyToken getResultSetPkgcnstkn(int n) {
        if (n == 0) {
            return this.pkgnamcsn.getPkgcnstkn();
        }
        return this.resultSetKeyList.get(n);
    }

    protected int[] getRsDRDATypes() {
        return this.currentDrdaRs.getRsDRDATypes();
    }

    protected void rsClose() throws SQLException {
        if (this.currentDrdaRs.getResultSet() == null) {
            return;
        }
        this.currentDrdaRs.close();
        this.needsToSendParamData = false;
        --this.numResultSets;
    }

    protected void CLSQRY() {
        this.currentDrdaRs.CLSQRY();
    }

    protected boolean wasExplicitlyClosed() {
        return this.currentDrdaRs.wasExplicitlyClosed();
    }

    protected void close() throws SQLException {
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.currentDrdaRs.close();
        this.resultSetTable = null;
        this.resultSetKeyList = null;
        this.ps = null;
        this.stmtPmeta = null;
        this.stmt = null;
        this.truncationWarnings = null;
        this.rslsetflg = null;
        this.procName = null;
        this.outputTypes = null;
        this.outputPrecision = null;
        this.outputScale = null;
        this.drdaParamState_.clear(true);
    }

    protected void reset() {
        this.setTypDefValues();
        this.withHoldCursor = -1;
        this.scrollType = 1003;
        this.concurType = 1007;
        this.rowCount = 0L;
        this.rslsetflg = null;
        this.maxrslcnt = 0;
        this.ps = null;
        this.stmtPmeta = null;
        this.isCall = false;
        this.procName = null;
        this.outputTypes = null;
        this.outputExpected = false;
        this.stmt = null;
        this.truncationWarnings = null;
        this.currentDrdaRs.reset();
        this.resultSetTable = null;
        this.resultSetKeyList = null;
        this.numResultSets = 0;
        this.drdaParamState_.clear(false);
        this.nbrrow = 0;
        this.qryrowset = 0;
        this.blksize = 0;
        this.maxblkext = 0;
        this.outovropt = 0;
        this.qryrfrtbl = false;
        this.qryprctyp = 9239;
        this.needsToSendParamData = false;
        this.explicitlyPrepared = false;
    }

    protected boolean rsIsClosed() {
        return this.currentDrdaRs.isClosed();
    }

    protected void rsSuspend() {
        this.currentDrdaRs.suspend();
    }

    protected void setRsPrecision(int n, int n2) {
        this.currentDrdaRs.setRsPrecision(n, n2);
    }

    protected int getRsPrecision(int n) {
        return this.currentDrdaRs.getRsPrecision(n);
    }

    protected void setRsScale(int n, int n2) {
        this.currentDrdaRs.setRsScale(n, n2);
    }

    protected int getRsScale(int n) {
        return this.currentDrdaRs.getRsScale(n);
    }

    protected void setRsDRDAType(int n, int n2) {
        this.currentDrdaRs.setRsDRDAType(n, n2);
    }

    protected void clearDrdaParams() {
        this.drdaParamState_.clear(false);
    }

    protected int getExtPositionCount() {
        return this.drdaParamState_.getExtPosCount();
    }

    protected int getExtPosition(int n) {
        return this.drdaParamState_.getExtPos(n);
    }

    protected void addExtPosition(int n) {
        this.drdaParamState_.addExtPos(n);
    }

    protected int getDrdaParamCount() {
        return this.drdaParamState_.getDrdaParamCount();
    }

    protected void addDrdaParam(byte by, int n) {
        this.drdaParamState_.addDrdaParam(by, n);
    }

    protected void setStreamedParameter(EXTDTAReaderInputStream eXTDTAReaderInputStream) {
        this.drdaParamState_.setStreamedParameter(eXTDTAReaderInputStream);
    }

    protected int getParamDRDAType(int n) {
        return this.drdaParamState_.getDrdaType(n - 1);
    }

    protected int getParamLen(int n) {
        return this.drdaParamState_.getDrdaLen(n - 1);
    }

    protected int getParamPrecision(int n) throws SQLException {
        if (this.ps != null && this.ps instanceof CallableStatement) {
            ParameterMetaData parameterMetaData = this.getParameterMetaData();
            return Math.min(parameterMetaData.getPrecision(n), FdocaConstants.NUMERIC_MAX_PRECISION);
        }
        return -1;
    }

    protected int getParamScale(int n) throws SQLException {
        if (this.ps != null && this.ps instanceof CallableStatement) {
            ParameterMetaData parameterMetaData = this.getParameterMetaData();
            return Math.min(parameterMetaData.getScale(n), FdocaConstants.NUMERIC_MAX_PRECISION);
        }
        return -1;
    }

    protected int getNumRsCols() {
        int[] nArray = this.getRsDRDATypes();
        if (nArray != null) {
            return nArray.length;
        }
        return 0;
    }

    protected int getRsDRDAType(int n) {
        return this.currentDrdaRs.getRsDRDAType(n);
    }

    protected int getRsLen(int n) {
        return this.currentDrdaRs.getRsLen(n);
    }

    public String getResultSetCursorName(int n) throws SQLException {
        DRDAResultSet dRDAResultSet = this.getDrdaResultSet(n);
        return dRDAResultSet.getResultSetCursorName();
    }

    protected String toDebugString(String string) {
        Object object = "";
        if (this.ps == null) {
            object = (String)object + string + String.valueOf(this.ps);
        } else {
            object = (String)object + string + this.pkgnamcsn.getPkgid() + this.pkgnamcsn.getPkgsn();
            object = (String)object + "\t" + this.getSQLText();
        }
        return object;
    }

    protected ConsistencyToken calculateResultSetPkgcnstkn(int n) {
        ConsistencyToken consistencyToken = this.pkgnamcsn.getPkgcnstkn();
        if (n == 0 || consistencyToken == null) {
            return consistencyToken;
        }
        BigInteger bigInteger = new BigInteger(consistencyToken.getBytes());
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        bigInteger = bigInteger.subtract(bigInteger2);
        consistencyToken = new ConsistencyToken(bigInteger.toByteArray());
        return consistencyToken;
    }

    protected boolean isCallableStatement() {
        return this.isCall;
    }

    private boolean isCallableSQL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\n\r\f=? (");
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        return StringUtil.SQLEqualsIgnoreCase((String)string2, (String)"call");
    }

    private void setupCallableStatementParams(CallableStatement callableStatement) throws SQLException {
        ParameterMetaData parameterMetaData = this.getParameterMetaData();
        int n = parameterMetaData.getParameterCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            int n2 = parameterMetaData.getParameterMode(i + 1);
            int n3 = parameterMetaData.getParameterType(i + 1);
            int n4 = parameterMetaData.getPrecision(i + 1);
            int n5 = parameterMetaData.getScale(i + 1);
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: 
                case 4: {
                    bl = true;
                    break;
                }
                case 0: {
                    String string = parameterMetaData.getParameterClassName(i + 1);
                    n3 = DRDAStatement.getOutputParameterTypeFromClassName(string);
                    if (n3 == NOT_OUTPUT_PARAM) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            if (this.outputTypes == null) {
                this.outputTypes = new int[n];
                this.outputPrecision = new int[n];
                this.outputScale = new int[n];
                for (int j = 0; j < n; ++j) {
                    this.outputTypes[j] = NOT_OUTPUT_PARAM;
                    this.outputPrecision[j] = NOT_OUTPUT_PARAM;
                    this.outputScale[j] = NOT_OUTPUT_PARAM;
                }
            }
            this.outputTypes[i] = n3;
            this.outputPrecision[i] = n4;
            this.outputScale[i] = n5;
        }
    }

    protected static int getOutputParameterTypeFromClassName(String string) {
        if (string.endsWith("[]")) {
            if (string.equals("byte[]")) {
                return NOT_OUTPUT_PARAM;
            }
            if (string.equals("java.lang.Byte[]")) {
                return -6;
            }
            if (string.equals("byte[][]")) {
                return -3;
            }
            if (string.equals("java.lang.String[]")) {
                return 12;
            }
            if (string.equals("int[]") || string.equals("java.lang.Integer[]")) {
                return 4;
            }
            if (string.equals("long[]") || string.equals("java.lang.Long[]")) {
                return -5;
            }
            if (string.equals("java.math.BigDecimal[]")) {
                return 2;
            }
            if (string.equals("boolean[]") || string.equals("java.lang.Boolean[]")) {
                return -7;
            }
            if (string.equals("short[]")) {
                return 5;
            }
            if (string.equals("float[]") || string.equals("java.lang.Float[]")) {
                return 7;
            }
            if (string.equals("double[]") || string.equals("java.lang.Double[]")) {
                return 8;
            }
            if (string.equals("java.sql.Date[]")) {
                return 91;
            }
            if (string.equals("java.sql.Time[]")) {
                return 92;
            }
            if (string.equals("java.sql.Timestamp[]")) {
                return 93;
            }
        }
        return NOT_OUTPUT_PARAM;
    }

    public void registerAllOutParams() throws SQLException {
        if (this.isCall && this.outputTypes != null) {
            for (int i = 1; i <= this.outputTypes.length; ++i) {
                this.registerOutParam(i);
            }
        }
    }

    public void registerOutParam(int n) throws SQLException {
        if (this.isOutputParam(n)) {
            CallableStatement callableStatement = (CallableStatement)this.ps;
            callableStatement.registerOutParameter(n, this.getOutputParamType(n));
        }
    }

    protected boolean hasOutputParams() {
        return this.outputTypes != null;
    }

    boolean isOutputParam(int n) {
        if (this.outputTypes != null) {
            return this.outputTypes[n - 1] != NOT_OUTPUT_PARAM;
        }
        return false;
    }

    int getOutputParamType(int n) {
        if (this.outputTypes != null) {
            return this.outputTypes[n - 1];
        }
        return NOT_OUTPUT_PARAM;
    }

    int getOutputParamScale(int n) {
        if (this.outputScale != null) {
            return this.outputScale[n - 1];
        }
        return NOT_OUTPUT_PARAM;
    }

    int getOutputParamPrecision(int n) {
        if (this.outputPrecision != null) {
            return this.outputPrecision[n - 1];
        }
        return NOT_OUTPUT_PARAM;
    }

    private boolean isDynamicPkgid(String string) {
        char c = string.charAt(3);
        char c2 = string.charAt(4);
        return !(!string.substring(0, 3).equals("SYS") || c != 'S' && c != 'L' || c2 != 'H' && c2 != 'N');
    }

    private void parsePkgidToFindHoldability() {
        if (this.withHoldCursor != -1) {
            return;
        }
        String string = this.pkgnamcsn.getPkgid();
        this.withHoldCursor = this.isDynamicPkgid(string) ? (string.charAt(4) == 'N' ? 2 : 1) : 1;
    }

    protected ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.stmtPmeta != null) {
            return this.stmtPmeta;
        }
        this.stmtPmeta = this.ps.getParameterMetaData();
        return this.stmtPmeta;
    }

    private boolean getMoreResults(int n) throws SQLException {
        return this.getPreparedStatement().getMoreResults(n);
    }

    private String getSQLText() {
        String string = null;
        Class[] classArray = new Class[]{};
        Object[] objectArray = null;
        try {
            Method method = this.getPreparedStatement().getClass().getMethod("getSQLText", classArray);
            string = (String)method.invoke((Object)this.getPreparedStatement(), objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    boolean isRSCloseImplicit(boolean bl) throws SQLException {
        return this.currentDrdaRs.qryclsimp == 1 && !this.isScrollable() && (bl || this.currentDrdaRs.getQryprctyp() != 9239);
    }

    private static class DrdaParamState {
        private EXTDTAReaderInputStream streamedParameter = null;
        private int typeLstEnd_ = 0;
        private byte[] typeLst_ = new byte[10];
        private int[] lenLst_ = new int[10];
        private int extLstEnd_ = 0;
        private int[] extLst_ = new int[10];

        private DrdaParamState() {
        }

        private static Object growArray(Object object) {
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(object.getClass().getComponentType(), Math.max(n, 1) * 2);
            System.arraycopy(object, 0, object2, 0, n);
            return object2;
        }

        protected void clear(boolean bl) {
            this.streamedParameter = null;
            this.typeLstEnd_ = 0;
            this.extLstEnd_ = 0;
            if (bl && this.typeLst_.length > 10) {
                this.typeLst_ = new byte[10];
                this.lenLst_ = new int[10];
                this.extLst_ = new int[10];
            }
        }

        protected void addDrdaParam(byte by, int n) {
            if (this.typeLstEnd_ >= this.typeLst_.length) {
                this.typeLst_ = (byte[])DrdaParamState.growArray(this.typeLst_);
                this.lenLst_ = (int[])DrdaParamState.growArray(this.lenLst_);
            }
            this.typeLst_[this.typeLstEnd_] = by;
            this.lenLst_[this.typeLstEnd_] = n;
            ++this.typeLstEnd_;
        }

        protected int getDrdaParamCount() {
            return this.typeLstEnd_;
        }

        protected byte getDrdaType(int n) {
            return this.typeLst_[n];
        }

        protected int getDrdaLen(int n) {
            return this.lenLst_[n];
        }

        protected void addExtPos(int n) {
            if (this.extLstEnd_ >= this.extLst_.length) {
                this.extLst_ = (int[])DrdaParamState.growArray(this.extLst_);
            }
            this.extLst_[this.extLstEnd_] = n;
            ++this.extLstEnd_;
        }

        protected int getExtPosCount() {
            return this.extLstEnd_;
        }

        protected int getExtPos(int n) {
            return this.extLst_[n];
        }

        protected void drainStreamedParameter() throws IOException {
            if (this.streamedParameter != null) {
                int n;
                byte[] byArray = new byte[1000];
                while ((n = this.streamedParameter.read(byArray, 0, 1000)) != -1) {
                }
            }
        }

        public void setStreamedParameter(EXTDTAReaderInputStream eXTDTAReaderInputStream) {
            this.streamedParameter = eXTDTAReaderInputStream;
        }
    }
}

