/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DRDAString;
import org.apache.derby.impl.drda.DssTrace;
import org.apache.derby.impl.drda.EXTDTAInputStream;
import org.apache.derby.impl.drda.FdocaConstants;

class DDMWriter {
    private static final int MAX_MARKS_NESTING = 10;
    private static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private byte[] bytes;
    private int offset;
    private int[] markStack = new int[10];
    private int top;
    private CcsidManager ccsidManager;
    private DRDAConnThread agent;
    private int dssLengthLocation;
    private int correlationID;
    private int nextCorrelationID;
    private boolean isDRDAProtocol;
    private DssTrace dssTrace;
    private int prevHdrLocation;
    private int previousCorrId;
    private byte previousChainByte;
    private boolean isContinuationDss;
    private int lastDSSBeforeMark;

    DDMWriter(int n, CcsidManager ccsidManager, DRDAConnThread dRDAConnThread, DssTrace dssTrace) {
        this.bytes = new byte[n];
        this.ccsidManager = ccsidManager;
        this.agent = dRDAConnThread;
        this.prevHdrLocation = -1;
        this.previousCorrId = -1;
        this.previousChainByte = 0;
        this.isContinuationDss = false;
        this.lastDSSBeforeMark = -1;
        this.reset(dssTrace);
    }

    DDMWriter(CcsidManager ccsidManager, DRDAConnThread dRDAConnThread, DssTrace dssTrace) {
        this.bytes = new byte[Short.MAX_VALUE];
        this.ccsidManager = ccsidManager;
        this.agent = dRDAConnThread;
        this.prevHdrLocation = -1;
        this.previousCorrId = -1;
        this.previousChainByte = 0;
        this.isContinuationDss = false;
        this.lastDSSBeforeMark = -1;
        this.reset(dssTrace);
    }

    protected void reset(DssTrace dssTrace) {
        this.offset = 0;
        this.top = 0;
        this.dssLengthLocation = 0;
        this.nextCorrelationID = 1;
        this.correlationID = -1;
        this.isDRDAProtocol = true;
        this.dssTrace = dssTrace;
    }

    protected void setCMDProtocol() {
        this.isDRDAProtocol = false;
    }

    protected void createDssReply() {
        this.beginDss(2, true);
    }

    protected void createDssRequest() {
        this.beginDss(1, true);
    }

    protected void createDssObject() {
        this.beginDss(3, true);
    }

    private void markDssAsContinued(boolean bl) {
        if (!bl) {
            int n = this.dssLengthLocation;
            this.bytes[n] = (byte)(this.bytes[n] | 0x80);
        }
        if (!this.isContinuationDss) {
            this.endDss(!bl);
        }
    }

    protected void endDss(byte by) {
        this.endDss(true);
        int n = this.dssLengthLocation + 3;
        this.bytes[n] = (byte)(this.bytes[n] & 0xF);
        int n2 = this.dssLengthLocation + 3;
        this.bytes[n2] = (byte)(this.bytes[n2] | by);
        this.previousChainByte = by;
    }

    protected void endDss() {
        this.endDss(true);
    }

    private void endDss(boolean bl) {
        if (bl) {
            this.finalizeDssLength();
        }
        if (this.isContinuationDss) {
            this.isContinuationDss = false;
            return;
        }
        this.previousCorrId = this.correlationID;
        this.prevHdrLocation = this.dssLengthLocation;
        this.previousChainByte = (byte)80;
    }

    protected void endDdmAndDss() {
        this.endDdm();
        this.endDss();
    }

    protected byte[] copyDSSDataToEnd(int n) {
        int n2 = this.offset - (n += this.dssLengthLocation);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.bytes, n, byArray, 0, n2);
        return byArray;
    }

    protected void startDdm(int n) {
        this.markStack[this.top++] = this.offset;
        this.ensureLength(4);
        this.offset += 2;
        this.bytes[this.offset] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n & 0xFF);
        this.offset += 2;
    }

    protected void clearDdm() {
        this.offset = this.markStack[this.top--];
    }

    protected void clearBuffer() {
        this.offset = 0;
        this.top = 0;
        this.dssLengthLocation = 0;
        this.correlationID = -1;
        this.nextCorrelationID = 1;
        this.isDRDAProtocol = true;
    }

    protected void endDdm() {
        int n;
        int n2;
        int n3;
        if ((n3 = this.calculateExtendedLengthByteCount(n2 = this.offset - (n = this.markStack[--this.top]))) != 0) {
            this.ensureLength(n3);
            int n4 = n2 - 4;
            int n5 = n + 4;
            System.arraycopy(this.bytes, n5, this.bytes, n5 + n3, n4);
            int n6 = (n3 - 1) * 8;
            for (int i = 0; i < n3; ++i) {
                this.bytes[n5++] = (byte)(n4 >>> n6 & 0xFF);
                n6 -= 8;
            }
            this.offset += n3;
            n2 = n3 + 4;
            n2 |= 0x8000;
        }
        this.bytes[n] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes[n + 1] = (byte)(n2 & 0xFF);
    }

    protected int getDSSLength() {
        return this.offset - this.dssLengthLocation;
    }

    protected void truncateDSS(int n) {
        this.offset = this.dssLengthLocation + n;
    }

    protected void writeByte(int n) {
        this.ensureLength(1);
        this.bytes[this.offset++] = (byte)(n & 0xFF);
    }

    protected void writeNetworkShort(int n) {
        this.ensureLength(2);
        this.bytes[this.offset] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n & 0xFF);
        this.offset += 2;
    }

    protected void writeNetworkInt(int n) {
        this.ensureLength(4);
        this.bytes[this.offset] = (byte)(n >>> 24 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n >>> 16 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.offset += 4;
    }

    protected void writeBytes(byte[] byArray, int n) {
        this.writeBytes(byArray, 0, n);
    }

    protected void writeBytes(byte[] byArray, int n, int n2) {
        this.ensureLength(n2);
        System.arraycopy(byArray, n, this.bytes, this.offset, n2);
        this.offset += n2;
    }

    protected void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, byArray.length);
    }

    protected void writeLDBytes(byte[] byArray) {
        this.writeLDBytes(byArray, 0);
    }

    protected void writeLDBytes(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = byArray.length;
        this.writeShort(n3);
        this.writeBytes(byArray, 0, n3);
    }

    void writeCodePoint4Bytes(int n, int n2) {
        this.ensureLength(4);
        this.bytes[this.offset] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n2 & 0xFF);
        this.offset += 4;
    }

    void writeScalar1Byte(int n, int n2) {
        this.ensureLength(5);
        this.bytes[this.offset] = 0;
        this.bytes[this.offset + 1] = 5;
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.bytes[this.offset + 4] = (byte)(n2 & 0xFF);
        this.offset += 5;
    }

    protected void writeScalar2Bytes(int n, int n2) {
        this.ensureLength(6);
        this.bytes[this.offset] = 0;
        this.bytes[this.offset + 1] = 6;
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.bytes[this.offset + 4] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes[this.offset + 5] = (byte)(n2 & 0xFF);
        this.offset += 6;
    }

    protected void writeScalar2Bytes(int n) {
        this.ensureLength(2);
        this.bytes[this.offset] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n & 0xFF);
        this.offset += 2;
    }

    protected void startDdm(int n, int n2) {
        this.ensureLength(4);
        this.bytes[this.offset] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n2 & 0xFF);
        this.offset += 4;
    }

    protected void writeScalarBytes(int n, byte[] byArray, int n2) {
        this.ensureLength(n2 + 4);
        this.bytes[this.offset] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n2 + 4 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.bytes, this.offset + 4, n2);
        this.offset += n2 + 4;
    }

    protected void writeScalarStream(boolean bl, int n, EXTDTAInputStream eXTDTAInputStream, boolean bl2) throws DRDAProtocolException {
        int n2 = this.prepScalarStream(bl, n, bl2);
        int n3 = 0;
        int n4 = 0;
        try {
            OutputStream outputStream = DDMWriter.placeLayerBStreamingBuffer(this.agent.getOutputStream());
            boolean bl3 = false;
            while (!bl3) {
                int n5 = this.bytes.length - this.offset;
                n3 = eXTDTAInputStream.read(this.bytes, this.offset, Math.min(n2, n5));
                n4 += n3;
                this.offset += n3;
                n5 -= n3;
                boolean bl4 = bl3 = DDMWriter.peekStream(eXTDTAInputStream) < 0;
                if (!bl3 && (n2 -= n3) != 0) continue;
                this.flushScalarStreamSegment(bl3, outputStream);
                if (bl3) continue;
                n2 = 32765;
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            this.agent.markCommunicationsFailure("DDMWriter.writeScalarStream()", "", iOException.getMessage(), "*");
        }
    }

    private void beginDss(boolean bl, int n) {
        this.beginDss(n, false);
        this.bytes[this.dssLengthLocation] = -1;
        this.bytes[this.dssLengthLocation + 1] = -1;
        if (bl) {
            n |= 0x50;
        }
        this.bytes[this.dssLengthLocation + 3] = (byte)(n & 0xFF);
    }

    private int prepScalarStream(boolean bl, int n, boolean bl2) throws DRDAProtocolException {
        this.ensureLength(Short.MAX_VALUE - this.offset);
        int n2 = bl2 ? 1 : 0;
        try {
            this.sendBytes(this.agent.getOutputStream());
        }
        catch (IOException iOException) {
            this.agent.markCommunicationsFailure("DDMWriter.writeScalarStream()", "OutputStream.flush()", iOException.getMessage(), "*");
        }
        this.beginDss(bl, 3);
        this.writeLengthCodePoint(32772, n);
        if (bl2) {
            this.writeByte(0);
        }
        return 32757 - n2;
    }

    protected boolean doesRequestContainData() {
        return this.offset != 0;
    }

    private void flushScalarStreamSegment(boolean bl, OutputStream outputStream) throws DRDAProtocolException {
        if (!bl) {
            try {
                this.markDssAsContinued(true);
                this.sendBytes(outputStream, false);
            }
            catch (IOException iOException) {
                this.agent.markCommunicationsFailure("DDMWriter.flushScalarStreamSegment()", "", iOException.getMessage(), "*");
            }
            this.dssLengthLocation = this.offset;
            this.bytes[this.offset++] = -1;
            this.bytes[this.offset++] = -1;
            this.isContinuationDss = true;
        } else {
            this.endDss();
        }
    }

    private void writeExtendedLengthBytes(int n, long l) {
        int n2 = (n - 1) * 8;
        for (int i = 0; i < n; ++i) {
            this.bytes[this.offset + i] = (byte)(l >>> n2 & 0xFFL);
            n2 -= 8;
        }
        this.offset += n;
    }

    void writeLengthCodePoint(int n, int n2) {
        this.ensureLength(4);
        this.bytes[this.offset] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n2 & 0xFF);
        this.offset += 4;
    }

    protected void writeScalarHeader(int n, int n2) {
        this.ensureLength(n2 + 4);
        this.bytes[this.offset] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n2 + 4 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.offset += 4;
    }

    void writeScalarString(int n, String string) {
        int n2 = string.length();
        this.ensureLength(n2 * 2 + 4);
        this.bytes[this.offset] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n2 + 4 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.offset = this.ccsidManager.convertFromUCS2(string, this.bytes, this.offset + 4);
    }

    void writeScalarPaddedString(int n, String string, int n2) {
        int n3 = string.length();
        int n4 = n2 - n3;
        this.ensureLength(n2 + 4);
        this.bytes[this.offset] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n2 + 4 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.offset = this.ccsidManager.convertFromUCS2(string, this.bytes, this.offset + 4);
        Arrays.fill(this.bytes, this.offset, this.offset + n4, this.ccsidManager.space);
        this.offset += n4;
    }

    protected void writeScalarPaddedString(String string, int n) {
        int n2 = string.length();
        int n3 = n - n2;
        this.ensureLength(n);
        this.offset = this.ccsidManager.convertFromUCS2(string, this.bytes, this.offset);
        Arrays.fill(this.bytes, this.offset, this.offset + n3, this.ccsidManager.space);
        this.offset += n3;
    }

    protected void writeScalarPaddedString(DRDAString dRDAString, int n) {
        int n2 = dRDAString.length();
        int n3 = n - n2;
        this.ensureLength(n);
        System.arraycopy(dRDAString.getBytes(), 0, this.bytes, this.offset, n2);
        this.offset += n2;
        Arrays.fill(this.bytes, this.offset, this.offset + n3, this.ccsidManager.space);
        this.offset += n3;
    }

    protected void writeScalarPaddedBytes(int n, byte[] byArray, int n2, byte by) {
        int n3 = byArray.length;
        this.ensureLength(n2 + 4);
        this.bytes[this.offset] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n2 + 4 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.offset += 4;
        System.arraycopy(byArray, 0, this.bytes, this.offset, n3);
        this.offset += n3;
        int n4 = n2 - n3;
        Arrays.fill(this.bytes, this.offset, this.offset + n4, by);
        this.offset += n4;
    }

    protected void writeScalarPaddedBytes(byte[] byArray, int n, byte by) {
        int n2 = byArray.length;
        int n3 = n - n2;
        this.ensureLength(n);
        System.arraycopy(byArray, 0, this.bytes, this.offset, n2);
        this.offset += n2;
        Arrays.fill(this.bytes, this.offset, this.offset + n3, by);
        this.offset += n3;
    }

    protected void writeScalarBytes(int n, byte[] byArray) {
        int n2 = byArray.length;
        this.ensureLength(n2 + 4);
        this.bytes[this.offset] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n2 + 4 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.bytes, this.offset + 4, n2);
        this.offset += n2 + 4;
    }

    protected void writeScalarBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        this.ensureLength(n4 + 4);
        this.bytes[this.offset] = (byte)(n4 + 4 >>> 8 & 0xFF);
        this.bytes[this.offset + 1] = (byte)(n4 + 4 & 0xFF);
        this.bytes[this.offset + 2] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(n & 0xFF);
        this.offset += 4;
        System.arraycopy(byArray, n2, this.bytes, this.offset, n4);
        this.offset += n4;
    }

    protected void writeShort(int n) {
        this.writeNetworkShort(n);
    }

    protected void writeShort(boolean bl) {
        this.writeNetworkShort(bl ? 1 : 0);
    }

    protected void writeInt(int n) {
        this.writeNetworkInt(n);
    }

    protected void writeLong(long l) {
        this.ensureLength(8);
        this.bytes[this.offset] = (byte)(l >>> 56 & 0xFFL);
        this.bytes[this.offset + 1] = (byte)(l >>> 48 & 0xFFL);
        this.bytes[this.offset + 2] = (byte)(l >>> 40 & 0xFFL);
        this.bytes[this.offset + 3] = (byte)(l >>> 32 & 0xFFL);
        this.bytes[this.offset + 4] = (byte)(l >>> 24 & 0xFFL);
        this.bytes[this.offset + 5] = (byte)(l >>> 16 & 0xFFL);
        this.bytes[this.offset + 6] = (byte)(l >>> 8 & 0xFFL);
        this.bytes[this.offset + 7] = (byte)(l >>> 0 & 0xFFL);
        this.offset += 8;
    }

    protected void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    protected void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    protected void writeBigDecimal(BigDecimal bigDecimal, int n, int n2) throws SQLException {
        int n3 = n / 2 + 1;
        this.ensureLength(this.offset + n3);
        this.bigDecimalToPackedDecimalBytes(bigDecimal, n, n2);
        this.offset += n3;
    }

    protected void writeBoolean(boolean bl) {
        this.ensureLength(1);
        this.bytes[this.offset++] = (byte)((bl ? 1 : 0) & 0xFF);
    }

    protected void writeLDString(String string) throws DRDAProtocolException {
        this.writeLDString(string, 0);
    }

    protected void writeLDString(String string, int n) throws DRDAProtocolException {
        try {
            byte[] byArray = string.getBytes("UTF8");
            int n2 = byArray.length;
            boolean bl = false;
            int n3 = Math.min(FdocaConstants.LONGVARCHAR_MAX_LEN, n2);
            if (n3 != n2) {
                while ((byArray[n3 - 1] & 0xC0) == 128) {
                    bl = true;
                    --n3;
                    if (!bl) continue;
                    --n3;
                }
            }
            this.writeShort(n3);
            this.writeBytes(byArray, n3);
        }
        catch (Exception exception) {
            this.agent.agentError("Encoding UTF8 not supported");
        }
    }

    protected void writeString(String string) throws DRDAProtocolException {
        try {
            this.writeBytes(string.getBytes("UTF8"));
        }
        catch (Exception exception) {
            this.agent.agentError("Encoding UTF8 not supported");
        }
    }

    protected void writeString(String string, int n) throws DRDAProtocolException {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (Exception exception) {
            this.agent.agentError("Encoding UTF8 not supported");
        }
        int n2 = byArray.length;
        if (n2 >= n) {
            this.writeBytes(byArray, n);
        } else {
            this.writeBytes(byArray);
            this.padBytes((byte)32, n - n2);
        }
    }

    protected void padBytes(byte by, int n) {
        Arrays.fill(this.bytes, this.offset, this.offset + n, by);
        this.offset += n;
    }

    protected void flush() throws IOException {
        this.flush(this.agent.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(OutputStream outputStream) throws IOException {
        try {
            outputStream.write(this.bytes, 0, this.offset);
            outputStream.flush();
            Object var3_2 = null;
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(this.bytes, 0, this.offset, 1, "Reply", "flush", 5);
            }
            this.reset(this.dssTrace);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(this.bytes, 0, this.offset, 1, "Reply", "flush", 5);
            }
            this.reset(this.dssTrace);
            throw throwable;
        }
    }

    private void beginDss(int n, boolean bl) {
        this.dssLengthLocation = this.offset;
        if (bl) {
            this.ensureLength(6);
        }
        this.offset += 2;
        this.bytes[this.offset] = -48;
        this.bytes[this.offset + 1] = (byte)n;
        int n2 = this.offset + 1;
        this.bytes[n2] = (byte)(this.bytes[n2] | 0x50);
        this.correlationID = this.getCorrelationID();
        this.bytes[this.offset + 2] = (byte)(this.correlationID >>> 8 & 0xFF);
        this.bytes[this.offset + 3] = (byte)(this.correlationID & 0xFF);
        this.offset += 4;
    }

    private void finalizeDssLength() {
        int n = this.offset - this.dssLengthLocation;
        int n2 = n - Short.MAX_VALUE;
        if (n2 > 0) {
            int n3;
            int n4 = n2 / 32765;
            if (n2 % 32765 != 0) {
                ++n4;
            }
            int n5 = this.offset - 1;
            int n6 = n4 * 2;
            this.ensureLength(n6);
            this.offset += n6;
            boolean bl = true;
            do {
                if ((n3 = n2 % 32765) == 0) {
                    n3 = 32765;
                }
                int n7 = n5 - n3 + 1;
                System.arraycopy(this.bytes, n7, this.bytes, n7 + n6, n3);
                n5 -= n3;
                int n8 = n3 + 2;
                if (bl) {
                    bl = false;
                } else if (n8 == Short.MAX_VALUE) {
                    n8 |= 0x8000;
                }
                this.bytes[n5 + n6 - 1] = (byte)(n8 >>> 8 & 0xFF);
                this.bytes[n5 + n6] = (byte)(n8 & 0xFF);
                n6 -= 2;
            } while ((n2 -= n3) > 0);
            n = 65535;
        }
        this.bytes[this.dssLengthLocation] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.dssLengthLocation + 1] = (byte)(n & 0xFF);
    }

    protected void writeExtendedLength(long l) {
        int n = this.calculateExtendedLengthByteCount(l);
        if (l > 0L) {
            this.writeInt(0x8000 | n);
        } else {
            this.writeInt(n);
        }
    }

    private int calculateExtendedLengthByteCount(long l) {
        if (l <= 32767L) {
            return 0;
        }
        if (l <= 0xFFFFFFFFL) {
            return 4;
        }
        if (l <= 0xFFFFFFFFFFFFL) {
            return 6;
        }
        if (l <= Long.MAX_VALUE) {
            return 8;
        }
        return 0;
    }

    private void ensureLength(int n) {
        if ((n += this.offset) > this.bytes.length) {
            byte[] byArray = new byte[Math.max(this.bytes.length << 1, n)];
            System.arraycopy(this.bytes, 0, byArray, 0, this.offset);
            this.bytes = byArray;
        }
    }

    private int bigDecimalToPackedDecimalBytes(BigDecimal bigDecimal, int n, int n2) throws SQLException {
        int n3;
        int n4;
        int n5 = n;
        int n6 = n2;
        if (n5 > 31) {
            this.clearDdm();
            throw new SQLException("Packed decimal may only be up to 31 digits!");
        }
        String string = bigDecimal.unscaledValue().abs().toString();
        int n7 = string.length();
        if (n7 > 31) {
            this.clearDdm();
            throw new SQLException("The numeric literal \"" + bigDecimal.toString() + "\" is not valid because its value is out of range.", "42820", -405);
        }
        int n8 = bigDecimal.scale();
        int n9 = n7 - n8;
        if (n9 > 0 && !string.equals("0") && n9 > (n4 = n5 - n6)) {
            this.clearDdm();
            throw new SQLException("Overflow occurred during numeric data type conversion of \"" + bigDecimal.toString() + "\".", "22003", -413);
        }
        n4 = 48;
        int n10 = n5 - 1;
        if (n8 >= n6) {
            n3 = n7 - 1 - (n8 - n6);
            this.bytes[this.offset + (n10 + 1) / 2] = n3 < 0 ? (byte)(bigDecimal.signum() >= 0 ? 12 : 13) : (byte)((string.charAt(n3) - n4 << 4) + (bigDecimal.signum() >= 0 ? 12 : 13));
            n10 -= 2;
            n3 -= 2;
        } else {
            n3 = n6 - n8 - 1;
            this.bytes[this.offset + (n10 + 1) / 2] = (byte)(bigDecimal.signum() >= 0 ? 12 : 13);
            n10 -= 2;
            n3 -= 2;
            while (n3 >= 0) {
                this.bytes[this.offset + (n10 + 1) / 2] = 0;
                n10 -= 2;
                n3 -= 2;
            }
            if (n3 == -1) {
                this.bytes[this.offset + (n10 + 1) / 2] = (byte)(string.charAt(n7 - 1) - n4 << 4);
                n10 -= 2;
                n3 = n7 - 3;
            } else {
                n3 = n7 - 2;
            }
        }
        while (n3 >= 0) {
            this.bytes[this.offset + (n10 + 1) / 2] = (byte)((string.charAt(n3) - n4 << 4) + (string.charAt(n3 + 1) - n4));
            n10 -= 2;
            n3 -= 2;
        }
        if (n3 == -1) {
            this.bytes[this.offset + (n10 + 1) / 2] = (byte)(string.charAt(0) - n4);
            n10 -= 2;
        }
        while (n10 >= -1) {
            this.bytes[this.offset + (n10 + 1) / 2] = 0;
            n10 -= 2;
        }
        return n5 / 2 + 1;
    }

    public static String zeroPadString(String string, int n) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n == n2) {
            return string;
        }
        if (n > n2) {
            char[] cArray = new char[n - n2];
            Arrays.fill(cArray, 0, n - n2, '0');
            return new String(cArray) + string;
        }
        return string.substring(0, n);
    }

    private void sendBytes(OutputStream outputStream) throws IOException {
        this.sendBytes(outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBytes(OutputStream outputStream, boolean bl) throws IOException {
        this.resetChainState();
        try {
            outputStream.write(this.bytes, 0, this.offset);
            if (bl) {
                outputStream.flush();
            }
            Object var4_3 = null;
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(this.bytes, 0, this.offset, 1, "Reply", "flush", 5);
            }
            this.clearBuffer();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(this.bytes, 0, this.offset, 1, "Reply", "flush", 5);
            }
            this.clearBuffer();
            throw throwable;
        }
    }

    protected String toDebugString(String string) {
        String string2 = string + "***** DDMWriter toDebugString ******\n";
        int n = 0;
        if (this.bytes != null) {
            n = this.bytes.length;
        }
        string2 = string2 + string + "byte array length  = " + this.bytes.length + "\n";
        return string2;
    }

    protected void resetChainState() {
        this.prevHdrLocation = -1;
    }

    private int getCorrelationID() {
        int n = this.previousCorrId != -1 ? (this.previousChainByte == 80 ? this.previousCorrId : this.nextCorrelationID++) : this.nextCorrelationID++;
        return n;
    }

    protected void finalizeChain(byte by, OutputStream outputStream) throws DRDAProtocolException {
        if (this.prevHdrLocation != -1) {
            int n = this.prevHdrLocation + 3;
            this.bytes[n] = (byte)(this.bytes[n] & 0xF);
            int n2 = this.prevHdrLocation + 3;
            this.bytes[n2] = (byte)(this.bytes[n2] | by);
        }
        this.previousChainByte = by;
        if (by != 0) {
            return;
        }
        this.resetChainState();
        if (this.doesRequestContainData()) {
            try {
                this.flush(outputStream);
            }
            catch (IOException iOException) {
                this.agent.markCommunicationsFailure("DDMWriter.finalizeChain()", "OutputStream.flush()", iOException.getMessage(), "*");
            }
        }
    }

    protected int markDSSClearPoint() {
        this.lastDSSBeforeMark = this.prevHdrLocation;
        return this.offset;
    }

    protected void clearDSSesBackToMark(int n) {
        this.offset = n;
        this.nextCorrelationID = this.lastDSSBeforeMark == -1 ? 1 : 1 + (((this.bytes[this.lastDSSBeforeMark + 4] & 0xFF) << 8) + (this.bytes[this.lastDSSBeforeMark + 5] & 0xFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int peekStream(InputStream inputStream) throws IOException {
        inputStream.mark(1);
        try {
            int n = inputStream.read();
            return n;
        }
        finally {
            inputStream.reset();
        }
    }

    private static int getLayerBStreamingBufferSize() {
        return PropertyUtil.getSystemInt((String)"derby.drda.streamOutBufferSize", (int)0);
    }

    private static OutputStream placeLayerBStreamingBuffer(OutputStream outputStream) {
        int n = DDMWriter.getLayerBStreamingBufferSize();
        if (n < 1) {
            return outputStream;
        }
        return new BufferedOutputStream(outputStream, n);
    }
}

