/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.loader;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.api.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSchema;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.schema.loader.AttributeClassLoader;
import org.apache.directory.api.ldap.schema.loader.EntityFactory;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaEntityFactory
implements EntityFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaEntityFactory.class);
    private static final List<String> EMPTY_LIST = new ArrayList<String>();
    private static final String[] EMPTY_ARRAY = new String[0];
    private final AttributeClassLoader classLoader = new AttributeClassLoader();

    private String getOid(Entry entry, String objectType) throws LdapInvalidAttributeValueException {
        Attribute mOid = entry.get("m-oid");
        if (mOid == null) {
            String msg = I18n.err(I18n.ERR_10005, objectType, "m-oid");
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        String oid = mOid.getString();
        if (!Oid.isOid(oid)) {
            String msg = I18n.err(I18n.ERR_10006, oid);
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        return oid;
    }

    private String getOid(SchemaObject description, String objectType) throws LdapInvalidAttributeValueException {
        String oid = description.getOid();
        if (oid == null) {
            String msg = I18n.err(I18n.ERR_10005, objectType, "m-oid");
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!Oid.isOid(oid)) {
            String msg = I18n.err(I18n.ERR_10006, oid);
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        return oid;
    }

    private void checkEntry(Entry entry, String schemaEntity) {
        if (entry == null) {
            String msg = I18n.err(I18n.ERR_10007, schemaEntity);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void checkDescription(SchemaObject description, String schemaEntity) {
        if (description == null) {
            String msg = I18n.err(I18n.ERR_10008, schemaEntity);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private Schema getSchema(String schemaName, Registries registries) {
        Schema schema;
        if (Strings.isEmpty(schemaName)) {
            schemaName = "other";
        }
        if ((schema = registries.getLoadedSchema(schemaName)) == null) {
            String msg = I18n.err(I18n.ERR_10009, schemaName);
            LOG.error(msg);
        }
        return schema;
    }

    @Override
    public Schema getSchema(Entry entry) throws LdapException {
        String[] dependencies = EMPTY_ARRAY;
        boolean isDisabled = false;
        if (entry == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_10010, new Object[0]));
        }
        if (entry.get("cn") == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_10011, new Object[0]));
        }
        String name = entry.get("cn").getString();
        if (entry.get("creatorsName") == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_10012, "creatorsName"));
        }
        String owner = entry.get("creatorsName").getString();
        if (entry.get("m-disabled") != null) {
            String value = entry.get("m-disabled").getString();
            value = value.toUpperCase();
            isDisabled = value.equals("TRUE");
        }
        if (entry.get("m-dependencies") != null) {
            HashSet<String> depsSet = new HashSet<String>();
            Attribute depsAttr = entry.get("m-dependencies");
            for (Value value : depsAttr) {
                depsSet.add(value.getString());
            }
            dependencies = depsSet.toArray(EMPTY_ARRAY);
        }
        return new DefaultSchema(name, owner, dependencies, isDisabled);
    }

    private SyntaxChecker classLoadSyntaxChecker(SchemaManager schemaManager, String oid, String className, Attribute byteCode) throws Exception {
        Class<?> clazz = null;
        SyntaxChecker syntaxChecker = null;
        String byteCodeStr = "";
        if (byteCode == null) {
            clazz = Class.forName(className);
        } else {
            this.classLoader.setAttribute(byteCode);
            clazz = this.classLoader.loadClass(className);
            byteCodeStr = new String(Base64.encode(byteCode.getBytes()));
        }
        syntaxChecker = (SyntaxChecker)clazz.newInstance();
        syntaxChecker.setBytecode(byteCodeStr);
        syntaxChecker.setFqcn(className);
        syntaxChecker.setOid(oid);
        syntaxChecker.setSchemaManager(schemaManager);
        return syntaxChecker;
    }

    @Override
    public SyntaxChecker getSyntaxChecker(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkEntry(entry, "SyntaxChecker");
        String oid = this.getOid(entry, "SyntaxChecker");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err(I18n.ERR_10013, entry.getDn().getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10014, entry.getDn().getName(), schemaName);
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String className = this.getFqcn(entry, "SyntaxChecker");
        Attribute byteCode = entry.get("m-bytecode");
        try {
            SyntaxChecker syntaxChecker = this.classLoadSyntaxChecker(schemaManager, oid, className, byteCode);
            this.setSchemaObjectProperties((SchemaObject)syntaxChecker, entry, schema);
            return syntaxChecker;
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), e);
        }
    }

    @Override
    public SyntaxChecker getSyntaxChecker(SchemaManager schemaManager, SyntaxCheckerDescription syntaxCheckerDescription, Registries targetRegistries, String schemaName) throws Exception {
        this.checkDescription(syntaxCheckerDescription, "SyntaxChecker");
        String oid = this.getOid(syntaxCheckerDescription, "SyntaxChecker");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10013, syntaxCheckerDescription.getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn(syntaxCheckerDescription, "SyntaxChecker");
        Attribute byteCode = this.getByteCode(syntaxCheckerDescription, "SyntaxChecker");
        SyntaxChecker syntaxChecker = this.classLoadSyntaxChecker(schemaManager, oid, fqcn, byteCode);
        this.setSchemaObjectProperties((SchemaObject)syntaxChecker, syntaxCheckerDescription, schema);
        return syntaxChecker;
    }

    private LdapComparator<?> classLoadComparator(SchemaManager schemaManager, String oid, String className, Attribute byteCode) throws Exception {
        String byteCodeStr;
        LdapComparator comparator;
        block4: {
            comparator = null;
            Class<?> clazz = null;
            byteCodeStr = "";
            if (byteCode == null) {
                clazz = Class.forName(className);
            } else {
                this.classLoader.setAttribute(byteCode);
                clazz = this.classLoader.loadClass(className);
                byteCodeStr = new String(Base64.encode(byteCode.getBytes()));
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                comparator = (LdapComparator)constructor.newInstance(oid);
            }
            catch (NoSuchMethodException nsme) {
                clazz.getConstructor(new Class[0]);
                comparator = (LdapComparator)clazz.newInstance();
                if (comparator.getOid().equals(oid)) break block4;
                String msg = I18n.err(I18n.ERR_10015, oid, comparator.getOid());
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg, nsme);
            }
        }
        comparator.setBytecode(byteCodeStr);
        comparator.setFqcn(className);
        comparator.setSchemaManager(schemaManager);
        return comparator;
    }

    @Override
    public LdapComparator<?> getLdapComparator(SchemaManager schemaManager, LdapComparatorDescription comparatorDescription, Registries targetRegistries, String schemaName) throws Exception {
        this.checkDescription(comparatorDescription, "Comparator");
        String oid = this.getOid(comparatorDescription, "Comparator");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10016, comparatorDescription.getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn(comparatorDescription, "Comparator");
        Attribute byteCode = this.getByteCode(comparatorDescription, "Comparator");
        LdapComparator<?> comparator = this.classLoadComparator(schemaManager, oid, fqcn, byteCode);
        this.setSchemaObjectProperties(comparator, comparatorDescription, schema);
        return comparator;
    }

    @Override
    public LdapComparator<?> getLdapComparator(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkEntry(entry, "Comparator");
        String oid = this.getOid(entry, "Comparator");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err(I18n.ERR_10016, entry.getDn().getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10017, entry.getDn().getName(), schemaName);
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String fqcn = this.getFqcn(entry, "Comparator");
        Attribute byteCode = entry.get("m-bytecode");
        try {
            LdapComparator<?> comparator = this.classLoadComparator(schemaManager, oid, fqcn, byteCode);
            this.setSchemaObjectProperties(comparator, entry, schema);
            return comparator;
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), e);
        }
    }

    private Normalizer classLoadNormalizer(SchemaManager schemaManager, String oid, String className, Attribute byteCode) throws Exception {
        Class<?> clazz = null;
        Normalizer normalizer = null;
        String byteCodeStr = "";
        if (byteCode == null) {
            clazz = Class.forName(className);
        } else {
            this.classLoader.setAttribute(byteCode);
            clazz = this.classLoader.loadClass(className);
            byteCodeStr = new String(Base64.encode(byteCode.getBytes()));
        }
        normalizer = (Normalizer)clazz.newInstance();
        normalizer.setBytecode(byteCodeStr);
        normalizer.setFqcn(className);
        normalizer.setOid(oid);
        normalizer.setSchemaManager(schemaManager);
        return normalizer;
    }

    @Override
    public Normalizer getNormalizer(SchemaManager schemaManager, NormalizerDescription normalizerDescription, Registries targetRegistries, String schemaName) throws Exception {
        this.checkDescription(normalizerDescription, "Normalizer");
        String oid = this.getOid(normalizerDescription, "Normalizer");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10018, normalizerDescription.getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn(normalizerDescription, "Normalizer");
        Attribute byteCode = this.getByteCode(normalizerDescription, "Normalizer");
        Normalizer normalizer = this.classLoadNormalizer(schemaManager, oid, fqcn, byteCode);
        this.setSchemaObjectProperties((SchemaObject)normalizer, normalizerDescription, schema);
        return normalizer;
    }

    @Override
    public Normalizer getNormalizer(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkEntry(entry, "Normalizer");
        String oid = this.getOid(entry, "Normalizer");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err(I18n.ERR_10018, entry.getDn().getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10019, entry.getDn().getName(), schemaName);
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String className = this.getFqcn(entry, "Normalizer");
        Attribute byteCode = entry.get("m-bytecode");
        try {
            Normalizer normalizer = this.classLoadNormalizer(schemaManager, oid, className, byteCode);
            this.setSchemaObjectProperties((SchemaObject)normalizer, entry, schema);
            return normalizer;
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), e);
        }
    }

    @Override
    public LdapSyntax getSyntax(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapInvalidAttributeValueException, LdapUnwillingToPerformException {
        this.checkEntry(entry, "Syntax");
        String oid = this.getOid(entry, "Syntax");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err(I18n.ERR_10020, entry.getDn().getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10021, entry.getDn().getName(), schemaName);
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        LdapSyntax syntax = new LdapSyntax(oid);
        this.setSchemaObjectProperties((SchemaObject)syntax, entry, schema);
        return syntax;
    }

    @Override
    public MatchingRule getMatchingRule(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapUnwillingToPerformException, LdapInvalidAttributeValueException {
        this.checkEntry(entry, "MatchingRule");
        String oid = this.getOid(entry, "MatchingRule");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err(I18n.ERR_10022, entry.getDn().getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10023, entry.getDn().getName(), schemaName);
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        MutableMatchingRule matchingRule = new MutableMatchingRule(oid);
        Attribute mSyntax = entry.get("m-syntax");
        if (mSyntax != null) {
            matchingRule.setSyntaxOid(mSyntax.getString());
        }
        this.setSchemaObjectProperties((SchemaObject)matchingRule, entry, schema);
        return matchingRule;
    }

    private List<String> getStrings(Attribute attr) {
        if (attr == null) {
            return EMPTY_LIST;
        }
        ArrayList<String> strings = new ArrayList<String>(attr.size());
        for (Value value : attr) {
            strings.add(value.getString());
        }
        return strings;
    }

    @Override
    public ObjectClass getObjectClass(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        Attribute mTypeObjectClass;
        Attribute mMust;
        Attribute mMay;
        this.checkEntry(entry, "ObjectCLass");
        String oid = this.getOid(entry, "ObjectCLass");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err(I18n.ERR_10024, entry.getDn().getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10025, entry.getDn().getName(), schemaName);
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        MutableObjectClass oc = new MutableObjectClass(oid);
        Attribute mSuperiors = entry.get("m-supObjectClass");
        if (mSuperiors != null) {
            oc.setSuperiorOids(this.getStrings(mSuperiors));
        }
        if ((mMay = entry.get("m-may")) != null) {
            oc.setMayAttributeTypeOids(this.getStrings(mMay));
        }
        if ((mMust = entry.get("m-must")) != null) {
            oc.setMustAttributeTypeOids(this.getStrings(mMust));
        }
        if ((mTypeObjectClass = entry.get("m-typeObjectClass")) != null) {
            String type = mTypeObjectClass.getString();
            oc.setType(ObjectClassTypeEnum.getClassType(type));
        }
        this.setSchemaObjectProperties((SchemaObject)oc, entry, schema);
        return oc;
    }

    @Override
    public AttributeType getAttributeType(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapInvalidAttributeValueException, LdapUnwillingToPerformException {
        Attribute mUsage;
        Attribute mNoUserModification;
        Attribute mSingleValued;
        Attribute mCollective;
        Attribute mSupAttributeType;
        Attribute mSubstr;
        Attribute mOrdering;
        Attribute mEquality;
        Attribute mSyntaxLength;
        this.checkEntry(entry, "AttributeType");
        String oid = this.getOid(entry, "AttributeType");
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err(I18n.ERR_10026, entry.getDn().getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_10027, entry.getDn().getName(), schemaName);
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        MutableAttributeType attributeType = new MutableAttributeType(oid);
        Attribute mSyntax = entry.get("m-syntax");
        if (mSyntax != null && mSyntax.get() != null) {
            attributeType.setSyntaxOid(mSyntax.getString());
        }
        if ((mSyntaxLength = entry.get("m-length")) != null) {
            attributeType.setSyntaxLength(Integer.parseInt(mSyntaxLength.getString()));
        }
        if ((mEquality = entry.get("m-equality")) != null) {
            attributeType.setEqualityOid(mEquality.getString());
        }
        if ((mOrdering = entry.get("m-ordering")) != null) {
            attributeType.setOrderingOid(mOrdering.getString());
        }
        if ((mSubstr = entry.get("m-substr")) != null) {
            attributeType.setSubstringOid(mSubstr.getString());
        }
        if ((mSupAttributeType = entry.get("m-supAttributeType")) != null) {
            attributeType.setSuperiorOid(mSupAttributeType.getString());
        }
        if ((mCollective = entry.get("m-collective")) != null) {
            String val = mCollective.getString();
            attributeType.setCollective(val.equalsIgnoreCase("TRUE"));
        }
        if ((mSingleValued = entry.get("m-singleValue")) != null) {
            String val = mSingleValued.getString();
            attributeType.setSingleValued(val.equalsIgnoreCase("TRUE"));
        }
        if ((mNoUserModification = entry.get("m-noUserModification")) != null) {
            String val = mNoUserModification.getString();
            attributeType.setUserModifiable(!val.equalsIgnoreCase("TRUE"));
        }
        if ((mUsage = entry.get("m-usage")) != null) {
            attributeType.setUsage(UsageEnum.getUsage(mUsage.getString()));
        }
        this.setSchemaObjectProperties((SchemaObject)attributeType, entry, schema);
        return attributeType;
    }

    private String getFqcn(Entry entry, String objectType) throws LdapInvalidAttributeValueException {
        Attribute mFqcn = entry.get("m-fqcn");
        if (mFqcn == null) {
            String msg = I18n.err(I18n.ERR_10028, objectType, "m-fqcn");
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        return mFqcn.getString();
    }

    private String getFqcn(LoadableSchemaObject description, String objectType) {
        String mFqcn = description.getFqcn();
        if (mFqcn == null) {
            String msg = I18n.err(I18n.ERR_10028, objectType, "m-fqcn");
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        return mFqcn;
    }

    private Attribute getByteCode(LoadableSchemaObject description, String objectType) {
        String byteCodeString = description.getBytecode();
        if (byteCodeString == null) {
            String msg = I18n.err(I18n.ERR_10028, objectType, "m-bytecode");
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        byte[] bytecode = Base64.decode(byteCodeString.toCharArray());
        DefaultAttribute attr = new DefaultAttribute("m-bytecode", (byte[][])new byte[][]{bytecode});
        return attr;
    }

    private String getStringValue(Attribute attribute) {
        Value<?> value = attribute.get();
        if (value instanceof BinaryValue) {
            return Strings.utf8ToString(value.getBytes());
        }
        return value.getString();
    }

    private void setSchemaObjectProperties(SchemaObject schemaObject, Entry entry, Schema schema) throws LdapInvalidAttributeValueException {
        Attribute xReadOnly;
        Attribute xNotHumanReadable;
        Attribute mDisabled;
        Attribute names;
        Attribute mDescription;
        Attribute mObsolete = entry.get("m-obsolete");
        if (mObsolete != null) {
            String val = mObsolete.getString();
            schemaObject.setObsolete(val.equalsIgnoreCase("TRUE"));
        }
        if ((mDescription = entry.get("m-description")) != null) {
            schemaObject.setDescription(this.getStringValue(mDescription));
        }
        if ((names = entry.get("m-name")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Value name : names) {
                values.add(name.getString());
            }
            schemaObject.setNames(values);
        }
        if ((mDisabled = entry.get("m-disabled")) != null) {
            String val = mDisabled.getString();
            schemaObject.setEnabled(!val.equalsIgnoreCase("TRUE"));
        } else {
            schemaObject.setEnabled(schema != null && schema.isEnabled());
        }
        schemaObject.setSchemaName(schema.getSchemaName());
        Attribute xSchema = entry.get("X-SCHEMA");
        if (xSchema != null) {
            String schemaName = xSchema.getString();
            if (!schema.getSchemaName().equalsIgnoreCase(schemaName)) {
                LOG.warn("Schema (" + schema.getSchemaName() + ") and X-SCHEMA (" + schemaName + ") are different : " + entry);
            }
            schemaObject.addExtension("X-SCHEMA", schemaName);
        }
        if ((xNotHumanReadable = entry.get("X-NOT-HUMAN-READABLE")) != null) {
            String value = xNotHumanReadable.getString();
            schemaObject.addExtension("X-NOT-HUMAN-READABLE", value);
        }
        if ((xReadOnly = entry.get("X-READ-ONLY")) != null) {
            String value = xReadOnly.getString();
            schemaObject.addExtension("X-READ-ONLY", value);
        }
    }

    private void setSchemaObjectProperties(SchemaObject schemaObject, SchemaObject description, Schema schema) {
        schemaObject.setObsolete(description.isObsolete());
        schemaObject.setDescription(description.getDescription());
        schemaObject.setNames(description.getNames());
        schemaObject.setEnabled(schema.isEnabled());
        schemaObject.setReadOnly(false);
        schemaObject.setSpecification(description.getSpecification());
        schemaObject.setSchemaName(schema.getSchemaName());
        schemaObject.setExtensions(description.getExtensions());
    }
}

