/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifControl;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifReader
implements Iterable<LdifEntry>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LdifReader.class);
    protected List<String> lines;
    protected int position;
    protected static final int DEFAULT_VERSION = 1;
    protected int version;
    protected static final int LDIF_ENTRY = 0;
    protected static final int CHANGE = 1;
    protected static final int UNKNOWN = 2;
    protected long sizeLimit = 1024000L;
    protected static final long SIZE_LIMIT_DEFAULT = 1024000L;
    protected static final int MOD_SPEC = 0;
    protected static final int ATTRVAL_SPEC = 1;
    protected static final int ATTRVAL_SPEC_OR_SEP = 2;
    protected LdifEntry prefetched;
    protected Reader reader;
    protected boolean containsEntries;
    protected boolean containsChanges;
    protected SchemaManager schemaManager;
    protected Exception error;
    protected int entryLen = 0;
    protected long entryOffset = 0L;
    protected long offset = 0L;
    protected int lineNumber;
    protected boolean validateDn = true;
    private int oidCounter = 0;

    public LdifReader() {
        this.lines = new ArrayList<String>();
        this.position = 0;
        this.version = 1;
    }

    public LdifReader(SchemaManager schemaManager) {
        this.lines = new ArrayList<String>();
        this.position = 0;
        this.version = 1;
        this.schemaManager = schemaManager;
    }

    private void initReader(BufferedReader reader) throws LdapException {
        this.reader = reader;
        this.init();
    }

    public void init() throws LdapException {
        this.lines = new ArrayList<String>();
        this.position = 0;
        this.version = 1;
        this.containsChanges = false;
        this.containsEntries = false;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
    }

    public LdifReader(String ldifFileName) throws LdapLdifException {
        this(new File(ldifFileName));
    }

    public LdifReader(Reader in) throws LdapException {
        this.initReader(new BufferedReader(in));
    }

    public LdifReader(InputStream in) throws LdapException {
        this.initReader(new BufferedReader(new InputStreamReader(in, Charset.defaultCharset())));
    }

    public LdifReader(File file) throws LdapLdifException {
        this(file, null);
    }

    public LdifReader(File file, SchemaManager schemaManager) throws LdapLdifException {
        if (!file.exists()) {
            String msg = I18n.err(I18n.ERR_12010_CANNOT_FIND_FILE, file.getAbsoluteFile());
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        if (!file.canRead()) {
            String msg = I18n.err(I18n.ERR_12011_CANNOT_READ_FILE, file.getName());
            LOG.error(msg);
            throw new LdapLdifException(msg);
        }
        this.schemaManager = schemaManager;
        try {
            this.initReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset())));
        }
        catch (FileNotFoundException fnfe) {
            String msg = I18n.err(I18n.ERR_12010_CANNOT_FIND_FILE, file.getAbsoluteFile());
            LOG.error(msg);
            throw new LdapLdifException(msg, fnfe);
        }
        catch (LdapInvalidDnException lide) {
            throw new LdapLdifException(lide.getMessage(), lide);
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage(), le);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    private void parseFill(char[] document) {
        while (Chars.isCharASCII(document, this.position, ' ')) {
            ++this.position;
        }
    }

    private String parseNumber(char[] document) {
        int initPos = this.position;
        while (Chars.isDigit(document, this.position)) {
            ++this.position;
        }
        if (this.position == initPos) {
            return null;
        }
        return new String(document, initPos, this.position - initPos);
    }

    protected ChangeType parseChangeType(String line) {
        ChangeType operation = ChangeType.Add;
        String modOp = Strings.trim(line.substring("changetype:".length()));
        if ("add".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Add;
        } else if ("delete".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Delete;
        } else if ("modify".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Modify;
        } else if ("moddn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModDn;
        } else if ("modrdn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModRdn;
        }
        return operation;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String parseDn(String line) throws LdapLdifException {
        String dn;
        String lowerLine = Strings.toLowerCaseAscii(line);
        if (!lowerLine.startsWith("dn:") && !lowerLine.startsWith("Dn:")) {
            LOG.error(I18n.err(I18n.ERR_12016_DN_EXPECTED, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12013_NO_DN, new Object[0]));
        }
        int length = line.length();
        if (length == 3) {
            dn = "";
        } else if (line.charAt(3) == ':') {
            if (length <= 4) {
                LOG.error(I18n.err(I18n.ERR_12012_EMPTY_DN_NOT_ALLOWED, this.lineNumber));
                throw new LdapLdifException(I18n.err(I18n.ERR_12013_NO_DN, new Object[0]));
            }
            String trimmedLine = line.substring(4).trim();
            dn = Strings.utf8ToString(Base64.decode(trimmedLine.toCharArray()));
        } else {
            dn = line.substring(3).trim();
        }
        if (this.validateDn && !Dn.isValid(dn)) {
            String message = I18n.err(I18n.ERR_12017_INVALID_DN, dn, this.lineNumber);
            LOG.error(message);
            throw new LdapLdifException(message);
        }
        return dn;
    }

    protected static Object parseSimpleValue(String line, int pos) {
        if (line.length() > pos + 1) {
            char c = line.charAt(pos + 1);
            if (c == ':') {
                String value = Strings.trim(line.substring(pos + 2));
                return Base64.decode(value.toCharArray());
            }
            return Strings.trim(line.substring(pos + 1));
        }
        return null;
    }

    private Object getValue(String attributeName, byte[] value) {
        if (this.schemaManager != null) {
            AttributeType attributeType = this.schemaManager.getAttributeType(attributeName);
            if (attributeType != null) {
                if (attributeType.getSyntax().isHumanReadable()) {
                    return Strings.utf8ToString(value);
                }
                return value;
            }
            return value;
        }
        return value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object parseValue(String attributeName, String line, int pos) throws LdapLdifException {
        char cc;
        if (line.length() <= pos + 1) return null;
        char c = line.charAt(pos + 1);
        if (c == ':') {
            String value = Strings.trim(line.substring(pos + 2));
            byte[] decoded = Base64.decode(value.toCharArray());
            return this.getValue(attributeName, decoded);
        }
        if (c == '<') {
            String urlName = Strings.trim(line.substring(pos + 2));
            try {
                Object object;
                URL url = new URL(urlName);
                if (!"file".equals(url.getProtocol())) {
                    LOG.error(I18n.err(I18n.ERR_12025_BAD_PROTOCOL, new Object[0]));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12026_UNSUPPORTED_PROTOCOL, this.lineNumber));
                }
                String fileName = url.getFile();
                File file = new File(fileName);
                if (!file.exists()) {
                    LOG.error(I18n.err(I18n.ERR_12018_FILE_NOT_FOUND, fileName, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12019_BAD_URL_FILE_NOT_FOUND, new Object[0]));
                }
                long length = file.length();
                if (length > this.sizeLimit) {
                    String message = I18n.err(I18n.ERR_12020_FILE_TOO_BIG, fileName, this.lineNumber);
                    LOG.error(message);
                    throw new LdapLdifException(message);
                }
                byte[] data = new byte[(int)length];
                FilterInputStream inf = null;
                try {
                    inf = new DataInputStream(new FileInputStream(file));
                    ((DataInputStream)inf).readFully(data);
                    object = this.getValue(attributeName, data);
                }
                catch (FileNotFoundException fnfe) {
                    try {
                        LOG.error(I18n.err(I18n.ERR_12018_FILE_NOT_FOUND, fileName, this.lineNumber));
                        throw new LdapLdifException(I18n.err(I18n.ERR_12019_BAD_URL_FILE_NOT_FOUND, new Object[0]), fnfe);
                        catch (IOException ioe) {
                            LOG.error(I18n.err(I18n.ERR_12022_ERROR_READING_FILE, fileName, this.lineNumber));
                            throw new LdapLdifException(I18n.err(I18n.ERR_12023_ERROR_READING_BAD_URL, new Object[0]), ioe);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inf == null) throw throwable;
                            inf.close();
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            LOG.error(I18n.err(I18n.ERR_12024_CANNOT_CLOSE_FILE, ioe.getMessage(), this.lineNumber), (Throwable)ioe);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (inf == null) return object;
                    inf.close();
                    return object;
                }
                catch (IOException ioe) {
                    LOG.error(I18n.err(I18n.ERR_12024_CANNOT_CLOSE_FILE, ioe.getMessage(), this.lineNumber), (Throwable)ioe);
                }
                return object;
            }
            catch (MalformedURLException mue) {
                String message = I18n.err(I18n.ERR_12027_BAD_URL, urlName, this.lineNumber);
                LOG.error(message);
                throw new LdapLdifException(message, mue);
            }
        }
        String value = Strings.trimLeft(line.substring(pos + 1));
        int end = value.length();
        int i = value.length() - 1;
        while (i > 0 && (cc = value.charAt(i)) == ' ' && value.charAt(i - 1) != '\\') {
            end = i--;
        }
        String result = null;
        return value.substring(0, end);
    }

    private Control parseControl(String line) throws LdapLdifException {
        String lowerLine = Strings.toLowerCaseAscii(line).trim();
        int pos = 0;
        char[] controlValue = line.trim().toCharArray();
        int length = controlValue.length;
        if (pos > length) {
            LOG.error(I18n.err(I18n.ERR_12029_CONTROL_WITHOUT_OID, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12029_CONTROL_WITHOUT_OID, new Object[0]));
        }
        int initPos = pos;
        while (Chars.isCharASCII(controlValue, pos, '.') || Chars.isDigit(controlValue, pos)) {
            ++pos;
        }
        if (pos == initPos) {
            LOG.error(I18n.err(I18n.ERR_12029_CONTROL_WITHOUT_OID, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12029_CONTROL_WITHOUT_OID, new Object[0]));
        }
        String oidString = lowerLine.substring(0, pos);
        if (!Oid.isOid(oidString)) {
            String message = I18n.err(I18n.ERR_12031_INVALID_OID, oidString, this.lineNumber);
            LOG.error(message);
            throw new LdapLdifException(message);
        }
        LdifControl control = new LdifControl(oidString);
        while (Chars.isCharASCII(controlValue, pos, ' ')) {
            ++pos;
        }
        int criticalPos = lowerLine.indexOf(58);
        int criticalLength = criticalPos == -1 ? length - pos : criticalPos - pos;
        if (criticalLength == 4 && "true".equalsIgnoreCase(lowerLine.substring(pos, pos + 4))) {
            control.setCritical(true);
        } else if (criticalLength == 5 && "false".equalsIgnoreCase(lowerLine.substring(pos, pos + 5))) {
            control.setCritical(false);
        } else if (criticalLength != 0) {
            LOG.error(I18n.err(I18n.ERR_12033_INVALID_CRITICALITY, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12033_INVALID_CRITICALITY, new Object[0]));
        }
        if (criticalPos > 0) {
            if (Chars.isCharASCII(controlValue, criticalPos + 1, ':')) {
                pos = criticalPos + 2;
                while (Chars.isCharASCII(controlValue, pos, ' ')) {
                    ++pos;
                }
                byte[] value = Base64.decode(line.substring(pos).toCharArray());
                control.setValue(value);
            } else {
                if (Chars.isCharASCII(controlValue, criticalPos + 1, '<')) {
                    throw new NotImplementedException("See DIRSERVER-1547");
                }
                pos = criticalPos + 1;
                while (Chars.isCharASCII(controlValue, pos, ' ')) {
                    ++pos;
                }
                byte[] value = new byte[length - pos];
                for (int i = 0; i < length - pos; ++i) {
                    value[i] = (byte)controlValue[i + pos];
                }
                control.setValue(value);
            }
        }
        return control;
    }

    public static Attribute parseAttributeValue(String line) {
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            String attributeType = line.substring(0, colonIndex);
            Object attributeValue = LdifReader.parseSimpleValue(line, colonIndex);
            if (attributeValue instanceof String) {
                return new DefaultAttribute(attributeType, (String)attributeValue);
            }
            return new DefaultAttribute(attributeType, (byte[][])new byte[][]{(byte[])attributeValue});
        }
        return null;
    }

    public void parseAttributeValue(LdifEntry entry, String line, String lowerLine) throws LdapException {
        block8: {
            AttributeType at;
            int colonIndex = line.indexOf(58);
            String attributeType = lowerLine.substring(0, colonIndex);
            if (attributeType.equals("dn")) {
                LOG.error(I18n.err(I18n.ERR_12002_ENTRY_WITH_TWO_DNS, this.lineNumber));
                throw new LdapLdifException(I18n.err(I18n.ERR_12003_LDIF_ENTRY_WITH_TWO_DNS, new Object[0]));
            }
            Object attributeValue = this.parseValue(attributeType, line, colonIndex);
            if (this.schemaManager != null && (at = this.schemaManager.getAttributeType(attributeType)) != null) {
                if (at.getSyntax().isHumanReadable()) {
                    if (attributeValue instanceof byte[]) {
                        attributeValue = Strings.utf8ToString((byte[])attributeValue);
                    }
                } else if (attributeValue instanceof String) {
                    attributeValue = Strings.getBytesUtf8((String)attributeValue);
                }
            }
            try {
                entry.addAttribute(attributeType, attributeValue);
            }
            catch (Exception e) {
                if (this.schemaManager == null || !this.schemaManager.isRelaxed()) break block8;
                MutableAttributeType newAttributeType = new MutableAttributeType("1.3.6.1.4.1.18060.0.9999." + this.oidCounter++);
                newAttributeType.setNames(attributeType);
                newAttributeType.setSyntax((LdapSyntax)this.schemaManager.getLdapSyntaxRegistry().get("1.3.6.1.4.1.1466.115.121.1.15"));
                this.schemaManager.add(newAttributeType);
                entry.addAttribute(attributeType, attributeValue);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseModRdn(LdifEntry entry, Iterator<String> iter) throws LdapLdifException {
        if (!iter.hasNext()) {
            LOG.error(I18n.err(I18n.ERR_12035_BAD_MODRDN_OPERATION, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12035_BAD_MODRDN_OPERATION, new Object[0]));
        }
        String line = iter.next();
        String lowerLine = Strings.toLowerCaseAscii(line);
        if (!lowerLine.startsWith("newrdn::") && !lowerLine.startsWith("newrdn:")) {
            LOG.error(I18n.err(I18n.ERR_12035_BAD_MODRDN_OPERATION, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12035_BAD_MODRDN_OPERATION, new Object[0]));
        }
        int colonIndex = line.indexOf(58);
        Object attributeValue = this.parseValue(null, line, colonIndex);
        if (attributeValue instanceof String) {
            entry.setNewRdn((String)attributeValue);
        } else {
            entry.setNewRdn(Strings.utf8ToString((byte[])attributeValue));
        }
        if (!iter.hasNext()) {
            LOG.error(I18n.err(I18n.ERR_12038_NO_DELETEOLDRDN, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12038_NO_DELETEOLDRDN, new Object[0]));
        }
        line = iter.next();
        lowerLine = Strings.toLowerCaseAscii(line);
        if (lowerLine.startsWith("deleteoldrdn:")) {
            colonIndex = line.indexOf(58);
            attributeValue = this.parseValue(null, line, colonIndex);
            entry.setDeleteOldRdn("1".equals(attributeValue));
            return;
        }
        LOG.error(I18n.err(I18n.ERR_12038_NO_DELETEOLDRDN, this.lineNumber));
        throw new LdapLdifException(I18n.err(I18n.ERR_12038_NO_DELETEOLDRDN, new Object[0]));
    }

    private void parseModify(LdifEntry entry, Iterator<String> iter) throws LdapLdifException {
        int state = 0;
        String modified = null;
        ModificationOperation modificationType = ModificationOperation.ADD_ATTRIBUTE;
        DefaultAttribute attribute = null;
        boolean isEmptyValue = true;
        while (iter.hasNext()) {
            String line = iter.next();
            String lowerLine = Strings.toLowerCaseAscii(line);
            if (lowerLine.startsWith("-")) {
                if (state != 2 && state != 1) {
                    LOG.error(I18n.err(I18n.ERR_12040_BAD_MODIFY_SEPARATOR, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12040_BAD_MODIFY_SEPARATOR, new Object[0]));
                }
                if (isEmptyValue) {
                    if (state == 2) {
                        entry.addModification(modificationType, modified);
                    } else {
                        entry.addModification(modificationType, modified, null);
                    }
                } else {
                    entry.addModification(modificationType, attribute);
                }
                state = 0;
                isEmptyValue = true;
                continue;
            }
            if (lowerLine.startsWith("add:")) {
                if (state != 0 && state != 1) {
                    LOG.error(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, new Object[0]));
                }
                modified = Strings.trim(line.substring("add:".length()));
                modificationType = ModificationOperation.ADD_ATTRIBUTE;
                attribute = new DefaultAttribute(modified);
                state = 1;
                continue;
            }
            if (lowerLine.startsWith("delete:")) {
                if (state != 0 && state != 1) {
                    LOG.error(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, new Object[0]));
                }
                modified = Strings.trim(line.substring("delete:".length()));
                modificationType = ModificationOperation.REMOVE_ATTRIBUTE;
                attribute = new DefaultAttribute(modified);
                isEmptyValue = false;
                state = 2;
                continue;
            }
            if (lowerLine.startsWith("replace:")) {
                if (state != 0 && state != 1) {
                    LOG.error(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, new Object[0]));
                }
                modified = Strings.trim(line.substring("replace:".length()));
                modificationType = ModificationOperation.REPLACE_ATTRIBUTE;
                if (this.schemaManager != null) {
                    AttributeType attributeType = this.schemaManager.getAttributeType(modified);
                    attribute = new DefaultAttribute(modified, attributeType);
                } else {
                    attribute = new DefaultAttribute(modified);
                }
                state = 2;
                continue;
            }
            if (state != 1 && state != 2) {
                LOG.error(I18n.err(I18n.ERR_12040_BAD_MODIFY_SEPARATOR, this.lineNumber));
                throw new LdapLdifException(I18n.err(I18n.ERR_12040_BAD_MODIFY_SEPARATOR, new Object[0]));
            }
            int colonIndex = line.indexOf(58);
            String attributeType = line.substring(0, colonIndex);
            if (!attributeType.equalsIgnoreCase(modified)) {
                LOG.error(I18n.err(I18n.ERR_12044, this.lineNumber));
                throw new LdapLdifException(I18n.err(I18n.ERR_12045, new Object[0]));
            }
            if (attributeType.equalsIgnoreCase("dn")) {
                LOG.error(I18n.err(I18n.ERR_12002_ENTRY_WITH_TWO_DNS, this.lineNumber));
                throw new LdapLdifException(I18n.err(I18n.ERR_12003_LDIF_ENTRY_WITH_TWO_DNS, new Object[0]));
            }
            Object attributeValue = this.parseValue(attributeType, line, colonIndex);
            try {
                if (attributeValue instanceof String) {
                    attribute.add((String)attributeValue);
                } else {
                    attribute.add(new byte[][]{(byte[])attributeValue});
                }
            }
            catch (LdapInvalidAttributeValueException liave) {
                throw new LdapLdifException(liave.getMessage(), liave);
            }
            isEmptyValue = false;
            state = 2;
        }
        if (state != 0) {
            LOG.error(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12042_BAD_MODIFY_SEPARATOR_2, this.lineNumber));
        }
    }

    private void parseChange(LdifEntry entry, Iterator<String> iter, ChangeType operation) throws LdapException {
        entry.setChangeType(operation);
        switch (operation) {
            case Delete: {
                return;
            }
            case Add: {
                while (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = Strings.toLowerCaseAscii(line);
                    this.parseAttributeValue(entry, line, lowerLine);
                }
                return;
            }
            case Modify: {
                this.parseModify(entry, iter);
                return;
            }
            case ModDn: 
            case ModRdn: {
                this.parseModRdn(entry, iter);
                if (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = Strings.toLowerCaseAscii(line);
                    if (lowerLine.startsWith("newsuperior:")) {
                        int colonIndex = line.indexOf(58);
                        Object attributeValue = this.parseValue(null, line, colonIndex);
                        if (attributeValue instanceof String) {
                            entry.setNewSuperior((String)attributeValue);
                        } else {
                            entry.setNewSuperior(Strings.utf8ToString((byte[])attributeValue));
                        }
                    } else if (operation == ChangeType.ModDn) {
                        LOG.error(I18n.err(I18n.ERR_12046, this.lineNumber));
                        throw new LdapLdifException(I18n.err(I18n.ERR_12047, new Object[0]));
                    }
                }
                return;
            }
        }
        LOG.error(I18n.err(I18n.ERR_12048, this.lineNumber));
        throw new LdapLdifException(I18n.err(I18n.ERR_12049, new Object[0]));
    }

    protected LdifEntry parseEntry() throws LdapException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        String line = this.lines.get(0);
        this.lineNumber -= this.lines.size() - 1;
        String name = this.parseDn(line);
        Dn dn = null;
        try {
            dn = new Dn(this.schemaManager, name);
        }
        catch (LdapInvalidDnException lide) {
            dn = new Dn(name);
            Rdn rdn = dn.getRdn();
            for (Ava ava : rdn) {
                if (this.schemaManager == null || this.schemaManager.getAttributeType(ava.getType()) != null || !this.schemaManager.isRelaxed()) continue;
                MutableAttributeType newAttributeType = new MutableAttributeType("1.3.6.1.4.1.18060.0.9999." + this.oidCounter++);
                newAttributeType.setNames(ava.getType());
                newAttributeType.setSyntax((LdapSyntax)this.schemaManager.getLdapSyntaxRegistry().get("1.3.6.1.4.1.1466.115.121.1.15"));
                this.schemaManager.add(newAttributeType);
            }
            dn = new Dn(this.schemaManager, name);
        }
        LdifEntry entry = this.createLdifEntry(this.schemaManager);
        entry.setLengthBeforeParsing(this.entryLen);
        entry.setOffset(this.entryOffset);
        entry.setDn(dn);
        this.lines.remove(0);
        Iterator<String> iter = this.lines.iterator();
        boolean type = false;
        boolean controlSeen = false;
        boolean changeTypeSeen = false;
        ChangeType operation = ChangeType.Add;
        while (iter.hasNext()) {
            ++this.lineNumber;
            line = iter.next();
            String lowerLine = Strings.toLowerCaseAscii(line);
            if (lowerLine.startsWith("control:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err(I18n.ERR_12004_CHANGE_NOT_ALLOWED, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12005_NO_CHANGE, new Object[0]));
                }
                this.containsChanges = true;
                if (controlSeen) {
                    LOG.error(I18n.err(I18n.ERR_12050, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12051, new Object[0]));
                }
                Control control = this.parseControl(line.substring("control:".length()));
                entry.addControl(control);
                continue;
            }
            if (lowerLine.startsWith("changetype:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err(I18n.ERR_12004_CHANGE_NOT_ALLOWED, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12005_NO_CHANGE, new Object[0]));
                }
                this.containsChanges = true;
                if (changeTypeSeen) {
                    LOG.error(I18n.err(I18n.ERR_12052, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12053, new Object[0]));
                }
                type = true;
                controlSeen = true;
                operation = this.parseChangeType(line);
                this.parseChange(entry, iter, operation);
                changeTypeSeen = true;
                continue;
            }
            if (line.indexOf(58) > 0) {
                if (this.containsChanges) {
                    LOG.error(I18n.err(I18n.ERR_12004_CHANGE_NOT_ALLOWED, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12005_NO_CHANGE, new Object[0]));
                }
                this.containsEntries = true;
                if (controlSeen || changeTypeSeen) {
                    LOG.error(I18n.err(I18n.ERR_12054, this.lineNumber));
                    throw new LdapLdifException(I18n.err(I18n.ERR_12055, new Object[0]));
                }
                this.parseAttributeValue(entry, line, lowerLine);
                type = false;
                continue;
            }
            LOG.error(I18n.err(I18n.ERR_12056, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12057_BAD_ATTRIBUTE, new Object[0]));
        }
        if (!type) {
            LOG.debug("Read an entry : {}", (Object)entry);
        } else if (type) {
            entry.setChangeType(operation);
            LOG.debug("Read a modification : {}", (Object)entry);
        } else {
            LOG.error(I18n.err(I18n.ERR_12058_UNKNOWN_ENTRY_TYPE, this.lineNumber));
            throw new LdapLdifException(I18n.err(I18n.ERR_12059_UNKNOWN_ENTRY, new Object[0]));
        }
        return entry;
    }

    protected int parseVersion() throws LdapLdifException {
        int ver = 1;
        this.readLines();
        if (this.lines.size() == 0) {
            LOG.warn("The ldif file is empty");
            return ver;
        }
        String line = this.lines.get(0);
        char[] document = line.toCharArray();
        if (line.startsWith("version:")) {
            this.position += "version:".length();
            this.parseFill(document);
            String versionNumber = this.parseNumber(document);
            if (this.position != document.length) {
                LOG.error(I18n.err(I18n.ERR_12060_VERSION_NOT_A_NUMBER, this.lineNumber));
                throw new LdapLdifException(I18n.err(I18n.ERR_12061_LDIF_PARSING_ERROR, new Object[0]));
            }
            try {
                ver = Integer.parseInt(versionNumber);
            }
            catch (NumberFormatException nfe) {
                LOG.error(I18n.err(I18n.ERR_12060_VERSION_NOT_A_NUMBER, this.lineNumber));
                throw new LdapLdifException(I18n.err(I18n.ERR_12061_LDIF_PARSING_ERROR, new Object[0]), nfe);
            }
            LOG.debug("Ldif version : {}", (Object)versionNumber);
            this.lines.remove(0);
            if (this.lines.size() == 0) {
                int tmpEntryLen = this.entryLen;
                this.readLines();
                this.entryLen += tmpEntryLen;
            }
        } else {
            LOG.info("No version information : assuming version: 1");
        }
        return ver;
    }

    protected String getLine() throws IOException {
        return ((BufferedReader)this.reader).readLine();
    }

    protected void readLines() throws LdapLdifException {
        boolean insideComment = true;
        boolean isFirstLine = true;
        this.lines.clear();
        this.entryLen = 0;
        this.entryOffset = this.offset;
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            block6: while ((line = this.getLine()) != null) {
                ++this.lineNumber;
                if (line.length() == 0) {
                    if (isFirstLine) continue;
                    insideComment = false;
                    ++this.offset;
                    break;
                }
                switch (line.charAt(0)) {
                    case '#': {
                        insideComment = true;
                        break;
                    }
                    case ' ': {
                        isFirstLine = false;
                        if (insideComment) continue block6;
                        if (sb.length() == 0) {
                            LOG.error(I18n.err(I18n.ERR_12062_EMPTY_CONTINUATION_LINE, this.lineNumber));
                            throw new LdapLdifException(I18n.err(I18n.ERR_12061_LDIF_PARSING_ERROR, new Object[0]));
                        }
                        sb.append(line.substring(1));
                        insideComment = false;
                        break;
                    }
                    default: {
                        isFirstLine = false;
                        if (sb.length() != 0) {
                            this.lines.add(sb.toString());
                        }
                        sb = new StringBuffer(line);
                        insideComment = false;
                    }
                }
                byte[] data = Strings.getBytesUtf8(line);
                this.offset += (long)(data.length + 1);
                this.entryLen += data.length + 1;
            }
        }
        catch (IOException ioe) {
            throw new LdapLdifException(I18n.err(I18n.ERR_12063_ERROR_WHILE_READING_LDIF_LINE, new Object[0]), ioe);
        }
        if (sb.length() != 0) {
            this.lines.add(sb.toString());
        }
    }

    public List<LdifEntry> parseLdifFile(String fileName) throws LdapLdifException {
        return this.parseLdifFile(fileName, Strings.getDefaultCharsetName());
    }

    public List<LdifEntry> parseLdifFile(String fileName, String encoding) throws LdapLdifException {
        if (Strings.isEmpty(fileName)) {
            LOG.error(I18n.err(I18n.ERR_12064_EMPTY_FILE_NAME, new Object[0]));
            throw new LdapLdifException(I18n.err(I18n.ERR_12064_EMPTY_FILE_NAME, new Object[0]));
        }
        File file = new File(fileName);
        if (!file.exists()) {
            LOG.error(I18n.err(I18n.ERR_12066, fileName));
            throw new LdapLdifException(I18n.err(I18n.ERR_12067, fileName));
        }
        BufferedReader bufferReader = null;
        try {
            bufferReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName(encoding)));
            List<LdifEntry> list = this.parseLdif(bufferReader);
            return list;
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(I18n.err(I18n.ERR_12068, fileName));
            throw new LdapLdifException(I18n.err(I18n.ERR_12067, fileName), fnfe);
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage(), le);
        }
        finally {
            try {
                if (bufferReader != null) {
                    bufferReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public List<LdifEntry> parseLdif(String ldif) throws LdapLdifException {
        LOG.debug("Starts parsing ldif buffer");
        if (Strings.isEmpty(ldif)) {
            return new ArrayList<LdifEntry>();
        }
        BufferedReader bufferReader = new BufferedReader(new StringReader(ldif));
        try {
            List<LdifEntry> entries = this.parseLdif(bufferReader);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed {} entries.", (Object)entries.size());
            }
            List<LdifEntry> list = entries;
            return list;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err(I18n.ERR_12069, ne.getLocalizedMessage()));
            throw new LdapLdifException(I18n.err(I18n.ERR_12070, new Object[0]), ne);
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage(), le);
        }
        finally {
            try {
                bufferReader.close();
            }
            catch (IOException ioe) {
                throw new LdapLdifException(I18n.err(I18n.ERR_12024_CANNOT_CLOSE_FILE, new Object[0]), ioe);
            }
        }
    }

    private LdifEntry nextInternal() {
        try {
            LOG.debug("next(): -- called");
            LdifEntry entry = this.prefetched;
            this.readLines();
            try {
                this.prefetched = this.parseEntry();
            }
            catch (LdapLdifException ne) {
                this.error = ne;
                throw new NoSuchElementException(ne.getMessage());
            }
            catch (LdapException le) {
                throw new NoSuchElementException(le.getMessage());
            }
            LOG.debug("next(): -- returning ldif {}\n", (Object)entry);
            return entry;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err(I18n.ERR_12071, new Object[0]));
            this.error = ne;
            return null;
        }
    }

    public LdifEntry next() {
        return this.nextInternal();
    }

    public LdifEntry fetch() {
        return this.prefetched;
    }

    private boolean hasNextInternal() {
        return null != this.prefetched;
    }

    public boolean hasNext() {
        if (this.prefetched != null) {
            LOG.debug("hasNext(): -- returning true");
        } else {
            LOG.debug("hasNext(): -- returning false");
        }
        return this.hasNextInternal();
    }

    private void removeInternal() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        this.removeInternal();
    }

    @Override
    public Iterator<LdifEntry> iterator() {
        return new Iterator<LdifEntry>(){

            @Override
            public boolean hasNext() {
                return LdifReader.this.hasNextInternal();
            }

            @Override
            public LdifEntry next() {
                try {
                    return LdifReader.this.nextInternal();
                }
                catch (NoSuchElementException nse) {
                    LOG.error(nse.getMessage());
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public List<LdifEntry> parseLdif(BufferedReader reader) throws LdapException {
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>();
        this.reader = reader;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
        for (LdifEntry entry : this) {
            if (entry != null) {
                entries.add(entry);
                continue;
            }
            throw new LdapLdifException(I18n.err(I18n.ERR_12072, this.error.getLocalizedMessage()));
        }
        return entries;
    }

    public boolean containsEntries() {
        return this.containsEntries;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    protected LdifEntry createLdifEntry(SchemaManager schemaManager) {
        if (schemaManager != null) {
            return new LdifEntry(schemaManager);
        }
        return new LdifEntry();
    }

    public boolean isValidateDn() {
        return this.validateDn;
    }

    public void setValidateDn(boolean validateDn) {
        this.validateDn = validateDn;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.position = 0;
            this.reader.close();
            this.containsEntries = false;
            this.containsChanges = false;
            this.offset = 0L;
            this.entryOffset = 0L;
            this.lineNumber = 0;
        }
    }
}

