/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;

public class MutableObjectClass
extends ObjectClass {
    public static final long serialVersionUID = 1L;

    public MutableObjectClass(String oid) {
        super(oid);
    }

    public void addMayAttributeTypeOids(String ... oids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        for (String oid : oids) {
            this.mayAttributeTypeOids.add(oid);
        }
    }

    public void addMayAttributeTypes(AttributeType ... attributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        for (AttributeType attributeType : attributeTypes) {
            if (this.mayAttributeTypeOids.contains(attributeType.getOid())) continue;
            this.mayAttributeTypes.add(attributeType);
            this.mayAttributeTypeOids.add(attributeType.getOid());
        }
    }

    public void setMayAttributeTypeOids(List<String> mayAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.mayAttributeTypeOids = mayAttributeTypeOids;
    }

    public void setMayAttributeTypes(List<AttributeType> mayAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.mayAttributeTypes = mayAttributeTypes;
        this.mayAttributeTypeOids.clear();
        for (AttributeType may : mayAttributeTypes) {
            this.mayAttributeTypeOids.add(may.getOid());
        }
    }

    public void updateMayAttributeTypes(List<AttributeType> mayAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.mayAttributeTypes.clear();
        this.mayAttributeTypes.addAll(mayAttributeTypes);
        this.mayAttributeTypeOids.clear();
        for (AttributeType may : mayAttributeTypes) {
            this.mayAttributeTypeOids.add(may.getOid());
        }
    }

    public void addMustAttributeTypeOids(String ... oids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        for (String oid : oids) {
            this.mustAttributeTypeOids.add(oid);
        }
    }

    public void addMustAttributeTypes(AttributeType ... attributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        for (AttributeType attributeType : attributeTypes) {
            if (this.mustAttributeTypeOids.contains(attributeType.getOid())) continue;
            this.mustAttributeTypes.add(attributeType);
            this.mustAttributeTypeOids.add(attributeType.getOid());
        }
    }

    public void setMustAttributeTypeOids(List<String> mustAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.mustAttributeTypeOids = mustAttributeTypeOids;
    }

    public void setMustAttributeTypes(List<AttributeType> mustAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.mustAttributeTypes = mustAttributeTypes;
        this.mustAttributeTypeOids.clear();
        for (AttributeType may : mustAttributeTypes) {
            this.mustAttributeTypeOids.add(may.getOid());
        }
    }

    public void updateMustAttributeTypes(List<AttributeType> mustAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.mustAttributeTypes.clear();
        this.mustAttributeTypes.addAll(mustAttributeTypes);
        this.mustAttributeTypeOids.clear();
        for (AttributeType must : mustAttributeTypes) {
            this.mustAttributeTypeOids.add(must.getOid());
        }
    }

    public void addSuperiorOids(String ... oids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        for (String oid : oids) {
            if (this.superiorOids.contains(oid)) continue;
            this.superiorOids.add(oid);
        }
    }

    public void addSuperior(MutableObjectClass ... objectClasses) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        for (MutableObjectClass objectClass : objectClasses) {
            if (this.superiorOids.contains(objectClass.getOid())) continue;
            this.superiorOids.add(objectClass.getOid());
            this.superiors.add(objectClass);
        }
    }

    public void setSuperiors(List<ObjectClass> superiors) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superiors = superiors;
        this.superiorOids.clear();
        for (ObjectClass oc : superiors) {
            this.superiorOids.add(oc.getOid());
        }
    }

    public void updateSuperiors(List<ObjectClass> superiors) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superiors.clear();
        this.superiors.addAll(superiors);
        this.superiorOids.clear();
        for (ObjectClass oc : superiors) {
            this.superiorOids.add(oc.getOid());
        }
    }

    public void setSuperiorOids(List<String> superiorOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.superiorOids = superiorOids;
    }

    public void setType(ObjectClassTypeEnum objectClassType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, this.getName()));
        }
        this.objectClassType = objectClassType;
    }

    @Override
    public void clear() {
        super.clear();
        this.mayAttributeTypes.clear();
        this.mayAttributeTypeOids.clear();
        this.mustAttributeTypes.clear();
        this.mustAttributeTypeOids.clear();
        this.superiors.clear();
        this.superiorOids.clear();
    }
}

