/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.daemon;

import org.apache.directory.daemon.Bootstrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class TanukiBootstrapper
extends Bootstrapper
implements WrapperListener {
    private static final Logger log = LoggerFactory.getLogger(Bootstrapper.class);

    private TanukiBootstrapper() {
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new TanukiBootstrapper(), (String[])args);
    }

    public Integer start(String[] args) {
        this.setInstallationLayout(args[0]);
        this.setParentLoader(Thread.currentThread().getContextClassLoader());
        this.callInit(TanukiBootstrapper.shift(args, 1));
        this.callStart();
        return null;
    }

    public int stop(int exitCode) {
        log.info("Attempting graceful shutdown of this server instance");
        this.callStop(EMPTY_STRARRAY);
        this.callDestroy();
        log.info("Completed graceful shutdown...");
        return exitCode;
    }

    public void controlEvent(int event) {
        log.error("Recvd Event: " + event);
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }
}

