/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.directory.scim.spec.filter.CompareOperator;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.ValueFilterExpression;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;

public final class AttributeComparisonExpression
implements FilterExpression,
ValueFilterExpression {
    private static final long serialVersionUID = -2865840428089850575L;
    private final AttributeReference attributePath;
    private final CompareOperator operation;
    private final Object compareValue;
    private static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd";
    private static final String ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SS";
    private static final String QUOTE = "\"";

    @Override
    public String toFilter() {
        String filter = this.attributePath.getFullyQualifiedAttributeName() + " " + this.operation + " " + this.createCompareValueString();
        return filter;
    }

    @Override
    public String toUnqualifiedFilter() {
        String subAttributeName = this.attributePath.getSubAttributeName();
        String unqualifiedAttributeName = subAttributeName != null ? subAttributeName : this.attributePath.getAttributeName();
        return unqualifiedAttributeName + " " + this.operation + " " + this.createCompareValueString();
    }

    public static String toDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO_8601_DATE_FORMAT);
        return dateFormat.format(date);
    }

    public static String toDateTimeString(Date date) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(ISO_8601_DATE_TIME_FORMAT);
        return dateTimeFormat.format(date);
    }

    public static String toDateString(LocalDate ld) {
        return ld.format(DateTimeFormatter.ISO_DATE);
    }

    public static String toDateTimeString(LocalDateTime ldt) {
        return ldt.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @Override
    public void setAttributePath(String urn, String parentAttributeName) {
        this.attributePath.setUrn(urn);
        String subAttributeName = this.attributePath.getAttributeName();
        this.attributePath.setAttributeName(parentAttributeName);
        this.attributePath.setSubAttributeName(subAttributeName);
    }

    private String createCompareValueString() {
        Object compareValueString;
        if (this.compareValue == null) {
            compareValueString = "null";
        } else if (this.compareValue instanceof String) {
            String escaped = StringEscapeUtils.escapeEcmaScript((String)((String)this.compareValue)).replaceAll("\\\\/", "/").replaceAll("\\\\'", "'");
            compareValueString = QUOTE + escaped + QUOTE;
        } else {
            compareValueString = this.compareValue instanceof Date ? QUOTE + AttributeComparisonExpression.toDateTimeString((Date)this.compareValue) + QUOTE : (this.compareValue instanceof LocalDate ? QUOTE + AttributeComparisonExpression.toDateString((LocalDate)this.compareValue) + QUOTE : (this.compareValue instanceof LocalDateTime ? QUOTE + AttributeComparisonExpression.toDateTimeString((LocalDateTime)this.compareValue) + QUOTE : this.compareValue.toString()));
        }
        return compareValueString;
    }

    @Generated
    public AttributeComparisonExpression(AttributeReference attributePath, CompareOperator operation, Object compareValue) {
        this.attributePath = attributePath;
        this.operation = operation;
        this.compareValue = compareValue;
    }

    @Generated
    public AttributeReference getAttributePath() {
        return this.attributePath;
    }

    @Generated
    public CompareOperator getOperation() {
        return this.operation;
    }

    @Generated
    public Object getCompareValue() {
        return this.compareValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeComparisonExpression)) {
            return false;
        }
        AttributeComparisonExpression other = (AttributeComparisonExpression)o;
        AttributeReference this$attributePath = this.getAttributePath();
        AttributeReference other$attributePath = other.getAttributePath();
        if (this$attributePath == null ? other$attributePath != null : !((Object)this$attributePath).equals(other$attributePath)) {
            return false;
        }
        CompareOperator this$operation = this.getOperation();
        CompareOperator other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        Object this$compareValue = this.getCompareValue();
        Object other$compareValue = other.getCompareValue();
        return !(this$compareValue == null ? other$compareValue != null : !this$compareValue.equals(other$compareValue));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AttributeReference $attributePath = this.getAttributePath();
        result = result * 59 + ($attributePath == null ? 43 : ((Object)$attributePath).hashCode());
        CompareOperator $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        Object $compareValue = this.getCompareValue();
        result = result * 59 + ($compareValue == null ? 43 : $compareValue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AttributeComparisonExpression(attributePath=" + this.getAttributePath() + ", operation=" + this.getOperation() + ", compareValue=" + this.getCompareValue() + ")";
    }
}

