/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import lombok.Generated;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.ValueFilterExpression;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;

public final class AttributePresentExpression
implements FilterExpression,
ValueFilterExpression {
    private static final long serialVersionUID = -4491412651236977273L;
    private final AttributeReference attributePath;

    @Override
    public String toFilter() {
        return this.attributePath.getFullyQualifiedAttributeName() + " PR";
    }

    @Override
    public String toUnqualifiedFilter() {
        String subAttributeName = this.attributePath.getSubAttributeName();
        String attributeName = subAttributeName != null ? subAttributeName : this.attributePath.getAttributeName();
        return attributeName + " PR";
    }

    @Override
    public void setAttributePath(String urn, String parentAttributeName) {
        this.attributePath.setUrn(urn);
        String subAttributeName = this.attributePath.getAttributeName();
        this.attributePath.setAttributeName(parentAttributeName);
        this.attributePath.setSubAttributeName(subAttributeName);
    }

    @Generated
    public AttributePresentExpression(AttributeReference attributePath) {
        this.attributePath = attributePath;
    }

    @Generated
    public AttributeReference getAttributePath() {
        return this.attributePath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributePresentExpression)) {
            return false;
        }
        AttributePresentExpression other = (AttributePresentExpression)o;
        AttributeReference this$attributePath = this.getAttributePath();
        AttributeReference other$attributePath = other.getAttributePath();
        return !(this$attributePath == null ? other$attributePath != null : !((Object)this$attributePath).equals(other$attributePath));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AttributeReference $attributePath = this.getAttributePath();
        result = result * 59 + ($attributePath == null ? 43 : ((Object)$attributePath).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AttributePresentExpression(attributePath=" + this.getAttributePath() + ")";
    }
}

