/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import java.util.function.BiFunction;
import org.apache.directory.scim.spec.filter.AttributeComparisonExpression;
import org.apache.directory.scim.spec.filter.AttributePresentExpression;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.GroupExpression;
import org.apache.directory.scim.spec.filter.LogicalExpression;
import org.apache.directory.scim.spec.filter.LogicalOperator;
import org.apache.directory.scim.spec.filter.ValuePathExpression;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.schema.AttributeContainer;
import org.apache.directory.scim.spec.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFilterExpressionMapper<R>
implements BiFunction<FilterExpression, AttributeContainer, R> {
    private static final Logger log = LoggerFactory.getLogger(BaseFilterExpressionMapper.class);

    @Override
    public R apply(FilterExpression expression, AttributeContainer attributeContainer) {
        if (expression instanceof AttributeComparisonExpression) {
            return this.apply((AttributeComparisonExpression)expression, attributeContainer);
        }
        if (expression instanceof LogicalExpression) {
            return this.apply((LogicalExpression)expression, attributeContainer);
        }
        if (expression instanceof GroupExpression) {
            return this.apply((GroupExpression)expression, attributeContainer);
        }
        if (expression instanceof AttributePresentExpression) {
            return this.apply((AttributePresentExpression)expression, attributeContainer);
        }
        if (expression instanceof ValuePathExpression) {
            return this.apply((ValuePathExpression)expression, attributeContainer);
        }
        return this.unhandledExpression(expression, attributeContainer);
    }

    @Override
    protected abstract R apply(AttributeComparisonExpression var1, AttributeContainer var2);

    @Override
    protected R apply(LogicalExpression expression, AttributeContainer attributeContainer) {
        R left = this.apply(expression.getLeft(), attributeContainer);
        R right = this.apply(expression.getRight(), attributeContainer);
        LogicalOperator op = expression.getOperator();
        return this.apply(op, left, right);
    }

    protected abstract R apply(LogicalOperator var1, R var2, R var3);

    @Override
    protected R apply(GroupExpression expression, AttributeContainer attributeContainer) {
        R result = this.apply(expression.getFilterExpression(), attributeContainer);
        return expression.isNot() ? this.negate(result) : result;
    }

    protected abstract R negate(R var1);

    @Override
    protected abstract R apply(AttributePresentExpression var1, AttributeContainer var2);

    @Override
    protected abstract R apply(ValuePathExpression var1, AttributeContainer var2);

    protected R unhandledExpression(FilterExpression expression, AttributeContainer attributeContainer) {
        throw new IllegalArgumentException("FilterExpression '" + expression + "' is not supported");
    }

    protected static Schema.Attribute attribute(AttributeContainer attributeContainer, AttributeReference attributeReference) {
        String baseAttributeName = attributeReference.getAttributeName();
        Schema.Attribute schemaAttribute = attributeContainer.getAttribute(baseAttributeName);
        if (schemaAttribute == null) {
            log.warn("Invalid filter: attribute '" + baseAttributeName + "' is NOT a valid SCIM attribute.");
            return null;
        }
        String subAttribute = attributeReference.getSubAttributeName();
        if (subAttribute != null && (schemaAttribute = schemaAttribute.getAttribute(subAttribute)) == null) {
            log.warn("Invalid filter: attribute '" + attributeReference.getFullyQualifiedAttributeName() + "' is NOT a valid SCIM attribute.");
            return null;
        }
        if (schemaAttribute.getReturned() == Schema.Attribute.Returned.NEVER) {
            log.warn("Invalid filter: attribute '" + attributeReference.getAttributeName() + "' is not filterable.");
            return null;
        }
        return schemaAttribute;
    }

    protected static boolean isStringExpression(Schema.Attribute attribute, Object compareValue) {
        if (attribute.getType() != Schema.Attribute.Type.STRING) {
            log.debug("Invalid query, non String value for expression : " + attribute.getType());
            return false;
        }
        if (compareValue == null) {
            log.debug("Invalid query, empty value for expression : " + attribute.getType());
            return false;
        }
        return true;
    }
}

