/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.directory.scim.spec.filter.ExpressionBuildingListener;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.FilterLexer;
import org.apache.directory.scim.spec.filter.FilterParseException;
import org.apache.directory.scim.spec.filter.FilterParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filter
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Filter.class);
    private static final long serialVersionUID = -363511683199922297L;
    private FilterExpression expression;
    private String filter;

    protected Filter() {
    }

    public Filter(String filter) throws FilterParseException {
        log.debug("Creating a filter - {}", (Object)filter);
        this.setFilter(filter);
    }

    public Filter(FilterExpression filterExpression) {
        log.debug("Creating a filter - {}", (Object)filterExpression);
        this.expression = filterExpression;
        this.filter = filterExpression.toFilter();
    }

    public void setFilter(String filter) throws FilterParseException {
        this.filter = filter;
        this.expression = this.parseFilter(filter);
    }

    protected FilterExpression parseFilter(String filter) throws FilterParseException {
        FilterLexer l = new FilterLexer((CharStream)CharStreams.fromString((String)filter));
        FilterParser p = new FilterParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.setBuildParseTree(true);
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + ":" + charPositionInLine + " due to " + msg, (Throwable)e);
            }
        });
        try {
            FilterParser.FilterContext tree = p.filter();
            ExpressionBuildingListener expListener = new ExpressionBuildingListener();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)expListener, (ParseTree)tree);
            return expListener.getFilterExpression();
        }
        catch (IllegalStateException e) {
            throw new FilterParseException("Failed to parse filter: " + filter, e);
        }
    }

    public String toString() {
        return this.expression.toFilter();
    }

    public String encode() {
        String filterString = this.expression.toFilter();
        return URLEncoder.encode(filterString, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static Filter decode(String encodedExpression) throws FilterParseException {
        String decoded = URLDecoder.decode(encodedExpression, StandardCharsets.UTF_8).replace("%20", " ");
        return new Filter(decoded);
    }

    public FilterExpression getExpression() {
        return this.expression;
    }

    public String getFilter() {
        return this.filter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FilterExpression this$expression = this.getExpression();
        FilterExpression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Filter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterExpression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }
}

