/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.function.UnaryOperator;
import org.apache.directory.scim.spec.filter.Filter;
import org.apache.directory.scim.spec.filter.FilterComparisonFilterBuilder;
import org.apache.directory.scim.spec.filter.FilterExpression;

public interface FilterBuilder {
    public FilterBuilder and(FilterExpression var1);

    default public FilterBuilder and(UnaryOperator<FilterBuilder> filter) {
        return this.and(((FilterBuilder)filter.apply(FilterBuilder.create())).build());
    }

    default public FilterBuilder and(Filter filter) {
        return this.and(filter.getExpression());
    }

    public FilterBuilder and(FilterExpression var1, FilterExpression var2);

    default public FilterBuilder and(Filter left, Filter right) {
        return this.and(left.getExpression(), right.getExpression());
    }

    default public FilterBuilder and(UnaryOperator<FilterBuilder> left, UnaryOperator<FilterBuilder> right) {
        return this.and(((FilterBuilder)left.apply(FilterBuilder.create())).build(), ((FilterBuilder)right.apply(FilterBuilder.create())).build());
    }

    public FilterBuilder or(FilterExpression var1);

    default public FilterBuilder or(Filter filter) {
        return this.or(filter.getExpression());
    }

    default public FilterBuilder or(UnaryOperator<FilterBuilder> filter) {
        return this.or(((FilterBuilder)filter.apply(FilterBuilder.create())).build());
    }

    public FilterBuilder or(FilterExpression var1, FilterExpression var2);

    default public FilterBuilder or(Filter left, Filter right) {
        return this.or(left.getExpression(), right.getExpression());
    }

    default public FilterBuilder or(UnaryOperator<FilterBuilder> left, UnaryOperator<FilterBuilder> right) {
        return this.or(((FilterBuilder)left.apply(FilterBuilder.create())).build(), ((FilterBuilder)right.apply(FilterBuilder.create())).build());
    }

    public FilterBuilder equalTo(String var1, String var2);

    public FilterBuilder equalTo(String var1, Boolean var2);

    public FilterBuilder equalTo(String var1, Date var2);

    public FilterBuilder equalTo(String var1, LocalDate var2);

    public FilterBuilder equalTo(String var1, LocalDateTime var2);

    public <T extends Number> FilterBuilder equalTo(String var1, T var2);

    public FilterBuilder equalNull(String var1);

    public FilterBuilder notEqual(String var1, String var2);

    public FilterBuilder notEqual(String var1, Boolean var2);

    public FilterBuilder notEqual(String var1, Date var2);

    public FilterBuilder notEqual(String var1, LocalDate var2);

    public FilterBuilder notEqual(String var1, LocalDateTime var2);

    public <T extends Number> FilterBuilder notEqual(String var1, T var2);

    public FilterBuilder notEqualNull(String var1);

    public <T extends Number> FilterBuilder greaterThan(String var1, T var2);

    public FilterBuilder greaterThan(String var1, Date var2);

    public FilterBuilder greaterThan(String var1, LocalDate var2);

    public FilterBuilder greaterThan(String var1, LocalDateTime var2);

    public <T extends Number> FilterBuilder greaterThanOrEquals(String var1, T var2);

    public FilterBuilder greaterThanOrEquals(String var1, Date var2);

    public FilterBuilder greaterThanOrEquals(String var1, LocalDate var2);

    public FilterBuilder greaterThanOrEquals(String var1, LocalDateTime var2);

    public <T extends Number> FilterBuilder lessThan(String var1, T var2);

    public FilterBuilder lessThan(String var1, Date var2);

    public FilterBuilder lessThan(String var1, LocalDate var2);

    public FilterBuilder lessThan(String var1, LocalDateTime var2);

    public <T extends Number> FilterBuilder lessThanOrEquals(String var1, T var2);

    public FilterBuilder lessThanOrEquals(String var1, Date var2);

    public FilterBuilder lessThanOrEquals(String var1, LocalDate var2);

    public FilterBuilder lessThanOrEquals(String var1, LocalDateTime var2);

    public FilterBuilder endsWith(String var1, String var2);

    public FilterBuilder startsWith(String var1, String var2);

    public FilterBuilder contains(String var1, String var2);

    public FilterBuilder present(String var1);

    public FilterBuilder not(FilterExpression var1);

    default public FilterBuilder not(Filter filter) {
        return this.not(filter.getExpression());
    }

    default public FilterBuilder not(UnaryOperator<FilterBuilder> filter) {
        return this.not(((FilterBuilder)filter.apply(FilterBuilder.create())).build());
    }

    public FilterBuilder attributeHas(String var1, FilterExpression var2);

    default public FilterBuilder attributeHas(String attribute, UnaryOperator<FilterBuilder> filter) {
        return this.attributeHas(attribute, ((FilterBuilder)filter.apply(FilterBuilder.create())).build());
    }

    default public FilterBuilder attributeHas(String attribute, Filter filter) {
        return this.attributeHas(attribute, filter.getExpression());
    }

    public FilterExpression filter();

    public Filter build();

    public static FilterBuilder create() {
        return new FilterComparisonFilterBuilder();
    }
}

