/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.directory.scim.spec.filter.AttributeComparisonExpression;
import org.apache.directory.scim.spec.filter.AttributePresentExpression;
import org.apache.directory.scim.spec.filter.CompareOperator;
import org.apache.directory.scim.spec.filter.ComplexLogicalFilterBuilder;
import org.apache.directory.scim.spec.filter.FilterBuilder;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.GroupExpression;
import org.apache.directory.scim.spec.filter.ValuePathExpression;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;

class FilterComparisonFilterBuilder
extends ComplexLogicalFilterBuilder {
    FilterComparisonFilterBuilder() {
    }

    @Override
    public FilterBuilder equalTo(String key, String value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EQ, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder equalTo(String key, Boolean value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EQ, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder equalTo(String key, Date value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EQ, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder equalTo(String key, LocalDate value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EQ, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder equalTo(String key, LocalDateTime value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EQ, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public <T extends Number> FilterBuilder equalTo(String key, T value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EQ, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder equalNull(String key) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EQ, null);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder notEqual(String key, String value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.NE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder notEqual(String key, Boolean value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.NE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder notEqual(String key, Date value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.NE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder notEqual(String key, LocalDate value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.NE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder notEqual(String key, LocalDateTime value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.NE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public <T extends Number> FilterBuilder notEqual(String key, T value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.NE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder notEqualNull(String key) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.NE, null);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder endsWith(String key, String value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.EW, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder startsWith(String key, String value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.SW, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder contains(String key, String value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.CO, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder present(String key) {
        AttributeReference ar = new AttributeReference(key);
        AttributePresentExpression filterExpression = new AttributePresentExpression(ar);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public <T extends Number> FilterBuilder greaterThan(String key, T value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder greaterThan(String key, Date value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder greaterThan(String key, LocalDate value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder greaterThan(String key, LocalDateTime value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public <T extends Number> FilterBuilder greaterThanOrEquals(String key, T value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder greaterThanOrEquals(String key, Date value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder greaterThanOrEquals(String key, LocalDate value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder greaterThanOrEquals(String key, LocalDateTime value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.GE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public <T extends Number> FilterBuilder lessThan(String key, T value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder lessThan(String key, Date value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder lessThan(String key, LocalDate value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder lessThan(String key, LocalDateTime value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LT, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public <T extends Number> FilterBuilder lessThanOrEquals(String key, T value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder lessThanOrEquals(String key, Date value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder lessThanOrEquals(String key, LocalDate value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder lessThanOrEquals(String key, LocalDateTime value) {
        AttributeReference ar = new AttributeReference(key);
        AttributeComparisonExpression filterExpression = new AttributeComparisonExpression(ar, CompareOperator.LE, value);
        this.handleComparisonExpression(filterExpression);
        return this;
    }

    @Override
    public FilterBuilder not(FilterExpression expression) {
        GroupExpression groupExpression = new GroupExpression();
        groupExpression.setNot(true);
        groupExpression.setFilterExpression(expression);
        this.handleComparisonExpression(groupExpression);
        return this;
    }

    @Override
    public FilterBuilder attributeHas(String attribute, FilterExpression expression) {
        this.handleComparisonExpression(ValuePathExpression.fromFilterExpression(attribute, expression));
        return this;
    }
}

