/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.directory.scim.spec.filter.Filter;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.InMemoryScimFilterMatcher;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.AttributeContainer;
import org.apache.directory.scim.spec.schema.Schema;

public final class FilterExpressions {
    private FilterExpressions() {
    }

    public static Predicate<ScimResource> inMemory(Filter filter, Schema schema) {
        if (filter == null) {
            return x -> true;
        }
        FilterExpression expression = filter.getExpression();
        if (expression == null) {
            return x -> true;
        }
        return InMemoryScimFilterMatcher.toPredicate(expression, schema);
    }

    public static <R> Predicate<R> inMemory(FilterExpression expression, Schema schema) {
        return InMemoryScimFilterMatcher.toPredicate(expression, schema);
    }

    public static <R> Predicate<R> inMemoryMap(FilterExpression expression, Schema schema) {
        return (Predicate)new InMemoryMapScimFilterMatcher().apply(expression, (AttributeContainer)schema);
    }

    static class InMemoryMapScimFilterMatcher<R>
    extends InMemoryScimFilterMatcher<R> {
        InMemoryMapScimFilterMatcher() {
        }

        @Override
        public <A> A get(Schema.Attribute attribute, A actual) {
            Map map = (Map)actual;
            return (A)map.get(attribute.getName());
        }
    }
}

