/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.filter;

import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import org.apache.directory.scim.spec.exception.ScimResourceInvalidException;
import org.apache.directory.scim.spec.filter.AttributeComparisonExpression;
import org.apache.directory.scim.spec.filter.AttributePresentExpression;
import org.apache.directory.scim.spec.filter.BaseFilterExpressionMapper;
import org.apache.directory.scim.spec.filter.CompareOperator;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.LogicalOperator;
import org.apache.directory.scim.spec.filter.ValuePathExpression;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.schema.AttributeContainer;
import org.apache.directory.scim.spec.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryScimFilterMatcher<R>
extends BaseFilterExpressionMapper<Predicate<R>> {
    private static final Logger log = LoggerFactory.getLogger(InMemoryScimFilterMatcher.class);

    InMemoryScimFilterMatcher() {
    }

    static <R> Predicate<R> toPredicate(FilterExpression expression, AttributeContainer attributeContainer) {
        return (Predicate)new InMemoryScimFilterMatcher<R>().apply(expression, attributeContainer);
    }

    @Override
    protected Predicate<R> apply(AttributeComparisonExpression expression, AttributeContainer attributeContainer) {
        return new AttributeComparisonPredicate(expression, attributeContainer);
    }

    @Override
    protected Predicate<R> apply(LogicalOperator op, Predicate<R> left, Predicate<R> right) {
        if (op == LogicalOperator.AND) {
            return left.and(right);
        }
        return left.or(right);
    }

    @Override
    protected Predicate<R> negate(Predicate<R> expression) {
        return expression.negate();
    }

    @Override
    protected Predicate<R> apply(AttributePresentExpression expression, AttributeContainer attributeContainer) {
        return new AttributePresentPredicate(expression, attributeContainer);
    }

    @Override
    protected Predicate<R> apply(ValuePathExpression expression, AttributeContainer attributeContainer) {
        Predicate nestedPredicate = (Predicate)new InMemoryScimFilterMatcher<R>().apply(expression.getAttributeExpression(), (AttributeContainer)InMemoryScimFilterMatcher.attribute(attributeContainer, expression.getAttributePath()));
        return new ValuePathPredicate(expression, attributeContainer, nestedPredicate);
    }

    @Override
    protected Predicate<R> unhandledExpression(FilterExpression expression, AttributeContainer attributeContainer) {
        log.debug("Unsupported Filter expression of type: " + expression.getClass());
        return scimResource -> false;
    }

    public <A> A get(Schema.Attribute attribute, A actual) {
        return (A)attribute.getAccessor().get(actual);
    }

    private class AttributeComparisonPredicate<R>
    extends AbstractAttributePredicate<AttributeComparisonExpression, R> {
        private AttributeComparisonPredicate(AttributeComparisonExpression expression, AttributeContainer attributeContainer) {
            super(InMemoryScimFilterMatcher.this, (FilterExpression)expression, attributeContainer, expression.getAttributePath());
        }

        @Override
        protected boolean test(Schema.Attribute attribute, Object actualValue) {
            if (actualValue == null) {
                return false;
            }
            if (attribute.isMultiValued()) {
                log.warn("Invalid expression, target is collection");
                return false;
            }
            CompareOperator op = ((AttributeComparisonExpression)this.expression).getOperation();
            Object compareValue = ((AttributeComparisonExpression)this.expression).getCompareValue();
            if (op == CompareOperator.EQ) {
                if (BaseFilterExpressionMapper.isStringExpression(attribute, compareValue) && !attribute.isCaseExact()) {
                    return actualValue.toString().equalsIgnoreCase(compareValue.toString());
                }
                return compareValue.equals(actualValue);
            }
            if (op == CompareOperator.NE) {
                if (BaseFilterExpressionMapper.isStringExpression(attribute, compareValue) && !attribute.isCaseExact()) {
                    return !actualValue.toString().equalsIgnoreCase(compareValue.toString());
                }
                return !compareValue.equals(actualValue);
            }
            if (op == CompareOperator.SW) {
                return BaseFilterExpressionMapper.isStringExpression(attribute, compareValue) && actualValue.toString().startsWith(compareValue.toString());
            }
            if (op == CompareOperator.EW) {
                return BaseFilterExpressionMapper.isStringExpression(attribute, compareValue) && actualValue.toString().endsWith(compareValue.toString());
            }
            if (op == CompareOperator.CO) {
                return BaseFilterExpressionMapper.isStringExpression(attribute, compareValue) && actualValue.toString().contains(compareValue.toString());
            }
            if (actualValue instanceof Comparable) {
                Comparable actual = (Comparable)actualValue;
                Comparable compare = (Comparable)compareValue;
                return CompareOperatorPredicate.naturalOrder(op, compare).test(actual);
            }
            throw new ScimResourceInvalidException("Unsupported operation in filter: " + op.name());
        }
    }

    private class AttributePresentPredicate<R>
    extends AbstractAttributePredicate<AttributePresentExpression, R> {
        private AttributePresentPredicate(AttributePresentExpression expression, AttributeContainer attributeContainer) {
            super(InMemoryScimFilterMatcher.this, (FilterExpression)expression, attributeContainer, expression.getAttributePath());
        }

        @Override
        protected boolean test(Schema.Attribute attribute, Object actualValue) {
            if (attribute.isMultiValued()) {
                log.debug("Invalid expression, target is collection");
                return false;
            }
            return actualValue != null;
        }
    }

    private class ValuePathPredicate<R>
    extends AbstractAttributePredicate<ValuePathExpression, R> {
        private final Predicate<Object> nestedPredicate;

        ValuePathPredicate(ValuePathExpression expression, AttributeContainer attributeContainer, Predicate<Object> nestedPredicate) {
            super(InMemoryScimFilterMatcher.this, (FilterExpression)expression, attributeContainer, expression.getAttributePath());
            this.nestedPredicate = nestedPredicate;
        }

        @Override
        protected boolean test(Schema.Attribute attribute, Object actualValue) {
            if (attribute.isMultiValued()) {
                return ((Collection)actualValue).stream().anyMatch(this.nestedPredicate);
            }
            return false;
        }
    }

    private static class CompareOperatorPredicate<T>
    implements Predicate<T> {
        private final CompareOperator op;
        private final Comparator<T> comparator;
        private final T comparedValue;

        private CompareOperatorPredicate(CompareOperator op, T comparedValue, Comparator<T> comparator) {
            this.op = op;
            this.comparator = comparator;
            this.comparedValue = comparedValue;
        }

        @Override
        public boolean test(T actualValue) {
            int compareResult = this.comparator.compare(actualValue, this.comparedValue);
            if (this.op == CompareOperator.LT) {
                return compareResult < 0;
            }
            if (this.op == CompareOperator.GT) {
                return compareResult > 0;
            }
            if (this.op == CompareOperator.LE) {
                return compareResult <= 0;
            }
            if (this.op == CompareOperator.GE) {
                return compareResult >= 0;
            }
            return false;
        }

        static <T extends Comparable<T>> CompareOperatorPredicate<T> naturalOrder(CompareOperator op, T comparedValue) {
            return new CompareOperatorPredicate<T>(op, comparedValue, Comparator.naturalOrder());
        }
    }

    private static abstract class AbstractAttributePredicate<T extends FilterExpression, R>
    implements Predicate<R> {
        final T expression;
        final AttributeContainer attributeContainer;
        final AttributeReference attributeReference;
        final /* synthetic */ InMemoryScimFilterMatcher this$0;

        private AbstractAttributePredicate(T expression, AttributeContainer attributeContainer, AttributeReference attributeReference) {
            this.this$0 = var1_1;
            this.expression = expression;
            this.attributeContainer = attributeContainer;
            this.attributeReference = attributeReference;
        }

        protected abstract boolean test(Schema.Attribute var1, Object var2);

        @Override
        public boolean test(R actual) {
            try {
                Schema.Attribute resolvedAttribute = BaseFilterExpressionMapper.attribute(this.attributeContainer, this.attributeReference);
                if (resolvedAttribute != null) {
                    String subAttribute;
                    Schema.Attribute schemaAttribute = this.attributeContainer.getAttribute(this.attributeReference.getAttributeName());
                    if (!this.attributeReference.hasSubAttribute() || !schemaAttribute.isMultiValued()) {
                        actual = this.this$0.get(schemaAttribute, actual);
                    }
                    if ((subAttribute = this.attributeReference.getSubAttributeName()) != null) {
                        schemaAttribute = schemaAttribute.getAttribute(subAttribute);
                        actual = this.this$0.get(schemaAttribute, actual);
                    }
                    return this.test(schemaAttribute, actual);
                }
            }
            catch (Exception e) {
                log.debug("Invalid SCIM filter received", (Throwable)e);
            }
            return false;
        }
    }
}

