/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.patch;

import lombok.Generated;
import org.apache.directory.scim.spec.filter.ExpressionBuildingListener;
import org.apache.directory.scim.spec.filter.FilterExpression;
import org.apache.directory.scim.spec.filter.FilterParser;
import org.apache.directory.scim.spec.filter.ValuePathExpression;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;

public class PatchPathListener
extends ExpressionBuildingListener {
    private ValuePathExpression valuePathExpression;

    @Override
    public void exitPatchPathFull(FilterParser.PatchPathFullContext ctx) {
        super.exitPatchPathFull(ctx);
        String attributePathText = ctx.attributePath.getText();
        String subAttributeName = ctx.subAttributeName != null ? ctx.subAttributeName.getText() : null;
        FilterExpression attributeExpression = (FilterExpression)this.expressionStack.pop();
        AttributeReference attributePath = new AttributeReference(attributePathText);
        String urn = attributePath.getUrn();
        String parentAttributeName = attributePath.getAttributeName();
        attributeExpression.setAttributePath(urn, parentAttributeName);
        if (subAttributeName != null) {
            attributePath.setAttributeName(parentAttributeName);
            attributePath.setSubAttributeName(subAttributeName);
        }
        this.valuePathExpression = new ValuePathExpression(attributePath, attributeExpression);
    }

    @Override
    public void exitPatchPathPartial(FilterParser.PatchPathPartialContext ctx) {
        super.exitPatchPathPartial(ctx);
        String attributePathText = ctx.attributePath.getText();
        AttributeReference attributePath = new AttributeReference(attributePathText);
        this.valuePathExpression = new ValuePathExpression(attributePath);
    }

    @Generated
    public ValuePathExpression getValuePathExpression() {
        return this.valuePathExpression;
    }
}

