/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.phonenumber;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.scim.spec.phonenumber.PhoneNumberParseException;
import org.apache.directory.scim.spec.phonenumber.PhoneNumberParser;
import org.apache.directory.scim.spec.phonenumber.PhoneNumberParserBaseListener;
import org.apache.directory.scim.spec.resources.PhoneNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneNumberParseTreeListener
extends PhoneNumberParserBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoneNumberParserBaseListener.class);
    private PhoneNumber.PhoneNumberBuilder phoneNumberBuilder;
    private int indent = -1;

    @Override
    public void enterPhoneNumber(PhoneNumberParser.PhoneNumberContext ctx) {
        LOGGER.debug(this.indent("--- Enter PhoneNumber -->"));
    }

    @Override
    public void exitPhoneNumber(PhoneNumberParser.PhoneNumberContext ctx) {
        LOGGER.debug(this.indent("<-- Exit PhoneNumber ---"));
    }

    @Override
    public void enterLocalNumber(PhoneNumberParser.LocalNumberContext ctx) {
        LOGGER.debug(this.indent("--- Enter LocalNumber -->"));
        this.phoneNumberBuilder = new PhoneNumber.LocalPhoneNumberBuilder();
    }

    @Override
    public void exitLocalNumber(PhoneNumberParser.LocalNumberContext ctx) {
        LOGGER.debug(this.indent("<-- Exit LocalNumber ---"));
        ((PhoneNumber.LocalPhoneNumberBuilder)this.phoneNumberBuilder).subscriberNumber(ctx.localDigits.getText());
        if (ctx.Ext() != null && !StringUtils.isBlank((CharSequence)ctx.Ext().getText())) {
            ((PhoneNumber.LocalPhoneNumberBuilder)this.phoneNumberBuilder).extension(ctx.Ext().getText());
        }
        if (ctx.Isub() != null && !StringUtils.isBlank((CharSequence)ctx.Isub().getText())) {
            ((PhoneNumber.LocalPhoneNumberBuilder)this.phoneNumberBuilder).subAddress(ctx.Isub().getText());
        }
    }

    @Override
    public void enterLocalNumberDigits(PhoneNumberParser.LocalNumberDigitsContext ctx) {
        LOGGER.debug(this.indent("--- Enter LocalNumberDigits -->"));
    }

    @Override
    public void exitLocalNumberDigits(PhoneNumberParser.LocalNumberDigitsContext ctx) {
        LOGGER.debug(this.indent("<-- Exit LocalNumberDigits ---"));
    }

    @Override
    public void enterPhoneContext(PhoneNumberParser.PhoneContextContext ctx) {
        LOGGER.debug(this.indent("--- Enter PhoneContext -->"));
    }

    @Override
    public void exitPhoneContext(PhoneNumberParser.PhoneContextContext ctx) {
        LOGGER.debug(this.indent("<-- Exit PhoneContext ---"));
        if (!ctx.isEmpty()) {
            if (ctx.dig != null) {
                ((PhoneNumber.LocalPhoneNumberBuilder)this.phoneNumberBuilder).isDomainPhoneContext(false);
                this.phoneNumberBuilder.phoneContext("+" + ctx.dig.getText());
            } else if (ctx.dn != null) {
                ((PhoneNumber.LocalPhoneNumberBuilder)this.phoneNumberBuilder).isDomainPhoneContext(true);
                this.phoneNumberBuilder.phoneContext(ctx.dn.getText());
            }
        }
    }

    @Override
    public void enterParameter(PhoneNumberParser.ParameterContext ctx) {
        LOGGER.debug(this.indent("--- Enter Parameter -->"));
    }

    @Override
    public void exitParameter(PhoneNumberParser.ParameterContext ctx) {
        LOGGER.debug(this.indent("<-- Exit Parameter ---"));
        if (!ctx.isEmpty()) {
            this.phoneNumberBuilder.param(ctx.ParamName().getText(), ctx.ParamValue().getText());
        }
    }

    @Override
    public void enterGlobalNumber(PhoneNumberParser.GlobalNumberContext ctx) {
        LOGGER.debug(this.indent("--- Enter GlobalNumber -->"));
        this.phoneNumberBuilder = new PhoneNumber.GlobalPhoneNumberBuilder();
    }

    @Override
    public void exitGlobalNumber(PhoneNumberParser.GlobalNumberContext ctx) {
        LOGGER.debug(this.indent("<-- Exit GlobalNumber ---"));
        ((PhoneNumber.GlobalPhoneNumberBuilder)this.phoneNumberBuilder).globalNumber(ctx.globalDigits.getText() + ctx.GlobalNumberDigits().getText());
        if (ctx.Ext() != null && !StringUtils.isBlank((CharSequence)ctx.Ext().getText())) {
            this.phoneNumberBuilder.extension(ctx.Ext().getText());
        }
        if (ctx.Isub() != null && !StringUtils.isBlank((CharSequence)ctx.Isub().getText())) {
            this.phoneNumberBuilder.subAddress(ctx.Isub().getText());
        }
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
        ++this.indent;
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        --this.indent;
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        String text = node.getText();
        if (StringUtils.isNotEmpty((CharSequence)text.trim())) {
            LOGGER.debug(this.indent(text));
        }
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        LOGGER.error(this.indent(node.getText()));
    }

    private String indent(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            sb.append("    ");
        }
        sb.append(s);
        return sb.toString();
    }

    public PhoneNumber getPhoneNumber() throws PhoneNumberParseException {
        return this.phoneNumberBuilder.build(false);
    }
}

