/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.resources;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.scim.spec.annotation.ScimAttribute;
import org.apache.directory.scim.spec.phonenumber.PhoneNumberLexer;
import org.apache.directory.scim.spec.phonenumber.PhoneNumberParseException;
import org.apache.directory.scim.spec.phonenumber.PhoneNumberParseTreeListener;
import org.apache.directory.scim.spec.phonenumber.PhoneNumberParser;
import org.apache.directory.scim.spec.resources.TypedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType
@XmlAccessorType(value=XmlAccessType.NONE)
public class PhoneNumber
implements Serializable,
TypedAttribute {
    private static final long serialVersionUID = 607319505715224096L;
    private static final String VISUAL_SEPARATORS = "[\\(\\)\\-\\.]";
    private static final Logger log = LoggerFactory.getLogger(PhoneNumber.class);
    @ScimAttribute(description="Phone number of the User")
    String value;
    @XmlElement
    @ScimAttribute(description="A human readable name, primarily used for display purposes. READ-ONLY.")
    String display;
    @XmlElement
    @ScimAttribute(canonicalValueList={"work", "home", "mobile", "fax", "pager", "other"}, description="A label indicating the attribute's function; e.g., 'work' or 'home' or 'mobile' etc.")
    String type;
    @XmlElement
    @ScimAttribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g. the preferred phone number or primary phone number. The primary attribute value 'true' MUST appear no more than once.")
    Boolean primary = false;
    boolean isGlobalNumber = false;
    String number;
    String extension;
    String subAddress;
    String phoneContext;
    boolean isDomainPhoneContext = false;
    Map<String, String> params;

    public void addParam(String name, String value) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, String>();
        }
        this.params.put(name, value);
    }

    @XmlElement
    public String getValue() {
        return this.value;
    }

    public PhoneNumber setValue(String value) throws PhoneNumberParseException {
        return this.setValue(value, false);
    }

    public PhoneNumber setValue(String value, boolean strict) throws PhoneNumberParseException {
        if (value == null) {
            throw new PhoneNumberParseException("null values are illegal for phone numbers");
        }
        PhoneNumberLexer phoneNumberLexer = new PhoneNumberLexer((CharStream)new ANTLRInputStream(value));
        PhoneNumberParser p = new PhoneNumberParser((TokenStream)new CommonTokenStream((TokenSource)phoneNumberLexer));
        p.setBuildParseTree(true);
        p.addErrorListener((ANTLRErrorListener)new PhoneNumberErrorListener());
        PhoneNumberParseTreeListener tpl = new PhoneNumberParseTreeListener();
        try {
            PhoneNumberParser.PhoneNumberContext tree = p.phoneNumber();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)tpl, (ParseTree)tree);
            PhoneNumber parsedPhoneNumber = tpl.getPhoneNumber();
            this.value = parsedPhoneNumber.getValue();
            this.number = parsedPhoneNumber.getNumber();
            this.extension = parsedPhoneNumber.getExtension();
            this.subAddress = parsedPhoneNumber.getSubAddress();
            this.phoneContext = parsedPhoneNumber.getPhoneContext();
            this.params = parsedPhoneNumber.getParams();
            this.isGlobalNumber = parsedPhoneNumber.isGlobalNumber();
            this.isDomainPhoneContext = parsedPhoneNumber.isDomainPhoneContext();
        }
        catch (IllegalStateException e) {
            if (strict) {
                throw new PhoneNumberParseException(e);
            }
            log.debug("Failed to parse phone number '{}'", (Object)value, (Object)e);
            this.value = value;
        }
        return this;
    }

    public boolean equals(Object obj) {
        String otherExtensionWithoutVisualSeparators;
        String otherNumberWithoutVisualSeparators;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)obj;
        if (this.isGlobalNumber != other.isGlobalNumber) {
            return false;
        }
        String numberWithoutVisualSeparators = this.number != null ? this.number.replaceAll(VISUAL_SEPARATORS, "") : null;
        String string = otherNumberWithoutVisualSeparators = other.number != null ? other.number.replaceAll(VISUAL_SEPARATORS, "") : null;
        if (numberWithoutVisualSeparators == null ? otherNumberWithoutVisualSeparators != null : !numberWithoutVisualSeparators.equals(otherNumberWithoutVisualSeparators)) {
            return false;
        }
        String extensionWithoutVisualSeparators = this.extension != null ? this.extension.replaceAll(VISUAL_SEPARATORS, "") : null;
        String string2 = otherExtensionWithoutVisualSeparators = other.extension != null ? other.extension.replaceAll(VISUAL_SEPARATORS, "") : null;
        if (extensionWithoutVisualSeparators == null ? otherExtensionWithoutVisualSeparators != null : !extensionWithoutVisualSeparators.equals(otherExtensionWithoutVisualSeparators)) {
            return false;
        }
        if (this.subAddress == null ? other.subAddress != null : !PhoneNumber.equalsIgnoreCase(this.subAddress, other.subAddress)) {
            return false;
        }
        String phoneContextTemp = this.phoneContext;
        if (!StringUtils.isBlank((CharSequence)this.phoneContext) && !this.isDomainPhoneContext) {
            phoneContextTemp = this.phoneContext.replaceAll(VISUAL_SEPARATORS, "");
        }
        String otherPhoneContextTemp = other.phoneContext;
        if (!StringUtils.isBlank((CharSequence)other.phoneContext) && !other.isDomainPhoneContext) {
            otherPhoneContextTemp = other.phoneContext.replaceAll(VISUAL_SEPARATORS, "");
        }
        if (phoneContextTemp == null ? otherPhoneContextTemp != null : !PhoneNumber.equalsIgnoreCase(phoneContextTemp, otherPhoneContextTemp)) {
            return false;
        }
        if (!this.equalsIgnoreCaseAndOrderParams(other.params)) {
            return false;
        }
        if (this.primary == null ? other.primary != null : !this.primary.equals(other.primary)) {
            return false;
        }
        if (this.type == null) {
            return other.type == null;
        }
        return PhoneNumber.equalsIgnoreCase(this.type, other.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isGlobalNumber ? 1231 : 1237);
        result = 31 * result + (this.number == null ? 0 : this.number.replaceAll(VISUAL_SEPARATORS, "").hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.replaceAll(VISUAL_SEPARATORS, "").hashCode());
        result = 31 * result + (this.subAddress == null ? 0 : this.subAddress.toLowerCase(Locale.ROOT).hashCode());
        result = 31 * result + (this.phoneContext == null ? 0 : (this.isDomainPhoneContext ? this.phoneContext.toLowerCase(Locale.ROOT).hashCode() : this.phoneContext.replaceAll(VISUAL_SEPARATORS, "").hashCode()));
        result = 31 * result + (this.params == null ? 0 : this.paramsToLowerCase().hashCode());
        result = 31 * result + (this.primary == null ? 0 : this.primary.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.toLowerCase(Locale.ROOT).hashCode());
        return result;
    }

    Map<String, String> paramsToLowerCase() {
        LinkedHashMap<String, String> paramsLowercase = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            paramsLowercase.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue().toLowerCase(Locale.ROOT));
        }
        return paramsLowercase;
    }

    private static boolean equalsIgnoreCase(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.toLowerCase(Locale.ROOT).equals(b.toLowerCase(Locale.ROOT));
    }

    boolean equalsIgnoreCaseAndOrderParams(Map<String, String> otherParams) {
        if (this.params == null && otherParams == null) {
            return true;
        }
        if (this.params == null && otherParams != null || this.params != null && otherParams == null || this.params.size() != otherParams.size()) {
            return false;
        }
        Map<String, String> paramsLowercase = this.paramsToLowerCase();
        for (Map.Entry<String, String> entry : otherParams.entrySet()) {
            String foundValue = paramsLowercase.get(entry.getKey().toLowerCase(Locale.ROOT));
            if (entry.getValue().toLowerCase(Locale.ROOT).equals(foundValue)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public String toString() {
        return "PhoneNumber(value=" + this.getValue() + ", display=" + this.getDisplay() + ", type=" + this.getType() + ", primary=" + this.getPrimary() + ", isGlobalNumber=" + this.isGlobalNumber() + ", number=" + this.getNumber() + ", extension=" + this.getExtension() + ", subAddress=" + this.getSubAddress() + ", phoneContext=" + this.getPhoneContext() + ", isDomainPhoneContext=" + this.isDomainPhoneContext() + ", params=" + this.getParams() + ")";
    }

    @Generated
    public String getDisplay() {
        return this.display;
    }

    @Generated
    public PhoneNumber setDisplay(String display) {
        this.display = display;
        return this;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public PhoneNumber setType(String type) {
        this.type = type;
        return this;
    }

    @Generated
    public Boolean getPrimary() {
        return this.primary;
    }

    @Generated
    public PhoneNumber setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Generated
    public boolean isGlobalNumber() {
        return this.isGlobalNumber;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getExtension() {
        return this.extension;
    }

    @Generated
    public String getSubAddress() {
        return this.subAddress;
    }

    @Generated
    public String getPhoneContext() {
        return this.phoneContext;
    }

    @Generated
    public boolean isDomainPhoneContext() {
        return this.isDomainPhoneContext;
    }

    @Generated
    public Map<String, String> getParams() {
        return this.params;
    }

    private static class PhoneNumberErrorListener
    extends BaseErrorListener {
        private PhoneNumberErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
        }
    }

    public static class GlobalPhoneNumberBuilder
    extends PhoneNumberBuilder {
        String globalNumber;

        public GlobalPhoneNumberBuilder() {
            this.isGlobalNumber = true;
        }

        public GlobalPhoneNumberBuilder globalNumber(String globalNumber) {
            this.globalNumber = globalNumber;
            if (globalNumber != null) {
                this.number = globalNumber.startsWith("+") ? globalNumber : "+" + globalNumber;
            }
            return this;
        }

        @Override
        public PhoneNumber build() throws PhoneNumberParseException {
            if (StringUtils.isBlank((CharSequence)this.globalNumber) || !this.globalNumber.matches("^(\\+)?[\\d\\.\\-\\(\\)]+$")) {
                throw new IllegalArgumentException("GlobalPhoneNumberBuilder globalNumber must contain only numeric characters, optional ., -, (, ) visual separators, and an optional plus (+) prefix.");
            }
            return super.build();
        }
    }

    public static class LocalPhoneNumberBuilder
    extends PhoneNumberBuilder {
        String subscriberNumber;
        String countryCode;
        String areaCode;
        String domainName;

        public LocalPhoneNumberBuilder subscriberNumber(String subscriberNumber) {
            this.subscriberNumber = subscriberNumber;
            this.number = subscriberNumber;
            return this;
        }

        public LocalPhoneNumberBuilder countryCode(String countryCode) {
            Object localCode = countryCode;
            if (localCode != null && !((String)localCode).isEmpty() && ((String)(localCode = ((String)localCode).trim())).length() > 0 && ((String)localCode).charAt(0) != '+') {
                localCode = "+" + (String)localCode;
            }
            this.countryCode = localCode;
            return this;
        }

        public LocalPhoneNumberBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public LocalPhoneNumberBuilder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public LocalPhoneNumberBuilder isDomainPhoneContext(boolean hasDomainPhoneContext) {
            this.isDomainPhoneContext = hasDomainPhoneContext;
            return this;
        }

        @Override
        public PhoneNumber build() throws PhoneNumberParseException {
            if (StringUtils.isBlank((CharSequence)this.subscriberNumber) || !this.subscriberNumber.matches("^[\\d\\.\\-\\(\\)]+$")) {
                throw new IllegalArgumentException("LocalPhoneNumberBuilder subscriberNumber must contain only numeric characters and optional ., -, (, ) visual separator characters.");
            }
            if (StringUtils.isBlank((CharSequence)this.countryCode) && StringUtils.isBlank((CharSequence)this.domainName)) {
                throw new IllegalArgumentException("LocalPhoneNumberBuilder must have values for domainName or countryCode.");
            }
            if (StringUtils.isBlank((CharSequence)this.domainName)) {
                if (StringUtils.isBlank((CharSequence)this.countryCode) || !this.countryCode.matches("^(\\+)?[1-9][0-9]{0,2}$")) {
                    throw new IllegalArgumentException("LocalPhoneNumberBuilder countryCode must contain only numeric characters and an optional plus (+) prefix.");
                }
                if (this.areaCode != null && !StringUtils.isNumeric((CharSequence)this.areaCode)) {
                    throw new IllegalArgumentException("LocalPhoneNumberBuilder areaCode must contain only numberic characters.");
                }
                this.phoneContext = !this.countryCode.startsWith("+") ? "+" + this.countryCode : this.countryCode;
                if (!StringUtils.isBlank((CharSequence)this.areaCode)) {
                    this.phoneContext = this.phoneContext + "-" + this.areaCode;
                }
            } else {
                if (!this.domainName.matches("^[a-zA-Z0-9\\.\\-]+$")) {
                    throw new IllegalArgumentException("LocalPhoneNumberBuilder domainName must contain only alphanumeric, . and - characters.");
                }
                this.phoneContext = this.domainName;
            }
            return super.build();
        }
    }

    public static abstract class PhoneNumberBuilder {
        static final Logger LOGGER = LoggerFactory.getLogger(PhoneNumberBuilder.class);
        static final String HYPHEN = "-";
        static final String INTERNATIONAL_PREFIX = "+";
        static final String PREFIX = "tel:%s";
        static final String EXTENSTION_PREFIX = ";ext=%s";
        static final String ISUB_PREFIX = ";isub=%s";
        static final String CONTEXT_PREFIX = ";phone-context=%s";
        static final String PARAMS_STRING = ";%s=%s";
        static final String LOCAL_SUBSCRIBER_NUMBER_REGEX = "^[\\d\\.\\-\\(\\)]+$";
        static final String DOMAIN_NAME_REGEX = "^[a-zA-Z0-9\\.\\-]+$";
        static final String GLOBAL_NUMBER_REGEX = "^(\\+)?[\\d\\.\\-\\(\\)]+$";
        static final String COUNTRY_CODE_REGEX = "^(\\+)?[1-9][0-9]{0,2}$";
        String number;
        String display;
        String extension;
        String subAddress;
        String phoneContext;
        LinkedHashMap<String, String> params;
        boolean isGlobalNumber = false;
        boolean isDomainPhoneContext = false;

        public PhoneNumberBuilder display(String display) {
            this.display = display;
            return this;
        }

        public PhoneNumberBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public PhoneNumberBuilder subAddress(String subAddress) {
            this.subAddress = subAddress;
            return this;
        }

        public PhoneNumberBuilder phoneContext(String phoneContext) {
            this.phoneContext = phoneContext;
            return this;
        }

        public PhoneNumberBuilder setParams(Map<String, String> params) {
            this.params = params != null ? new LinkedHashMap<String, String>(params) : null;
            return this;
        }

        public PhoneNumberBuilder param(String name, String value) {
            if (this.params == null) {
                this.params = new LinkedHashMap();
            }
            this.params.put(name, value);
            return this;
        }

        String getFormattedExtension() {
            if (this.extension != null && !this.extension.isEmpty()) {
                return String.format(EXTENSTION_PREFIX, this.extension);
            }
            return null;
        }

        String getFormattedSubAddress() {
            if (this.subAddress != null && !this.subAddress.isEmpty()) {
                return String.format(ISUB_PREFIX, this.subAddress);
            }
            return null;
        }

        String getFormattedPhoneContext() {
            if (this.phoneContext != null && !this.phoneContext.isEmpty()) {
                return String.format(CONTEXT_PREFIX, this.phoneContext);
            }
            return null;
        }

        String getFormattedParams() {
            String paramsFormatted = "";
            if (this.params != null) {
                paramsFormatted = this.params.entrySet().stream().map(entry -> String.format(PARAMS_STRING, entry.getKey(), entry.getValue() != null ? entry.getValue() : "")).collect(Collectors.joining());
            }
            return !paramsFormatted.isEmpty() ? paramsFormatted : null;
        }

        String getFormattedValue() {
            String fParams;
            String fContext;
            String fSubAddr;
            Object valueString = String.format(PREFIX, this.number);
            String fExtension = this.getFormattedExtension();
            if (fExtension != null) {
                valueString = (String)valueString + fExtension;
            }
            if ((fSubAddr = this.getFormattedSubAddress()) != null) {
                valueString = (String)valueString + fSubAddr;
            }
            if ((fContext = this.getFormattedPhoneContext()) != null) {
                valueString = (String)valueString + fContext;
            }
            if ((fParams = this.getFormattedParams()) != null) {
                valueString = (String)valueString + fParams;
            }
            return !((String)valueString).isEmpty() ? valueString : null;
        }

        public PhoneNumber build() throws PhoneNumberParseException {
            return this.build(true);
        }

        public PhoneNumber build(boolean validate) throws PhoneNumberParseException {
            if (!StringUtils.isBlank((CharSequence)this.extension) && !StringUtils.isBlank((CharSequence)this.subAddress)) {
                throw new IllegalArgumentException("PhoneNumberBuilder cannot have a value for both extension and subAddress.");
            }
            if (this.extension != null && !this.extension.matches(LOCAL_SUBSCRIBER_NUMBER_REGEX)) {
                throw new IllegalArgumentException("PhoneNumberBuilder extension must contain only numeric characters and optional ., -, (, ) visual separator characters.");
            }
            if (this.params != null && !this.params.isEmpty() && (this.params.get("") != null || this.params.get(null) != null || this.params.containsValue(null) || this.params.containsValue(""))) {
                throw new IllegalArgumentException("PhoneNumberBuilder params names and values cannot be null or empty.");
            }
            PhoneNumber phoneNumber = new PhoneNumber();
            String formattedValue = this.getFormattedValue();
            LOGGER.debug("Building phone number: '{}'", (Object)formattedValue);
            if (validate) {
                phoneNumber.setValue(formattedValue, true);
            } else {
                phoneNumber.value = formattedValue;
                phoneNumber.extension = this.extension;
                phoneNumber.isDomainPhoneContext = this.isDomainPhoneContext;
                phoneNumber.isGlobalNumber = this.isGlobalNumber;
                phoneNumber.number = this.number;
                phoneNumber.params = this.params;
                phoneNumber.phoneContext = this.phoneContext;
                phoneNumber.subAddress = this.subAddress;
            }
            return phoneNumber;
        }

        @Generated
        public PhoneNumberBuilder() {
        }

        @Generated
        public String getNumber() {
            return this.number;
        }

        @Generated
        public String getDisplay() {
            return this.display;
        }

        @Generated
        public String getExtension() {
            return this.extension;
        }

        @Generated
        public String getSubAddress() {
            return this.subAddress;
        }

        @Generated
        public String getPhoneContext() {
            return this.phoneContext;
        }

        @Generated
        public LinkedHashMap<String, String> getParams() {
            return this.params;
        }

        @Generated
        public boolean isGlobalNumber() {
            return this.isGlobalNumber;
        }

        @Generated
        public boolean isDomainPhoneContext() {
            return this.isDomainPhoneContext;
        }

        @Generated
        public PhoneNumberBuilder setNumber(String number) {
            this.number = number;
            return this;
        }

        @Generated
        public PhoneNumberBuilder setDisplay(String display) {
            this.display = display;
            return this;
        }

        @Generated
        public PhoneNumberBuilder setExtension(String extension) {
            this.extension = extension;
            return this;
        }

        @Generated
        public PhoneNumberBuilder setSubAddress(String subAddress) {
            this.subAddress = subAddress;
            return this;
        }

        @Generated
        public PhoneNumberBuilder setPhoneContext(String phoneContext) {
            this.phoneContext = phoneContext;
            return this;
        }

        @Generated
        public PhoneNumberBuilder setGlobalNumber(boolean isGlobalNumber) {
            this.isGlobalNumber = isGlobalNumber;
            return this;
        }

        @Generated
        public PhoneNumberBuilder setDomainPhoneContext(boolean isDomainPhoneContext) {
            this.isDomainPhoneContext = isDomainPhoneContext;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhoneNumberBuilder)) {
                return false;
            }
            PhoneNumberBuilder other = (PhoneNumberBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isGlobalNumber() != other.isGlobalNumber()) {
                return false;
            }
            if (this.isDomainPhoneContext() != other.isDomainPhoneContext()) {
                return false;
            }
            String this$number = this.getNumber();
            String other$number = other.getNumber();
            if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
                return false;
            }
            String this$display = this.getDisplay();
            String other$display = other.getDisplay();
            if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
                return false;
            }
            String this$extension = this.getExtension();
            String other$extension = other.getExtension();
            if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
                return false;
            }
            String this$subAddress = this.getSubAddress();
            String other$subAddress = other.getSubAddress();
            if (this$subAddress == null ? other$subAddress != null : !this$subAddress.equals(other$subAddress)) {
                return false;
            }
            String this$phoneContext = this.getPhoneContext();
            String other$phoneContext = other.getPhoneContext();
            if (this$phoneContext == null ? other$phoneContext != null : !this$phoneContext.equals(other$phoneContext)) {
                return false;
            }
            LinkedHashMap<String, String> this$params = this.getParams();
            LinkedHashMap<String, String> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhoneNumberBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isGlobalNumber() ? 79 : 97);
            result = result * 59 + (this.isDomainPhoneContext() ? 79 : 97);
            String $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : $number.hashCode());
            String $display = this.getDisplay();
            result = result * 59 + ($display == null ? 43 : $display.hashCode());
            String $extension = this.getExtension();
            result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
            String $subAddress = this.getSubAddress();
            result = result * 59 + ($subAddress == null ? 43 : $subAddress.hashCode());
            String $phoneContext = this.getPhoneContext();
            result = result * 59 + ($phoneContext == null ? 43 : $phoneContext.hashCode());
            LinkedHashMap<String, String> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PhoneNumber.PhoneNumberBuilder(number=" + this.getNumber() + ", display=" + this.getDisplay() + ", extension=" + this.getExtension() + ", subAddress=" + this.getSubAddress() + ", phoneContext=" + this.getPhoneContext() + ", params=" + this.getParams() + ", isGlobalNumber=" + this.isGlobalNumber() + ", isDomainPhoneContext=" + this.isDomainPhoneContext() + ")";
        }
    }
}

