/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.resources;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.directory.scim.spec.annotation.ScimAttribute;
import org.apache.directory.scim.spec.annotation.ScimExtensionType;
import org.apache.directory.scim.spec.annotation.ScimResourceType;
import org.apache.directory.scim.spec.exception.InvalidExtensionException;
import org.apache.directory.scim.spec.resources.BaseResource;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.schema.Meta;
import org.apache.directory.scim.spec.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class ScimResource
extends BaseResource<ScimResource>
implements Serializable {
    private static final long serialVersionUID = 3673404125396687366L;
    private static final Logger LOG = LoggerFactory.getLogger(ScimResource.class);
    @XmlElement
    @NotNull
    @ScimAttribute(returned=Schema.Attribute.Returned.ALWAYS)
    Meta meta;
    @XmlElement
    @Size(min=1)
    @ScimAttribute(required=true, returned=Schema.Attribute.Returned.ALWAYS, mutability=Schema.Attribute.Mutability.READ_ONLY, uniqueness=Schema.Attribute.Uniqueness.SERVER, description="A unique identifier for a SCIM resource as defined by the service provider.")
    @Size(min=1) String id;
    @XmlElement
    @ScimAttribute(caseExact=true, mutability=Schema.Attribute.Mutability.READ_WRITE)
    String externalId;
    private Map<String, ScimExtension> extensions = new LinkedHashMap<String, ScimExtension>();
    private final String baseUrn;
    private final String resourceType;

    public ScimResource(String urn, String resourceType) {
        super(urn);
        this.baseUrn = urn;
        this.resourceType = resourceType;
        ScimResourceType resourceTypeAnnotation = this.getClass().getAnnotation(ScimResourceType.class);
        if (resourceTypeAnnotation != null) {
            this.meta = new Meta().setResourceType(resourceTypeAnnotation.id());
        }
    }

    public ScimResource addExtension(ScimExtension extension) {
        ScimExtensionType[] se = (ScimExtensionType[])extension.getClass().getAnnotationsByType(ScimExtensionType.class);
        if (se.length != 1) {
            throw new InvalidExtensionException("Registered extensions must have an ScimExtensionType annotation");
        }
        String extensionUrn = se[0].id();
        this.extensions.put(extensionUrn, extension);
        this.addSchema(extensionUrn);
        return this;
    }

    public ScimExtension getExtension(String urn) {
        return this.extensions.get(urn);
    }

    public <T> T getExtension(Class<T> extensionClass) {
        ScimExtensionType se = this.lookupScimExtensionType(extensionClass);
        return (T)this.extensions.get(se.id());
    }

    private <T> ScimExtensionType lookupScimExtensionType(Class<T> extensionClass) {
        ScimExtensionType[] se = (ScimExtensionType[])extensionClass.getAnnotationsByType(ScimExtensionType.class);
        if (se.length != 1) {
            throw new InvalidExtensionException("Registered extensions must have an ScimExtensionType annotation");
        }
        return se[0];
    }

    public String getBaseUrn() {
        return this.baseUrn;
    }

    @JsonAnyGetter
    public Map<String, ScimExtension> getExtensions() {
        return this.extensions;
    }

    public ScimExtension removeExtension(String urn) {
        return this.extensions.remove(urn);
    }

    public <T> T removeExtension(Class<T> extensionClass) {
        ScimExtensionType se = this.lookupScimExtensionType(extensionClass);
        return (T)this.extensions.remove(se.id());
    }

    @Generated
    public Meta getMeta() {
        return this.meta;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getResourceType() {
        return this.resourceType;
    }

    @Generated
    public ScimResource setMeta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @Generated
    public ScimResource setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public ScimResource setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Generated
    public ScimResource setExtensions(Map<String, ScimExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ScimResource(meta=" + this.getMeta() + ", id=" + this.getId() + ", externalId=" + this.getExternalId() + ", extensions=" + this.getExtensions() + ", baseUrn=" + this.getBaseUrn() + ", resourceType=" + this.getResourceType() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScimResource)) {
            return false;
        }
        ScimResource other = (ScimResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Meta this$meta = this.getMeta();
        Meta other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        Map<String, ScimExtension> this$extensions = this.getExtensions();
        Map<String, ScimExtension> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        String this$baseUrn = this.getBaseUrn();
        String other$baseUrn = other.getBaseUrn();
        if (this$baseUrn == null ? other$baseUrn != null : !this$baseUrn.equals(other$baseUrn)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        return !(this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScimResource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Meta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        Map<String, ScimExtension> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        String $baseUrn = this.getBaseUrn();
        result = result * 59 + ($baseUrn == null ? 43 : $baseUrn.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        return result;
    }
}

