/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.resources;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.directory.scim.spec.annotation.ScimAttribute;
import org.apache.directory.scim.spec.annotation.ScimResourceType;
import org.apache.directory.scim.spec.resources.Address;
import org.apache.directory.scim.spec.resources.Email;
import org.apache.directory.scim.spec.resources.Entitlement;
import org.apache.directory.scim.spec.resources.Im;
import org.apache.directory.scim.spec.resources.Name;
import org.apache.directory.scim.spec.resources.PhoneNumber;
import org.apache.directory.scim.spec.resources.Photo;
import org.apache.directory.scim.spec.resources.Role;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.resources.UserGroup;
import org.apache.directory.scim.spec.resources.X509Certificate;
import org.apache.directory.scim.spec.schema.Meta;
import org.apache.directory.scim.spec.schema.Schema;

@ScimResourceType(id="User", name="User", schema="urn:ietf:params:scim:schemas:core:2.0:User", description="Top level ScimUser", endpoint="/Users")
@XmlRootElement(name="User")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ScimUser
extends ScimResource
implements Serializable {
    private static final long serialVersionUID = -2306547717245071997L;
    public static final String RESOURCE_NAME = "User";
    public static final String SCHEMA_URI = "urn:ietf:params:scim:schemas:core:2.0:User";
    @XmlElement
    @ScimAttribute(description="A Boolean value indicating the User's administrative status.")
    Boolean active = true;
    @XmlElement
    @ScimAttribute(description="A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.")
    List<Address> addresses;
    @XmlElement
    @ScimAttribute(description="The name of the User, suitable for display to end-users. The name SHOULD be the full name of the User being described if known")
    String displayName;
    @XmlElement
    @ScimAttribute(description="E-mail addresses for the user. The value SHOULD be canonicalized by the Service Provider, e.g. bjensen@example.com instead of bjensen@EXAMPLE.COM. Canonical Type values of work, home, and other.")
    List<Email> emails;
    @XmlElement
    @ScimAttribute(description="An entitlement may be an additional right to a thing, object, or service")
    List<Entitlement> entitlements;
    @XmlElement
    @ScimAttribute(description="A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated")
    List<UserGroup> groups;
    @XmlElement
    @ScimAttribute(description="Instant messaging address for the User.")
    List<Im> ims;
    @XmlElement
    @ScimAttribute(description="Used to indicate the User's default location for purposes of localizing items such as currency, date time format, numerical representations, etc.")
    String locale;
    @XmlElement
    @ScimAttribute(description="The components of the user's real name. Providers MAY return just the full name as a single string in the formatted sub-attribute, or they MAY return just the individual component attributes using the other sub-attributes, or they MAY return both. If both variants are returned, they SHOULD be describing the same name, with the formatted name indicating how the component attributes should be combined.")
    Name name;
    @XmlElement
    @ScimAttribute(description="The casual way to address the user in real life, e.g.'Bob' or 'Bobby' instead of 'Robert'. This attribute SHOULD NOT be used to represent a User's username (e.g. bjensen or mpepperidge)")
    String nickName;
    @XmlElement
    @ScimAttribute(returned=Schema.Attribute.Returned.NEVER, description="The User's clear text password.  This attribute is intended to be used as a means to specify an initial password when creating a new User or to reset an existing User's password.")
    String password;
    @XmlElement
    @ScimAttribute(description="Phone numbers for the User.  The value SHOULD be canonicalized by the Service Provider according to format in RFC3966 e.g. 'tel:+1-201-555-0123'.  Canonical Type values of work, home, mobile, fax, pager and other.")
    List<PhoneNumber> phoneNumbers;
    @XmlElement
    @ScimAttribute(description="URLs of photos of the User.")
    List<Photo> photos;
    @XmlElement
    @ScimAttribute(description="A fully qualified URL to a page representing the User's online profile", referenceTypes={"external"})
    String profileUrl;
    @XmlElement
    @ScimAttribute(description="Indicates the User's preferred written or spoken language.  Generally used for selecting a localized User interface. e.g., 'en_US' specifies the language English and country US.")
    String preferredLanguage;
    @XmlElement
    @ScimAttribute(description="A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.")
    List<Role> roles;
    @XmlElement
    @ScimAttribute(description="The User's time zone in the 'Olson' timezone database format; e.g.,'America/Los_Angeles'")
    String timezone;
    @XmlElement
    @ScimAttribute(description="The user's title, such as \"Vice President.\"")
    String title;
    @XmlElement
    @ScimAttribute(required=true, uniqueness=Schema.Attribute.Uniqueness.SERVER, description="Unique identifier for the User typically used by the user to directly authenticate to the service provider. Each User MUST include a non-empty userName value.  This identifier MUST be unique across the Service Consumer's entire set of Users.  REQUIRED")
    String userName;
    @XmlElement
    @ScimAttribute(description="Used to identify the organization to user relationship. Typical values used might be 'Contractor', 'Employee', 'Intern', 'Temp', 'External', and 'Unknown' but any value may be used.")
    String userType;
    @XmlElement
    @ScimAttribute(description="A list of certificates issued to the User.")
    List<X509Certificate> x509Certificates;

    public ScimUser() {
        super(SCHEMA_URI, RESOURCE_NAME);
    }

    public Optional<Address> getPrimaryAddress() {
        if (this.addresses == null) {
            return Optional.empty();
        }
        return this.addresses.stream().filter(Address::getPrimary).findFirst();
    }

    public Optional<Email> getPrimaryEmailAddress() {
        if (this.emails == null) {
            return Optional.empty();
        }
        return this.emails.stream().filter(Email::getPrimary).findFirst();
    }

    public Optional<PhoneNumber> getPrimaryPhoneNumber() {
        if (this.phoneNumbers == null) {
            return Optional.empty();
        }
        return this.phoneNumbers.stream().filter(PhoneNumber::getPrimary).findFirst();
    }

    @Override
    public ScimUser setSchemas(Set<String> schemas) {
        return (ScimUser)super.setSchemas(schemas);
    }

    @Override
    public ScimUser setMeta(@NotNull Meta meta) {
        return (ScimUser)super.setMeta(meta);
    }

    @Override
    public ScimUser setId(@Size(min=1) @Size(min=1) String id) {
        return (ScimUser)super.setId(id);
    }

    @Override
    public ScimUser setExternalId(String externalId) {
        return (ScimUser)super.setExternalId(externalId);
    }

    @Override
    public ScimUser setExtensions(Map<String, ScimExtension> extensions) {
        return (ScimUser)super.setExtensions(extensions);
    }

    @Override
    public ScimUser addSchema(String urn) {
        return (ScimUser)super.addSchema(urn);
    }

    @Override
    public ScimUser addExtension(ScimExtension extension) {
        return (ScimUser)super.addExtension(extension);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public List<Address> getAddresses() {
        return this.addresses;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public List<Email> getEmails() {
        return this.emails;
    }

    @Generated
    public List<Entitlement> getEntitlements() {
        return this.entitlements;
    }

    @Generated
    public List<UserGroup> getGroups() {
        return this.groups;
    }

    @Generated
    public List<Im> getIms() {
        return this.ims;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public Name getName() {
        return this.name;
    }

    @Generated
    public String getNickName() {
        return this.nickName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @Generated
    public List<Photo> getPhotos() {
        return this.photos;
    }

    @Generated
    public String getProfileUrl() {
        return this.profileUrl;
    }

    @Generated
    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    @Generated
    public List<Role> getRoles() {
        return this.roles;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getUserType() {
        return this.userType;
    }

    @Generated
    public List<X509Certificate> getX509Certificates() {
        return this.x509Certificates;
    }

    @Generated
    public ScimUser setActive(Boolean active) {
        this.active = active;
        return this;
    }

    @Generated
    public ScimUser setAddresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    @Generated
    public ScimUser setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Generated
    public ScimUser setEmails(List<Email> emails) {
        this.emails = emails;
        return this;
    }

    @Generated
    public ScimUser setEntitlements(List<Entitlement> entitlements) {
        this.entitlements = entitlements;
        return this;
    }

    @Generated
    public ScimUser setGroups(List<UserGroup> groups) {
        this.groups = groups;
        return this;
    }

    @Generated
    public ScimUser setIms(List<Im> ims) {
        this.ims = ims;
        return this;
    }

    @Generated
    public ScimUser setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Generated
    public ScimUser setName(Name name) {
        this.name = name;
        return this;
    }

    @Generated
    public ScimUser setNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    @Generated
    public ScimUser setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public ScimUser setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @Generated
    public ScimUser setPhotos(List<Photo> photos) {
        this.photos = photos;
        return this;
    }

    @Generated
    public ScimUser setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
        return this;
    }

    @Generated
    public ScimUser setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    @Generated
    public ScimUser setRoles(List<Role> roles) {
        this.roles = roles;
        return this;
    }

    @Generated
    public ScimUser setTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Generated
    public ScimUser setTitle(String title) {
        this.title = title;
        return this;
    }

    @Generated
    public ScimUser setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public ScimUser setUserType(String userType) {
        this.userType = userType;
        return this;
    }

    @Generated
    public ScimUser setX509Certificates(List<X509Certificate> x509Certificates) {
        this.x509Certificates = x509Certificates;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ScimUser(super=" + super.toString() + ", active=" + this.getActive() + ", addresses=" + this.getAddresses() + ", displayName=" + this.getDisplayName() + ", emails=" + this.getEmails() + ", entitlements=" + this.getEntitlements() + ", groups=" + this.getGroups() + ", ims=" + this.getIms() + ", locale=" + this.getLocale() + ", name=" + this.getName() + ", nickName=" + this.getNickName() + ", phoneNumbers=" + this.getPhoneNumbers() + ", photos=" + this.getPhotos() + ", profileUrl=" + this.getProfileUrl() + ", preferredLanguage=" + this.getPreferredLanguage() + ", roles=" + this.getRoles() + ", timezone=" + this.getTimezone() + ", title=" + this.getTitle() + ", userName=" + this.getUserName() + ", userType=" + this.getUserType() + ", x509Certificates=" + this.getX509Certificates() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScimUser)) {
            return false;
        }
        ScimUser other = (ScimUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        List<Address> this$addresses = this.getAddresses();
        List<Address> other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !((Object)this$addresses).equals(other$addresses)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<Email> this$emails = this.getEmails();
        List<Email> other$emails = other.getEmails();
        if (this$emails == null ? other$emails != null : !((Object)this$emails).equals(other$emails)) {
            return false;
        }
        List<Entitlement> this$entitlements = this.getEntitlements();
        List<Entitlement> other$entitlements = other.getEntitlements();
        if (this$entitlements == null ? other$entitlements != null : !((Object)this$entitlements).equals(other$entitlements)) {
            return false;
        }
        List<UserGroup> this$groups = this.getGroups();
        List<UserGroup> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        List<Im> this$ims = this.getIms();
        List<Im> other$ims = other.getIms();
        if (this$ims == null ? other$ims != null : !((Object)this$ims).equals(other$ims)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        String this$nickName = this.getNickName();
        String other$nickName = other.getNickName();
        if (this$nickName == null ? other$nickName != null : !this$nickName.equals(other$nickName)) {
            return false;
        }
        List<PhoneNumber> this$phoneNumbers = this.getPhoneNumbers();
        List<PhoneNumber> other$phoneNumbers = other.getPhoneNumbers();
        if (this$phoneNumbers == null ? other$phoneNumbers != null : !((Object)this$phoneNumbers).equals(other$phoneNumbers)) {
            return false;
        }
        List<Photo> this$photos = this.getPhotos();
        List<Photo> other$photos = other.getPhotos();
        if (this$photos == null ? other$photos != null : !((Object)this$photos).equals(other$photos)) {
            return false;
        }
        String this$profileUrl = this.getProfileUrl();
        String other$profileUrl = other.getProfileUrl();
        if (this$profileUrl == null ? other$profileUrl != null : !this$profileUrl.equals(other$profileUrl)) {
            return false;
        }
        String this$preferredLanguage = this.getPreferredLanguage();
        String other$preferredLanguage = other.getPreferredLanguage();
        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
            return false;
        }
        List<Role> this$roles = this.getRoles();
        List<Role> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$userType = this.getUserType();
        String other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        List<X509Certificate> this$x509Certificates = this.getX509Certificates();
        List<X509Certificate> other$x509Certificates = other.getX509Certificates();
        return !(this$x509Certificates == null ? other$x509Certificates != null : !((Object)this$x509Certificates).equals(other$x509Certificates));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScimUser;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        List<Address> $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : ((Object)$addresses).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<Email> $emails = this.getEmails();
        result = result * 59 + ($emails == null ? 43 : ((Object)$emails).hashCode());
        List<Entitlement> $entitlements = this.getEntitlements();
        result = result * 59 + ($entitlements == null ? 43 : ((Object)$entitlements).hashCode());
        List<UserGroup> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        List<Im> $ims = this.getIms();
        result = result * 59 + ($ims == null ? 43 : ((Object)$ims).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        String $nickName = this.getNickName();
        result = result * 59 + ($nickName == null ? 43 : $nickName.hashCode());
        List<PhoneNumber> $phoneNumbers = this.getPhoneNumbers();
        result = result * 59 + ($phoneNumbers == null ? 43 : ((Object)$phoneNumbers).hashCode());
        List<Photo> $photos = this.getPhotos();
        result = result * 59 + ($photos == null ? 43 : ((Object)$photos).hashCode());
        String $profileUrl = this.getProfileUrl();
        result = result * 59 + ($profileUrl == null ? 43 : $profileUrl.hashCode());
        String $preferredLanguage = this.getPreferredLanguage();
        result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
        List<Role> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        List<X509Certificate> $x509Certificates = this.getX509Certificates();
        result = result * 59 + ($x509Certificates == null ? 43 : ((Object)$x509Certificates).hashCode());
        return result;
    }
}

