/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.schema;

import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.directory.scim.spec.adapter.LocalDateTimeAdapter;
import org.apache.directory.scim.spec.annotation.ScimAttribute;
import org.apache.directory.scim.spec.schema.Schema;

@XmlType(name="meta")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Meta
implements Serializable {
    private static final long serialVersionUID = -9162917034280030708L;
    @XmlElement
    @Size(min=1)
    @ScimAttribute(mutability=Schema.Attribute.Mutability.READ_ONLY, caseExact=true, description="The name of the resource type of the resource.")
    @Size(min=1) String resourceType;
    @XmlElement
    @XmlJavaTypeAdapter(value=LocalDateTimeAdapter.class)
    @ScimAttribute(mutability=Schema.Attribute.Mutability.READ_ONLY, description="The DateTime that the resource was added to the service provider.")
    LocalDateTime created;
    @XmlElement
    @XmlJavaTypeAdapter(value=LocalDateTimeAdapter.class)
    @ScimAttribute(mutability=Schema.Attribute.Mutability.READ_ONLY, description="The most recent DateTime that the details of this resource were updated at the service provider.")
    LocalDateTime lastModified;
    @XmlElement
    @ScimAttribute(mutability=Schema.Attribute.Mutability.READ_ONLY, description="The URI of the resource being returned.")
    String location;
    @XmlElement
    @ScimAttribute(mutability=Schema.Attribute.Mutability.READ_ONLY, description="The version of the resource being returned.  This value must be the same as the entity-tag (ETag) HTTP response header")
    String version;

    @Generated
    public Meta() {
    }

    @Generated
    public String getResourceType() {
        return this.resourceType;
    }

    @Generated
    public LocalDateTime getCreated() {
        return this.created;
    }

    @Generated
    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Meta setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Generated
    public Meta setCreated(LocalDateTime created) {
        this.created = created;
        return this;
    }

    @Generated
    public Meta setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Generated
    public Meta setLocation(String location) {
        this.location = location;
        return this;
    }

    @Generated
    public Meta setVersion(String version) {
        this.version = version;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Meta)) {
            return false;
        }
        Meta other = (Meta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        LocalDateTime this$created = this.getCreated();
        LocalDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        LocalDateTime this$lastModified = this.getLastModified();
        LocalDateTime other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Meta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        LocalDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        LocalDateTime $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Meta(resourceType=" + this.getResourceType() + ", created=" + this.getCreated() + ", lastModified=" + this.getLastModified() + ", location=" + this.getLocation() + ", version=" + this.getVersion() + ")";
    }
}

