/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.schema;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.directory.scim.spec.annotation.ScimResourceType;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimResourceWithOptionalId;
import org.apache.directory.scim.spec.schema.Meta;
import org.apache.directory.scim.spec.validator.Urn;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ResourceType
extends ScimResourceWithOptionalId {
    public static final String RESOURCE_NAME = "ResourceType";
    public static final String SCHEMA_URI = "urn:ietf:params:scim:schemas:core:2.0:ResourceType";
    private static final long serialVersionUID = -696969911228870476L;
    @XmlElement
    @Size(min=1)
    @Size(min=1) String name;
    @XmlElement
    String description;
    @XmlElement
    @Size(min=1)
    @Size(min=1) String endpoint;
    @XmlElement(name="schema")
    @Urn
    @Size(min=1)
    @Urn @Size(min=1) String schemaUrn;
    @XmlElement
    List<SchemaExtensionConfiguration> schemaExtensions;

    public ResourceType() {
        super(SCHEMA_URI, RESOURCE_NAME);
    }

    public ResourceType(ScimResourceType annotation) {
        super(SCHEMA_URI, RESOURCE_NAME);
        this.name = annotation.name();
        this.description = annotation.description();
        this.schemaUrn = annotation.schema();
        this.endpoint = annotation.endpoint();
    }

    @Override
    public ResourceType setSchemas(Set<String> schemas) {
        return (ResourceType)super.setSchemas(schemas);
    }

    @Override
    public ResourceType setMeta(@NotNull Meta meta) {
        return (ResourceType)super.setMeta(meta);
    }

    @Override
    public ResourceType setExternalId(String externalId) {
        return (ResourceType)super.setExternalId(externalId);
    }

    @Override
    public ResourceType setExtensions(Map<String, ScimExtension> extensions) {
        return (ResourceType)super.setExtensions(extensions);
    }

    @Override
    public ResourceType setId(String id) {
        return (ResourceType)super.setId(id);
    }

    @Override
    public ResourceType addSchema(String urn) {
        return (ResourceType)super.addSchema(urn);
    }

    @Override
    public ResourceType addExtension(ScimExtension extension) {
        return (ResourceType)super.addExtension(extension);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getSchemaUrn() {
        return this.schemaUrn;
    }

    @Generated
    public List<SchemaExtensionConfiguration> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    @Generated
    public ResourceType setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ResourceType setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public ResourceType setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Generated
    public ResourceType setSchemaUrn(String schemaUrn) {
        this.schemaUrn = schemaUrn;
        return this;
    }

    @Generated
    public ResourceType setSchemaExtensions(List<SchemaExtensionConfiguration> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ResourceType(name=" + this.getName() + ", description=" + this.getDescription() + ", endpoint=" + this.getEndpoint() + ", schemaUrn=" + this.getSchemaUrn() + ", schemaExtensions=" + this.getSchemaExtensions() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceType)) {
            return false;
        }
        ResourceType other = (ResourceType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$schemaUrn = this.getSchemaUrn();
        String other$schemaUrn = other.getSchemaUrn();
        if (this$schemaUrn == null ? other$schemaUrn != null : !this$schemaUrn.equals(other$schemaUrn)) {
            return false;
        }
        List<SchemaExtensionConfiguration> this$schemaExtensions = this.getSchemaExtensions();
        List<SchemaExtensionConfiguration> other$schemaExtensions = other.getSchemaExtensions();
        return !(this$schemaExtensions == null ? other$schemaExtensions != null : !((Object)this$schemaExtensions).equals(other$schemaExtensions));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $schemaUrn = this.getSchemaUrn();
        result = result * 59 + ($schemaUrn == null ? 43 : $schemaUrn.hashCode());
        List<SchemaExtensionConfiguration> $schemaExtensions = this.getSchemaExtensions();
        result = result * 59 + ($schemaExtensions == null ? 43 : ((Object)$schemaExtensions).hashCode());
        return result;
    }

    public static class SchemaExtensionConfiguration
    implements Serializable {
        private static final long serialVersionUID = 7351651561572744255L;
        @XmlElement(name="schema")
        @Urn
        @Size(min=1)
        @Urn @Size(min=1) String schemaUrn;
        @XmlElement
        boolean required;

        @Generated
        public SchemaExtensionConfiguration() {
        }

        @Generated
        public String getSchemaUrn() {
            return this.schemaUrn;
        }

        @Generated
        public boolean isRequired() {
            return this.required;
        }

        @Generated
        public SchemaExtensionConfiguration setSchemaUrn(String schemaUrn) {
            this.schemaUrn = schemaUrn;
            return this;
        }

        @Generated
        public SchemaExtensionConfiguration setRequired(boolean required) {
            this.required = required;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaExtensionConfiguration)) {
                return false;
            }
            SchemaExtensionConfiguration other = (SchemaExtensionConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            String this$schemaUrn = this.getSchemaUrn();
            String other$schemaUrn = other.getSchemaUrn();
            return !(this$schemaUrn == null ? other$schemaUrn != null : !this$schemaUrn.equals(other$schemaUrn));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SchemaExtensionConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequired() ? 79 : 97);
            String $schemaUrn = this.getSchemaUrn();
            result = result * 59 + ($schemaUrn == null ? 43 : $schemaUrn.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ResourceType.SchemaExtensionConfiguration(schemaUrn=" + this.getSchemaUrn() + ", required=" + this.isRequired() + ")";
        }
    }
}

