/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.schema;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.directory.scim.spec.exception.ScimResourceInvalidException;
import org.apache.directory.scim.spec.schema.AttributeContainer;
import org.apache.directory.scim.spec.schema.Meta;
import org.apache.directory.scim.spec.validator.Urn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="schema")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Schema
implements AttributeContainer {
    private static final Logger LOG = LoggerFactory.getLogger(Schema.class);
    public static final String RESOURCE_NAME = "Schema";
    public static final String SCHEMA_URI = "urn:ietf:params:scim:schemas:core:2.0:Schema";
    private static final long serialVersionUID = 1869782412244161741L;
    @Urn
    @NotNull
    @Size(min=1, max=65535)
    @XmlElement
    @Urn @NotNull @Size(min=1, max=65535) String id;
    @XmlElement
    String name;
    @XmlElement
    String description;
    @Size(min=1, max=65535)
    @XmlElement
    @XmlElementWrapper(name="attributes")
    @Size(min=1, max=65535) Set<Attribute> attributes;
    Map<String, Attribute> attributeNamesMap = new HashMap<String, Attribute>();
    @XmlElement
    Meta meta;

    @Override
    public Set<Attribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    public void setAttributes(Set<Attribute> attributes) {
        this.attributeNamesMap.clear();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            if (name == null) {
                LOG.warn("Attribute name was null, skipping name indexing");
                continue;
            }
            this.attributeNamesMap.put(name.toLowerCase(Locale.ENGLISH), attribute);
        }
        this.attributes = attributes;
    }

    @Override
    public Attribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributeNamesMap.get(name.toLowerCase(Locale.ENGLISH));
    }

    public Attribute getAttributeFromPath(String path) {
        if (path == null) {
            return null;
        }
        String[] parts = path.split("\\.");
        Attribute attribute = this.getAttribute(parts[0]);
        for (int index = 1; index < parts.length; ++index) {
            attribute = attribute.getAttribute(parts[index]);
        }
        return attribute;
    }

    @Generated
    public Schema() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Meta getMeta() {
        return this.meta;
    }

    @Generated
    public Schema setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public Schema setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public Schema setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public Schema setMeta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<Attribute> this$attributes = this.getAttributes();
        Set<Attribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, Attribute> this$attributeNamesMap = this.attributeNamesMap;
        Map<String, Attribute> other$attributeNamesMap = other.attributeNamesMap;
        if (this$attributeNamesMap == null ? other$attributeNamesMap != null : !((Object)this$attributeNamesMap).equals(other$attributeNamesMap)) {
            return false;
        }
        Meta this$meta = this.getMeta();
        Meta other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, Attribute> $attributeNamesMap = this.attributeNamesMap;
        result = result * 59 + ($attributeNamesMap == null ? 43 : ((Object)$attributeNamesMap).hashCode());
        Meta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Schema(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", attributes=" + this.getAttributes() + ", attributeNamesMap=" + this.attributeNamesMap + ", meta=" + this.getMeta() + ")";
    }

    @XmlType(name="attribute")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Attribute
    implements AttributeContainer {
        private static final long serialVersionUID = 1683400114899587851L;
        String urn;
        @XmlElement
        @Pattern(regexp="\\p{Alpha}(-|_|\\p{Alnum})*")
        @Pattern(regexp="\\p{Alpha}(-|_|\\p{Alnum})*") String name;
        @XmlElement
        Type type;
        @XmlElement
        Set<Attribute> subAttributes;
        Map<String, Attribute> subAttributeNamesMap = new HashMap<String, Attribute>();
        @XmlElement
        boolean multiValued;
        @XmlElement
        String description;
        @XmlElement
        boolean required;
        @XmlElement
        Set<String> canonicalValues;
        @XmlElement
        boolean caseExact;
        @XmlElement
        Mutability mutability;
        @XmlElement
        Returned returned;
        @XmlElement
        Uniqueness uniqueness;
        @XmlElement
        List<String> referenceTypes;
        transient AttributeAccessor accessor;
        private boolean scimResourceIdReference;

        @Override
        public Set<Attribute> getAttributes() {
            return Collections.unmodifiableSet(this.subAttributes);
        }

        public void setSubAttributes(Set<Attribute> attributes, AddAction action) {
            if (action.equals((Object)AddAction.REPLACE)) {
                this.subAttributeNamesMap.clear();
            }
            for (Attribute attribute : attributes) {
                String name = attribute.getName();
                if (name == null) {
                    LOG.warn("Attribute name was null, skipping name indexing");
                    continue;
                }
                this.subAttributeNamesMap.put(name.toLowerCase(Locale.ENGLISH), attribute);
            }
            if (action.equals((Object)AddAction.REPLACE)) {
                this.subAttributes = attributes;
            } else {
                if (this.subAttributes == null) {
                    this.subAttributes = new TreeSet<Attribute>(Comparator.comparing(o -> o.name));
                }
                this.subAttributes.addAll(attributes);
            }
        }

        @Override
        public Attribute getAttribute(String name) {
            if (name == null) {
                return null;
            }
            return this.subAttributeNamesMap.get(name.toLowerCase(Locale.ENGLISH));
        }

        @Generated
        public Attribute() {
        }

        @Generated
        public String getUrn() {
            return this.urn;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public Set<Attribute> getSubAttributes() {
            return this.subAttributes;
        }

        @Generated
        public boolean isMultiValued() {
            return this.multiValued;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public boolean isRequired() {
            return this.required;
        }

        @Generated
        public Set<String> getCanonicalValues() {
            return this.canonicalValues;
        }

        @Generated
        public boolean isCaseExact() {
            return this.caseExact;
        }

        @Generated
        public Mutability getMutability() {
            return this.mutability;
        }

        @Generated
        public Returned getReturned() {
            return this.returned;
        }

        @Generated
        public Uniqueness getUniqueness() {
            return this.uniqueness;
        }

        @Generated
        public List<String> getReferenceTypes() {
            return this.referenceTypes;
        }

        @Generated
        public AttributeAccessor getAccessor() {
            return this.accessor;
        }

        @Generated
        public boolean isScimResourceIdReference() {
            return this.scimResourceIdReference;
        }

        @Generated
        public Attribute setUrn(String urn) {
            this.urn = urn;
            return this;
        }

        @Generated
        public Attribute setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Attribute setType(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public Attribute setSubAttributes(Set<Attribute> subAttributes) {
            this.subAttributes = subAttributes;
            return this;
        }

        @Generated
        public Attribute setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
            return this;
        }

        @Generated
        public Attribute setDescription(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public Attribute setRequired(boolean required) {
            this.required = required;
            return this;
        }

        @Generated
        public Attribute setCanonicalValues(Set<String> canonicalValues) {
            this.canonicalValues = canonicalValues;
            return this;
        }

        @Generated
        public Attribute setCaseExact(boolean caseExact) {
            this.caseExact = caseExact;
            return this;
        }

        @Generated
        public Attribute setMutability(Mutability mutability) {
            this.mutability = mutability;
            return this;
        }

        @Generated
        public Attribute setReturned(Returned returned) {
            this.returned = returned;
            return this;
        }

        @Generated
        public Attribute setUniqueness(Uniqueness uniqueness) {
            this.uniqueness = uniqueness;
            return this;
        }

        @Generated
        public Attribute setReferenceTypes(List<String> referenceTypes) {
            this.referenceTypes = referenceTypes;
            return this;
        }

        @Generated
        public Attribute setAccessor(AttributeAccessor accessor) {
            this.accessor = accessor;
            return this;
        }

        @Generated
        public Attribute setScimResourceIdReference(boolean scimResourceIdReference) {
            this.scimResourceIdReference = scimResourceIdReference;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMultiValued() != other.isMultiValued()) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            if (this.isCaseExact() != other.isCaseExact()) {
                return false;
            }
            if (this.isScimResourceIdReference() != other.isScimResourceIdReference()) {
                return false;
            }
            String this$urn = this.getUrn();
            String other$urn = other.getUrn();
            if (this$urn == null ? other$urn != null : !this$urn.equals(other$urn)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Set<Attribute> this$subAttributes = this.getSubAttributes();
            Set<Attribute> other$subAttributes = other.getSubAttributes();
            if (this$subAttributes == null ? other$subAttributes != null : !((Object)this$subAttributes).equals(other$subAttributes)) {
                return false;
            }
            Map<String, Attribute> this$subAttributeNamesMap = this.subAttributeNamesMap;
            Map<String, Attribute> other$subAttributeNamesMap = other.subAttributeNamesMap;
            if (this$subAttributeNamesMap == null ? other$subAttributeNamesMap != null : !((Object)this$subAttributeNamesMap).equals(other$subAttributeNamesMap)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Set<String> this$canonicalValues = this.getCanonicalValues();
            Set<String> other$canonicalValues = other.getCanonicalValues();
            if (this$canonicalValues == null ? other$canonicalValues != null : !((Object)this$canonicalValues).equals(other$canonicalValues)) {
                return false;
            }
            Mutability this$mutability = this.getMutability();
            Mutability other$mutability = other.getMutability();
            if (this$mutability == null ? other$mutability != null : !((Object)((Object)this$mutability)).equals((Object)other$mutability)) {
                return false;
            }
            Returned this$returned = this.getReturned();
            Returned other$returned = other.getReturned();
            if (this$returned == null ? other$returned != null : !((Object)((Object)this$returned)).equals((Object)other$returned)) {
                return false;
            }
            Uniqueness this$uniqueness = this.getUniqueness();
            Uniqueness other$uniqueness = other.getUniqueness();
            if (this$uniqueness == null ? other$uniqueness != null : !((Object)((Object)this$uniqueness)).equals((Object)other$uniqueness)) {
                return false;
            }
            List<String> this$referenceTypes = this.getReferenceTypes();
            List<String> other$referenceTypes = other.getReferenceTypes();
            return !(this$referenceTypes == null ? other$referenceTypes != null : !((Object)this$referenceTypes).equals(other$referenceTypes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Attribute;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMultiValued() ? 79 : 97);
            result = result * 59 + (this.isRequired() ? 79 : 97);
            result = result * 59 + (this.isCaseExact() ? 79 : 97);
            result = result * 59 + (this.isScimResourceIdReference() ? 79 : 97);
            String $urn = this.getUrn();
            result = result * 59 + ($urn == null ? 43 : $urn.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Set<Attribute> $subAttributes = this.getSubAttributes();
            result = result * 59 + ($subAttributes == null ? 43 : ((Object)$subAttributes).hashCode());
            Map<String, Attribute> $subAttributeNamesMap = this.subAttributeNamesMap;
            result = result * 59 + ($subAttributeNamesMap == null ? 43 : ((Object)$subAttributeNamesMap).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Set<String> $canonicalValues = this.getCanonicalValues();
            result = result * 59 + ($canonicalValues == null ? 43 : ((Object)$canonicalValues).hashCode());
            Mutability $mutability = this.getMutability();
            result = result * 59 + ($mutability == null ? 43 : ((Object)((Object)$mutability)).hashCode());
            Returned $returned = this.getReturned();
            result = result * 59 + ($returned == null ? 43 : ((Object)((Object)$returned)).hashCode());
            Uniqueness $uniqueness = this.getUniqueness();
            result = result * 59 + ($uniqueness == null ? 43 : ((Object)((Object)$uniqueness)).hashCode());
            List<String> $referenceTypes = this.getReferenceTypes();
            result = result * 59 + ($referenceTypes == null ? 43 : ((Object)$referenceTypes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Schema.Attribute(urn=" + this.getUrn() + ", name=" + this.getName() + ", type=" + this.getType() + ", subAttributes=" + this.getSubAttributes() + ", subAttributeNamesMap=" + this.subAttributeNamesMap + ", multiValued=" + this.isMultiValued() + ", description=" + this.getDescription() + ", required=" + this.isRequired() + ", canonicalValues=" + this.getCanonicalValues() + ", caseExact=" + this.isCaseExact() + ", mutability=" + this.getMutability() + ", returned=" + this.getReturned() + ", uniqueness=" + this.getUniqueness() + ", referenceTypes=" + this.getReferenceTypes() + ", accessor=" + this.getAccessor() + ", scimResourceIdReference=" + this.isScimResourceIdReference() + ")";
        }

        public static enum AddAction {
            REPLACE,
            APPEND;

        }

        @XmlEnum(value=String.class)
        public static enum Type {
            BINARY,
            BOOLEAN,
            COMPLEX,
            DATE_TIME,
            DECIMAL,
            INTEGER,
            REFERENCE,
            STRING;

        }

        public static enum Mutability {
            IMMUTABLE,
            READ_ONLY,
            READ_WRITE,
            WRITE_ONLY;

        }

        public static enum Returned {
            ALWAYS,
            DEFAULT,
            NEVER,
            REQUEST;

        }

        public static enum Uniqueness {
            GLOBAL,
            NONE,
            SERVER;

        }
    }

    private static class FieldAttributeAccessor
    implements AttributeAccessor {
        private final Field field;

        public FieldAttributeAccessor(Field field) {
            this.field = field;
        }

        @Override
        public <T> T get(Object resource) {
            try {
                this.field.setAccessible(true);
                return (T)this.field.get(resource);
            }
            catch (IllegalAccessException e) {
                throw new ScimResourceInvalidException("Schema definition is invalid", e);
            }
        }

        @Override
        public void set(Object resource, Object value) {
            try {
                this.field.setAccessible(true);
                this.field.set(resource, value);
            }
            catch (IllegalAccessException e) {
                throw new ScimResourceInvalidException("Schema definition is invalid", e);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public boolean isAccessible(Object resource) {
            try {
                return this.field.canAccess(resource);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAttributeAccessor)) {
                return false;
            }
            FieldAttributeAccessor other = (FieldAttributeAccessor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Field this$field = this.field;
            Field other$field = other.field;
            return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FieldAttributeAccessor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Field $field = this.field;
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            return result;
        }
    }

    public static interface AttributeAccessor {
        public <T> T get(Object var1);

        public void set(Object var1, Object var2);

        public Class<?> getType();

        public static AttributeAccessor forField(Field field) {
            return new FieldAttributeAccessor(field);
        }

        public boolean isAccessible(Object var1);
    }
}

