/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.schema;

import jakarta.xml.bind.annotation.XmlEnumValue;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.directory.scim.spec.annotation.ScimAttribute;
import org.apache.directory.scim.spec.annotation.ScimExtensionType;
import org.apache.directory.scim.spec.annotation.ScimResourceIdReference;
import org.apache.directory.scim.spec.annotation.ScimResourceType;
import org.apache.directory.scim.spec.annotation.ScimType;
import org.apache.directory.scim.spec.exception.ScimResourceInvalidException;
import org.apache.directory.scim.spec.resources.BaseResource;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Schemas {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Schemas.class);
    private static final Map<Class<?>, Schema.Attribute.Type> CLASS_TO_TYPE = new HashMap<Class<?>, Schema.Attribute.Type>(){
        {
            this.put(String.class, Schema.Attribute.Type.STRING);
            this.put(Character.class, Schema.Attribute.Type.STRING);
            this.put(Integer.class, Schema.Attribute.Type.INTEGER);
            this.put(Integer.TYPE, Schema.Attribute.Type.INTEGER);
            this.put(Double.class, Schema.Attribute.Type.DECIMAL);
            this.put(Double.TYPE, Schema.Attribute.Type.DECIMAL);
            this.put(Float.class, Schema.Attribute.Type.DECIMAL);
            this.put(Float.TYPE, Schema.Attribute.Type.DECIMAL);
            this.put(Boolean.class, Schema.Attribute.Type.BOOLEAN);
            this.put(Boolean.TYPE, Schema.Attribute.Type.BOOLEAN);
            this.put(LocalTime.class, Schema.Attribute.Type.DATE_TIME);
            this.put(LocalDate.class, Schema.Attribute.Type.DATE_TIME);
            this.put(LocalDateTime.class, Schema.Attribute.Type.DATE_TIME);
            this.put(Date.class, Schema.Attribute.Type.DATE_TIME);
            this.put(Instant.class, Schema.Attribute.Type.DATE_TIME);
            this.put(byte[].class, Schema.Attribute.Type.BINARY);
        }
    };

    private Schemas() {
    }

    public static Schema schemaFor(Class<? extends ScimResource> clazz) throws ScimResourceInvalidException {
        return Schemas.generateSchema(clazz, Schemas.getFieldsUpTo(clazz, BaseResource.class));
    }

    public static Schema schemaForExtension(Class<? extends ScimExtension> clazz) throws ScimResourceInvalidException {
        return Schemas.generateSchema(clazz, Schemas.getFieldsUpTo(clazz, Object.class));
    }

    private static Schema generateSchema(Class<?> clazz, List<Field> fieldList) throws ScimResourceInvalidException {
        Schema schema = new Schema();
        ScimResourceType srt = clazz.getAnnotation(ScimResourceType.class);
        ScimExtensionType set = clazz.getAnnotation(ScimExtensionType.class);
        if (srt == null && set == null) {
            log.error("Neither a ScimResourceType or ScimExtensionType annotation found");
        }
        log.debug("calling set attributes with " + fieldList.size() + " fields");
        String urn = set != null ? set.id() : srt.schema();
        HashSet<String> invalidAttributes = new HashSet<String>();
        Set<Schema.Attribute> createAttributes = Schemas.createAttributes(urn, fieldList, invalidAttributes, clazz.getSimpleName());
        schema.setAttributes(createAttributes);
        if (!invalidAttributes.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Scim attributes cannot be primitive types unless they are required.  The following values were found that are primitive and not required\n\n");
            for (String s : invalidAttributes) {
                sb.append(s);
                sb.append("\n");
            }
            throw new ScimResourceInvalidException(sb.toString());
        }
        if (srt != null) {
            schema.setId(srt.schema());
            schema.setDescription(srt.description());
            schema.setName(srt.name());
        } else {
            schema.setId(set.id());
            schema.setDescription(set.description());
            schema.setName(set.name());
        }
        return schema;
    }

    private static Set<Schema.Attribute> createAttributes(String urn, List<Field> fieldList, Set<String> invalidAttributes, String nameBase) throws ScimResourceInvalidException {
        TreeSet<Schema.Attribute> attributes = new TreeSet<Schema.Attribute>(Comparator.comparing(o -> o.name));
        for (Field f : fieldList) {
            Class<byte[]> typeClass;
            ScimAttribute sa = f.getAnnotation(ScimAttribute.class);
            log.debug("++++++++++++++++++++ Processing field " + f.getName());
            if (sa == null) {
                log.debug("Attribute {} did not have a ScimAttribute annotation", (Object)f.getName());
                continue;
            }
            f.setAccessible(true);
            String attributeName = sa.name() == null || sa.name().isEmpty() ? f.getName() : sa.name();
            if (f.getType().isPrimitive() && !sa.required()) {
                invalidAttributes.add(nameBase + "." + attributeName);
                continue;
            }
            Schema.Attribute attribute = new Schema.Attribute();
            attribute.setAccessor(Schema.AttributeAccessor.forField(f));
            attribute.setName(attributeName);
            attribute.setUrn(urn);
            List<String> canonicalTypes = null;
            Field[] enumFields = sa.canonicalValueEnum().getFields();
            log.debug("Gathered fields of off the enum, there are {} {}", (Object)enumFields.length, (Object)sa.canonicalValueEnum().getName());
            if (enumFields.length != 0) {
                if (sa.canonicalValueList().length != 1 && !sa.canonicalValueList()[0].isEmpty()) {
                    throw new ScimResourceInvalidException("You cannot set both the canonicalEnumValue and canonicalValueList attributes on the same ScimAttribute");
                }
                canonicalTypes = new ArrayList<String>();
                for (Field field : enumFields) {
                    XmlEnumValue[] annotation = (XmlEnumValue[])field.getAnnotationsByType(XmlEnumValue.class);
                    if (annotation.length != 0) {
                        canonicalTypes.add(annotation[0].value());
                        continue;
                    }
                    canonicalTypes.add(field.getName());
                }
            } else {
                canonicalTypes = Arrays.asList(sa.canonicalValueList());
            }
            if (canonicalTypes.isEmpty() || canonicalTypes.size() == 1 && canonicalTypes.get(0).isEmpty()) {
                attribute.setCanonicalValues(null);
            } else {
                attribute.setCanonicalValues(new HashSet<String>(canonicalTypes));
            }
            attribute.setCaseExact(sa.caseExact());
            attribute.setDescription(sa.description());
            if (Collection.class.isAssignableFrom(f.getType())) {
                log.debug("Attribute: '{}' is a collection", (Object)attributeName);
                ParameterizedType stringListType = (ParameterizedType)f.getGenericType();
                typeClass = (Class<byte[]>)((Object)stringListType.getActualTypeArguments()[0]);
                attribute.setMultiValued(true);
            } else if (f.getType().isArray()) {
                log.debug("Attribute: '{}' is an array", (Object)attributeName);
                typeClass = f.getType().getComponentType();
                if (typeClass == Byte.TYPE) {
                    typeClass = byte[].class;
                } else {
                    attribute.setMultiValued(true);
                }
            } else {
                typeClass = f.getType();
                attribute.setMultiValued(false);
            }
            log.debug("Attempting to set the attribute type, raw value = {}", (Object)typeClass);
            Schema.Attribute.Type type = CLASS_TO_TYPE.getOrDefault(typeClass, Schema.Attribute.Type.COMPLEX);
            attribute.setType(type);
            if (f.getAnnotation(ScimResourceIdReference.class) != null) {
                if (type == Schema.Attribute.Type.STRING) {
                    attribute.setScimResourceIdReference(true);
                } else {
                    log.warn("Field annotated with @ScimResourceIdReference must be a string: {}", (Object)f);
                }
            }
            attribute.setMutability(sa.mutability());
            List<String> refType = Arrays.asList(sa.referenceTypes());
            if (refType.isEmpty() || refType.size() == 1 && refType.get(0).isEmpty()) {
                attribute.setReferenceTypes(null);
            } else {
                attribute.setType(Schema.Attribute.Type.REFERENCE);
                attribute.setReferenceTypes(Arrays.asList(sa.referenceTypes()));
            }
            attribute.setRequired(sa.required());
            attribute.setReturned(sa.returned());
            attribute.setUniqueness(sa.uniqueness());
            ScimType st = f.getType().getAnnotation(ScimType.class);
            if (attribute.getType() == Schema.Attribute.Type.COMPLEX || st != null) {
                Class componentType;
                if (!attribute.isMultiValued()) {
                    componentType = f.getType();
                } else if (f.getType().isArray()) {
                    componentType = f.getType().getComponentType();
                } else {
                    ParameterizedType stringListType = (ParameterizedType)f.getGenericType();
                    componentType = (Class)stringListType.getActualTypeArguments()[0];
                }
                List<Field> fl = Schemas.getFieldsUpTo(componentType, Object.class);
                Set<Schema.Attribute> la = Schemas.createAttributes(urn, fl, invalidAttributes, nameBase + "." + f.getName());
                attribute.setSubAttributes(la, Schema.Attribute.AddAction.APPEND);
            }
            attributes.add(attribute);
        }
        log.debug("Returning {} attributes", (Object)attributes.size());
        return attributes;
    }

    static List<Field> getFieldsUpTo(Class<?> startClass, Class<?> exclusiveParent) {
        ArrayList<Field> currentClassFields = new ArrayList<Field>();
        Collections.addAll(currentClassFields, startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null && !parentClass.equals(exclusiveParent)) {
            List<Field> parentClassFields = Schemas.getFieldsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }
}

