/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spec.schema;

import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimResourceWithOptionalId;
import org.apache.directory.scim.spec.schema.Meta;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ServiceProviderConfiguration
extends ScimResourceWithOptionalId {
    public static final String RESOURCE_NAME = "ServiceProviderConfig";
    public static final String SCHEMA_URI = "urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig";
    private static final long serialVersionUID = -6526116522184446474L;
    @XmlElement
    String documentationUrl;
    @XmlElement
    SupportedConfiguration patch;
    @XmlElement
    BulkConfiguration bulk;
    @XmlElement
    FilterConfiguration filter;
    @XmlElement
    SupportedConfiguration changePassword;
    @XmlElement
    SupportedConfiguration sort;
    @XmlElement
    SupportedConfiguration etag;
    @XmlElement
    List<AuthenticationSchema> authenticationSchemes;

    public ServiceProviderConfiguration() {
        super(SCHEMA_URI, RESOURCE_NAME);
    }

    @Override
    public ServiceProviderConfiguration setSchemas(Set<String> schemas) {
        return (ServiceProviderConfiguration)super.setSchemas(schemas);
    }

    @Override
    public ServiceProviderConfiguration setExtensions(Map<String, ScimExtension> extensions) {
        return (ServiceProviderConfiguration)super.setExtensions(extensions);
    }

    @Override
    public ServiceProviderConfiguration setExternalId(String externalId) {
        return (ServiceProviderConfiguration)super.setExternalId(externalId);
    }

    @Override
    public ServiceProviderConfiguration setMeta(@NotNull Meta meta) {
        return (ServiceProviderConfiguration)super.setMeta(meta);
    }

    @Override
    public ServiceProviderConfiguration setId(String id) {
        return (ServiceProviderConfiguration)super.setId(id);
    }

    @Override
    public ServiceProviderConfiguration addSchema(String urn) {
        return (ServiceProviderConfiguration)super.addSchema(urn);
    }

    @Override
    public ServiceProviderConfiguration addExtension(ScimExtension extension) {
        return (ServiceProviderConfiguration)super.addExtension(extension);
    }

    @Generated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Generated
    public SupportedConfiguration getPatch() {
        return this.patch;
    }

    @Generated
    public BulkConfiguration getBulk() {
        return this.bulk;
    }

    @Generated
    public FilterConfiguration getFilter() {
        return this.filter;
    }

    @Generated
    public SupportedConfiguration getChangePassword() {
        return this.changePassword;
    }

    @Generated
    public SupportedConfiguration getSort() {
        return this.sort;
    }

    @Generated
    public SupportedConfiguration getEtag() {
        return this.etag;
    }

    @Generated
    public List<AuthenticationSchema> getAuthenticationSchemes() {
        return this.authenticationSchemes;
    }

    @Generated
    public ServiceProviderConfiguration setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
        return this;
    }

    @Generated
    public ServiceProviderConfiguration setPatch(SupportedConfiguration patch) {
        this.patch = patch;
        return this;
    }

    @Generated
    public ServiceProviderConfiguration setBulk(BulkConfiguration bulk) {
        this.bulk = bulk;
        return this;
    }

    @Generated
    public ServiceProviderConfiguration setFilter(FilterConfiguration filter) {
        this.filter = filter;
        return this;
    }

    @Generated
    public ServiceProviderConfiguration setChangePassword(SupportedConfiguration changePassword) {
        this.changePassword = changePassword;
        return this;
    }

    @Generated
    public ServiceProviderConfiguration setSort(SupportedConfiguration sort) {
        this.sort = sort;
        return this;
    }

    @Generated
    public ServiceProviderConfiguration setEtag(SupportedConfiguration etag) {
        this.etag = etag;
        return this;
    }

    @Generated
    public ServiceProviderConfiguration setAuthenticationSchemes(List<AuthenticationSchema> authenticationSchemes) {
        this.authenticationSchemes = authenticationSchemes;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ServiceProviderConfiguration(documentationUrl=" + this.getDocumentationUrl() + ", patch=" + this.getPatch() + ", bulk=" + this.getBulk() + ", filter=" + this.getFilter() + ", changePassword=" + this.getChangePassword() + ", sort=" + this.getSort() + ", etag=" + this.getEtag() + ", authenticationSchemes=" + this.getAuthenticationSchemes() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceProviderConfiguration)) {
            return false;
        }
        ServiceProviderConfiguration other = (ServiceProviderConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$documentationUrl = this.getDocumentationUrl();
        String other$documentationUrl = other.getDocumentationUrl();
        if (this$documentationUrl == null ? other$documentationUrl != null : !this$documentationUrl.equals(other$documentationUrl)) {
            return false;
        }
        SupportedConfiguration this$patch = this.getPatch();
        SupportedConfiguration other$patch = other.getPatch();
        if (this$patch == null ? other$patch != null : !((Object)this$patch).equals(other$patch)) {
            return false;
        }
        BulkConfiguration this$bulk = this.getBulk();
        BulkConfiguration other$bulk = other.getBulk();
        if (this$bulk == null ? other$bulk != null : !((Object)this$bulk).equals(other$bulk)) {
            return false;
        }
        FilterConfiguration this$filter = this.getFilter();
        FilterConfiguration other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        SupportedConfiguration this$changePassword = this.getChangePassword();
        SupportedConfiguration other$changePassword = other.getChangePassword();
        if (this$changePassword == null ? other$changePassword != null : !((Object)this$changePassword).equals(other$changePassword)) {
            return false;
        }
        SupportedConfiguration this$sort = this.getSort();
        SupportedConfiguration other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        SupportedConfiguration this$etag = this.getEtag();
        SupportedConfiguration other$etag = other.getEtag();
        if (this$etag == null ? other$etag != null : !((Object)this$etag).equals(other$etag)) {
            return false;
        }
        List<AuthenticationSchema> this$authenticationSchemes = this.getAuthenticationSchemes();
        List<AuthenticationSchema> other$authenticationSchemes = other.getAuthenticationSchemes();
        return !(this$authenticationSchemes == null ? other$authenticationSchemes != null : !((Object)this$authenticationSchemes).equals(other$authenticationSchemes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceProviderConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $documentationUrl = this.getDocumentationUrl();
        result = result * 59 + ($documentationUrl == null ? 43 : $documentationUrl.hashCode());
        SupportedConfiguration $patch = this.getPatch();
        result = result * 59 + ($patch == null ? 43 : ((Object)$patch).hashCode());
        BulkConfiguration $bulk = this.getBulk();
        result = result * 59 + ($bulk == null ? 43 : ((Object)$bulk).hashCode());
        FilterConfiguration $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        SupportedConfiguration $changePassword = this.getChangePassword();
        result = result * 59 + ($changePassword == null ? 43 : ((Object)$changePassword).hashCode());
        SupportedConfiguration $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        SupportedConfiguration $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : ((Object)$etag).hashCode());
        List<AuthenticationSchema> $authenticationSchemes = this.getAuthenticationSchemes();
        result = result * 59 + ($authenticationSchemes == null ? 43 : ((Object)$authenticationSchemes).hashCode());
        return result;
    }

    public static class SupportedConfiguration
    implements Serializable {
        private static final long serialVersionUID = 3646886915978382920L;
        boolean supported;

        @Generated
        public SupportedConfiguration() {
        }

        @Generated
        public boolean isSupported() {
            return this.supported;
        }

        @Generated
        public SupportedConfiguration setSupported(boolean supported) {
            this.supported = supported;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SupportedConfiguration)) {
                return false;
            }
            SupportedConfiguration other = (SupportedConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isSupported() == other.isSupported();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SupportedConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSupported() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceProviderConfiguration.SupportedConfiguration(supported=" + this.isSupported() + ")";
        }
    }

    public static class BulkConfiguration
    extends SupportedConfiguration {
        private static final long serialVersionUID = 8312025367100671778L;
        int maxOperations;
        int maxPayloadSize;

        @Generated
        public BulkConfiguration() {
        }

        @Generated
        public int getMaxOperations() {
            return this.maxOperations;
        }

        @Generated
        public int getMaxPayloadSize() {
            return this.maxPayloadSize;
        }

        @Generated
        public BulkConfiguration setMaxOperations(int maxOperations) {
            this.maxOperations = maxOperations;
            return this;
        }

        @Generated
        public BulkConfiguration setMaxPayloadSize(int maxPayloadSize) {
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "ServiceProviderConfiguration.BulkConfiguration(maxOperations=" + this.getMaxOperations() + ", maxPayloadSize=" + this.getMaxPayloadSize() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkConfiguration)) {
                return false;
            }
            BulkConfiguration other = (BulkConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMaxOperations() != other.getMaxOperations()) {
                return false;
            }
            return this.getMaxPayloadSize() == other.getMaxPayloadSize();
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BulkConfiguration;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMaxOperations();
            result = result * 59 + this.getMaxPayloadSize();
            return result;
        }
    }

    public static class FilterConfiguration
    extends SupportedConfiguration {
        private static final long serialVersionUID = 1887771731291732875L;
        int maxResults;

        @Generated
        public FilterConfiguration() {
        }

        @Generated
        public int getMaxResults() {
            return this.maxResults;
        }

        @Generated
        public FilterConfiguration setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "ServiceProviderConfiguration.FilterConfiguration(maxResults=" + this.getMaxResults() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterConfiguration)) {
                return false;
            }
            FilterConfiguration other = (FilterConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.getMaxResults() == other.getMaxResults();
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FilterConfiguration;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMaxResults();
            return result;
        }
    }

    @XmlType
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class AuthenticationSchema
    implements Serializable {
        private static final long serialVersionUID = 1286852277186580002L;
        @XmlElement
        Type type;
        @XmlElement
        String name;
        @XmlElement
        String description;
        @XmlElement
        String specUri;
        @XmlElement
        String documentationUri;

        public static AuthenticationSchema oauth() {
            return AuthenticationSchema.fromType(Type.OAUTH);
        }

        public static AuthenticationSchema oauth2() {
            return AuthenticationSchema.fromType(Type.OAUTH2);
        }

        public static AuthenticationSchema oauthBearer() {
            return AuthenticationSchema.fromType(Type.OAUTH_BEARER);
        }

        public static AuthenticationSchema httpBasic() {
            return AuthenticationSchema.fromType(Type.HTTP_BASIC);
        }

        public static AuthenticationSchema httpDigest() {
            return AuthenticationSchema.fromType(Type.HTTP_DIGEST);
        }

        private static AuthenticationSchema fromType(Type type) {
            return new AuthenticationSchema().setType(type).setName(type.defaultName).setDescription(type.defaultDescription).setSpecUri(type.specUri);
        }

        @Generated
        public AuthenticationSchema() {
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getSpecUri() {
            return this.specUri;
        }

        @Generated
        public String getDocumentationUri() {
            return this.documentationUri;
        }

        @Generated
        public AuthenticationSchema setType(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public AuthenticationSchema setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public AuthenticationSchema setDescription(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public AuthenticationSchema setSpecUri(String specUri) {
            this.specUri = specUri;
            return this;
        }

        @Generated
        public AuthenticationSchema setDocumentationUri(String documentationUri) {
            this.documentationUri = documentationUri;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthenticationSchema)) {
                return false;
            }
            AuthenticationSchema other = (AuthenticationSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$specUri = this.getSpecUri();
            String other$specUri = other.getSpecUri();
            if (this$specUri == null ? other$specUri != null : !this$specUri.equals(other$specUri)) {
                return false;
            }
            String this$documentationUri = this.getDocumentationUri();
            String other$documentationUri = other.getDocumentationUri();
            return !(this$documentationUri == null ? other$documentationUri != null : !this$documentationUri.equals(other$documentationUri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthenticationSchema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $specUri = this.getSpecUri();
            result = result * 59 + ($specUri == null ? 43 : $specUri.hashCode());
            String $documentationUri = this.getDocumentationUri();
            result = result * 59 + ($documentationUri == null ? 43 : $documentationUri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceProviderConfiguration.AuthenticationSchema(type=" + this.getType() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", specUri=" + this.getSpecUri() + ", documentationUri=" + this.getDocumentationUri() + ")";
        }

        public static enum Type {
            OAUTH("oauth", "OAuth 1.0", "Authentication scheme using the OAuth 1.0 Standard", "https://www.rfc-editor.org/rfc/rfc5849.html"),
            OAUTH2("oauth2", "OAuth 2.0", "Authentication scheme using the OAuth 2.0 Standard", "https://www.rfc-editor.org/rfc/rfc6749.html"),
            OAUTH_BEARER("oauthbearertoken", "OAuth Bearer Token", "Authentication scheme using the OAuth Bearer Token Standard", "http://www.rfc-editor.org/info/rfc6750"),
            HTTP_BASIC("httpbasic", "HTTP Basic", "Authentication scheme using the HTTP Basic Standard", "http://www.rfc-editor.org/info/rfc2617"),
            HTTP_DIGEST("httpdigest", "HTTP Digest", "Authentication scheme using the HTTP Digest Standard", "https://www.rfc-editor.org/rfc/rfc7616.html");

            private final String type;
            private final String specUri;
            private final String defaultName;
            private final String defaultDescription;

            private Type(String type, String defaultName, String defaultDescription, String specUri) {
                this.type = type;
                this.defaultName = defaultName;
                this.defaultDescription = defaultDescription;
                this.specUri = specUri;
            }

            public String toString() {
                return this.type;
            }
        }
    }
}

