/*
 * Decompiled with CFR 0.152.
 */
package jdbm;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;

public final class RecordManagerFactory {
    public static RecordManager createRecordManager(String name) throws IOException {
        return RecordManagerFactory.createRecordManager(name, new Properties());
    }

    public static RecordManager createRecordManager(String name, Properties options) throws IOException {
        RecordManagerProvider factory;
        String provider = options.getProperty("jdbm.provider", "jdbm.recman.Provider");
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(provider);
            factory = (RecordManagerProvider)clazz.newInstance();
        }
        catch (Exception except) {
            throw new IllegalArgumentException("Invalid record manager provider: " + provider + "\n[" + except.getClass().getName() + ": " + except.getMessage() + "]");
        }
        return factory.createRecordManager(name, options);
    }
}

