/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.List;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.changelog.ChangeLogEvent;
import org.apache.directory.server.core.changelog.ChangeLogSearchEngine;
import org.apache.directory.server.core.changelog.ChangeLogStore;
import org.apache.directory.server.core.changelog.MemoryChangeLogStore;
import org.apache.directory.server.core.changelog.SearchableChangeLogStore;
import org.apache.directory.server.core.changelog.Tag;
import org.apache.directory.server.core.changelog.TagSearchEngine;
import org.apache.directory.server.core.changelog.TaggableChangeLogStore;
import org.apache.directory.server.core.changelog.TaggableSearchableChangeLogStore;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.ldif.LdifEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChangeLog
implements ChangeLog {
    private boolean enabled;
    private Tag latest;
    private ChangeLogStore store = new MemoryChangeLogStore();
    private boolean exposeChangeLog;
    private String partitionSuffix = "ou=changelog";
    private String revContainerName = "ou=revisions";
    private String tagContainerName = "ou=tags";

    @Override
    public ChangeLogStore getChangeLogStore() {
        return this.store;
    }

    @Override
    public void setChangeLogStore(ChangeLogStore store) {
        this.store = store;
    }

    @Override
    public long getCurrentRevision() throws Exception {
        return this.store.getCurrentRevision();
    }

    @Override
    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, LdifEntry reverse) throws Exception {
        if (!this.enabled) {
            throw new IllegalStateException("The ChangeLog has not been enabled.");
        }
        return this.store.log(principal, forward, reverse);
    }

    @Override
    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, List<LdifEntry> reverses) throws Exception {
        if (!this.enabled) {
            throw new IllegalStateException("The ChangeLog has not been enabled.");
        }
        return this.store.log(principal, forward, reverses);
    }

    @Override
    public boolean isLogSearchSupported() {
        return this.store instanceof SearchableChangeLogStore;
    }

    @Override
    public boolean isTagSearchSupported() {
        return this.store instanceof TaggableSearchableChangeLogStore;
    }

    @Override
    public boolean isTagStorageSupported() {
        return this.store instanceof TaggableChangeLogStore;
    }

    @Override
    public ChangeLogSearchEngine getChangeLogSearchEngine() {
        if (this.isLogSearchSupported()) {
            return ((SearchableChangeLogStore)this.store).getChangeLogSearchEngine();
        }
        throw new UnsupportedOperationException("The underlying changelog store does not support searching through it's logs");
    }

    @Override
    public TagSearchEngine getTagSearchEngine() {
        if (this.isTagSearchSupported()) {
            return ((TaggableSearchableChangeLogStore)this.store).getTagSearchEngine();
        }
        throw new UnsupportedOperationException("The underlying changelog store does not support searching through it's tags");
    }

    @Override
    public Tag tag(long revision, String description) throws Exception {
        if (revision < 0L) {
            throw new IllegalArgumentException("revision must be greater than or equal to 0");
        }
        if (revision > this.store.getCurrentRevision()) {
            throw new IllegalArgumentException("revision must be less than or equal to the current revision");
        }
        if (this.store instanceof TaggableChangeLogStore) {
            this.latest = ((TaggableChangeLogStore)this.store).tag(revision);
            return this.latest;
        }
        this.latest = new Tag(revision, description);
        return this.latest;
    }

    @Override
    public Tag tag(long revision) throws Exception {
        return this.tag(revision, null);
    }

    @Override
    public Tag tag(String description) throws Exception {
        return this.tag(this.store.getCurrentRevision(), description);
    }

    @Override
    public Tag tag() throws Exception {
        return this.tag(this.store.getCurrentRevision(), null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Tag getLatest() throws Exception {
        if (this.latest != null) {
            return this.latest;
        }
        if (this.store instanceof TaggableChangeLogStore) {
            this.latest = ((TaggableChangeLogStore)this.store).getLatest();
            return this.latest;
        }
        return null;
    }

    @Override
    public void init(DirectoryService service) throws Exception {
        if (this.enabled) {
            this.store.init(service);
            if (this.exposeChangeLog && this.isTagSearchSupported()) {
                Partition partition = ((TaggableSearchableChangeLogStore)this.store).getPartition(this.partitionSuffix, this.revContainerName, this.tagContainerName);
                partition.init(service);
                service.addPartition(partition);
            }
        }
    }

    @Override
    public void sync() throws Exception {
        if (this.enabled) {
            this.store.sync();
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.enabled) {
            this.store.destroy();
        }
    }

    @Override
    public boolean isExposeChangeLog() {
        return this.exposeChangeLog;
    }

    @Override
    public void setExposeChangeLog(boolean exposeChangeLog) {
        this.exposeChangeLog = exposeChangeLog;
    }

    @Override
    public void setPartitionSuffix(String suffix) {
        this.partitionSuffix = suffix;
    }

    @Override
    public void setRevisionsContainerName(String revContainerName) {
        this.revContainerName = revContainerName;
    }

    @Override
    public void setTagsContainerName(String tagContainerName) {
        this.tagContainerName = tagContainerName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeLog tag[").append(this.latest).append("]\n");
        sb.append("    store : \n").append(this.store);
        return sb.toString();
    }
}

