/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectiveAttributesSchemaChecker {
    private PartitionNexus nexus = null;
    private AttributeTypeRegistry attrTypeRegistry = null;

    public CollectiveAttributesSchemaChecker(PartitionNexus nexus, AttributeTypeRegistry attrTypeRegistry) {
        this.nexus = nexus;
        this.attrTypeRegistry = attrTypeRegistry;
    }

    void checkAdd(LdapDN normName, ServerEntry entry) throws Exception {
        if (entry.hasObjectClass("collectiveAttributeSubentry")) {
            return;
        }
        if (this.containsAnyCollectiveAttributes(entry)) {
            throw new LdapSchemaViolationException("Collective attributes cannot be stored in non-collectiveAttributeSubentries", ResultCodeEnum.OTHER);
        }
    }

    public void checkModify(OperationContext opContext, LdapDN normName, List<Modification> mods) throws Exception {
        ClonedServerEntry originalEntry = opContext.lookup(normName, ByPassConstants.LOOKUP_BYPASS);
        ServerEntry targetEntry = (ServerEntry)SchemaUtils.getTargetEntry(mods, originalEntry);
        EntryAttribute targetObjectClasses = targetEntry.get("objectClass");
        if (targetObjectClasses.contains("collectiveAttributeSubentry")) {
            return;
        }
        if (this.addsAnyCollectiveAttributes(mods)) {
            throw new LdapSchemaViolationException("Cannot operate on collective attributes in non-collectiveAttributeSubentries", ResultCodeEnum.OTHER);
        }
    }

    private boolean addsAnyCollectiveAttributes(List<Modification> mods) throws NamingException {
        for (Modification mod : mods) {
            ModificationOperation modOp;
            ServerAttribute attr = (ServerAttribute)mod.getAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType == null) {
                if (!this.attrTypeRegistry.hasAttributeType(attr.getUpId())) {
                    throw new LdapInvalidAttributeIdentifierException();
                }
                attrType = this.attrTypeRegistry.lookup(attr.getUpId());
            }
            if ((modOp = mod.getOperation()) != ModificationOperation.ADD_ATTRIBUTE && modOp != ModificationOperation.REPLACE_ATTRIBUTE || !attrType.isCollective()) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnyCollectiveAttributes(ServerEntry entry) throws NamingException {
        Set<AttributeType> attributeTypes = entry.getAttributeTypes();
        for (AttributeType attributeType : attributeTypes) {
            if (!attributeType.isCollective()) continue;
            return true;
        }
        return false;
    }
}

