/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.tree;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.tree.LeafNode;
import org.apache.directory.server.core.partition.tree.Node;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchNode
implements Node {
    private static final Logger LOG = LoggerFactory.getLogger(BranchNode.class);
    private Map<String, Node> children = new HashMap<String, Node>(3);

    public boolean isLeaf() {
        return false;
    }

    public BranchNode recursivelyAddPartition(BranchNode current, LdapDN dn, int index, Partition partition) throws NamingException {
        String rdnAtIndex = dn.getRdn(index).toString();
        if (index == dn.size() - 1) {
            return current.addNode(rdnAtIndex, new LeafNode(partition));
        }
        Node newNode = current.getChild(rdnAtIndex);
        if (newNode instanceof LeafNode) {
            String message = "Overlapping partitions are not allowed";
            LOG.error(message);
            throw new NamingException(message);
        }
        if (newNode == null) {
            newNode = new BranchNode();
        }
        BranchNode child = this.recursivelyAddPartition((BranchNode)newNode, dn, index + 1, partition);
        return current.addNode(rdnAtIndex, child);
    }

    public BranchNode addNode(String rdn, Node child) {
        this.children.put(rdn, child);
        return this;
    }

    public boolean contains(String rdn) {
        return this.children.containsKey(rdn);
    }

    public Node getChild(String rdn) {
        if (this.children.containsKey(rdn)) {
            return this.children.get(rdn);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean isFirst = true;
        for (Node child : this.children.values()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            if (child instanceof BranchNode) {
                sb.append("Branch: ").append(child.toString());
                continue;
            }
            sb.append("Leaf: ").append("'").append(child.toString()).append("'");
        }
        sb.append("}");
        return sb.toString();
    }
}

