/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.subtree.RefinementLeafEvaluator;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class RefinementEvaluator {
    private RefinementLeafEvaluator leafEvaluator;

    public RefinementEvaluator(RefinementLeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public boolean evaluate(ExprNode node, EntryAttribute objectClasses) throws NamingException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (objectClasses == null) {
            throw new IllegalArgumentException("objectClasses cannot be null");
        }
        if (!((ServerAttribute)objectClasses).instanceOf("objectClass")) {
            throw new IllegalArgumentException("Attribute objectClasses should be of id 'objectClass'");
        }
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate((SimpleNode)node, objectClasses);
        }
        BranchNode bnode = (BranchNode)node;
        if (node instanceof OrNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (!this.evaluate(child, objectClasses)) continue;
                return true;
            }
            return false;
        }
        if (node instanceof AndNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (this.evaluate(child, objectClasses)) continue;
                return false;
            }
            return true;
        }
        if (node instanceof NotNode) {
            if (null != bnode.getFirstChild()) {
                return !this.evaluate(bnode.getFirstChild(), objectClasses);
            }
            throw new IllegalArgumentException("Negation has no child: " + node);
        }
        throw new IllegalArgumentException("Unrecognized branch node operator: " + bnode);
    }
}

