/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;
import org.apache.directory.shared.ldap.trigger.TriggerSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerSpecCache {
    private static final String PRESCRIPTIVE_TRIGGER_ATTR = "prescriptiveTriggerSpecification";
    private static final Logger LOG = LoggerFactory.getLogger(TriggerSpecCache.class);
    private final Map<String, List<TriggerSpecification>> triggerSpecs = new HashMap<String, List<TriggerSpecification>>();
    private final PartitionNexus nexus;
    private final TriggerSpecificationParser triggerSpecParser;

    public TriggerSpecCache(DirectoryService directoryService) throws Exception {
        this.nexus = directoryService.getPartitionNexus();
        final AttributeTypeRegistry registry = directoryService.getRegistries().getAttributeTypeRegistry();
        this.triggerSpecParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            @Override
            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return registry.getNormalizerMapping();
            }
        });
        this.initialize(directoryService);
    }

    private void initialize(DirectoryService directoryService) throws Exception {
        Iterator<String> suffixes = this.nexus.listSuffixes(null);
        while (suffixes.hasNext()) {
            String suffix = suffixes.next();
            LdapDN baseDn = new LdapDN(suffix);
            EqualityNode<String> filter = new EqualityNode<String>("objectClass", new ClientStringValue("triggerExecutionSubentry"));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            adminDn.normalize(directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
            EntryFilteringCursor results = this.nexus.search(new SearchOperationContext(adminSession, baseDn, AliasDerefMode.DEREF_ALWAYS, filter, ctls));
            while (results.next()) {
                ClonedServerEntry resultEntry = (ClonedServerEntry)results.get();
                LdapDN subentryDn = resultEntry.getDn();
                EntryAttribute triggerSpec = resultEntry.get(PRESCRIPTIVE_TRIGGER_ATTR);
                if (triggerSpec == null) {
                    LOG.warn("Found triggerExecutionSubentry '" + subentryDn + "' without any " + PRESCRIPTIVE_TRIGGER_ATTR);
                    continue;
                }
                LdapDN normSubentryName = subentryDn.normalize(directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
                this.subentryAdded(normSubentryName, resultEntry);
            }
            results.close();
        }
    }

    private boolean hasPrescriptiveTrigger(ServerEntry entry) throws Exception {
        EntryAttribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        return triggerSpec != null;
    }

    public void subentryAdded(LdapDN normName, ServerEntry entry) throws Exception {
        EntryAttribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        if (triggerSpec == null) {
            return;
        }
        ArrayList<TriggerSpecification> subentryTriggerSpecs = new ArrayList<TriggerSpecification>();
        for (Value value : triggerSpec) {
            TriggerSpecification item = null;
            try {
                item = this.triggerSpecParser.parse((String)value.get());
                subentryTriggerSpecs.add(item);
            }
            catch (ParseException e) {
                String msg = "TriggerSpecification parser failure on '" + item + "'. Cannnot add Trigger Specificaitons to TriggerSpecCache.";
                LOG.error(msg, e);
            }
        }
        this.triggerSpecs.put(normName.toString(), subentryTriggerSpecs);
    }

    public void subentryDeleted(LdapDN normName, ServerEntry entry) throws Exception {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        this.triggerSpecs.remove(normName.toString());
    }

    public void subentryModified(ModifyOperationContext opContext, ServerEntry entry) throws Exception {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        LdapDN normName = opContext.getDn();
        List<Modification> mods = opContext.getModItems();
        boolean isTriggerSpecModified = false;
        for (Modification mod : mods) {
            isTriggerSpecModified |= mod.getAttribute().contains(PRESCRIPTIVE_TRIGGER_ATTR);
        }
        if (isTriggerSpecModified) {
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public List<TriggerSpecification> getSubentryTriggerSpecs(String subentryDn) {
        List<TriggerSpecification> subentryTriggerSpecs = this.triggerSpecs.get(subentryDn);
        if (subentryTriggerSpecs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(subentryTriggerSpecs);
    }

    public void subentryRenamed(LdapDN oldName, LdapDN newName) {
        this.triggerSpecs.put(newName.toString(), this.triggerSpecs.remove(oldName.toString()));
    }
}

