/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapService;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.message.BindStatus;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapSession {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSession.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final AbandonableRequest[] EMPTY_ABANDONABLES = new AbandonableRequest[0];
    private final String outstandingLock;
    private final IoSession ioSession;
    private CoreSession coreSession;
    private LdapService ldapService;
    private Map<Integer, AbandonableRequest> outstandingRequests;
    private BindStatus bindStatus;
    private String currentMechanism;
    private Map<String, Object> saslProperties;

    public LdapSession(IoSession ioSession) {
        this.ioSession = ioSession;
        this.outstandingLock = "OutstandingRequestLock: " + ioSession.toString();
        this.outstandingRequests = new ConcurrentHashMap<Integer, AbandonableRequest>();
        this.bindStatus = BindStatus.ANONYMOUS;
        this.saslProperties = new HashMap<String, Object>();
    }

    public boolean isAuthenticated() {
        return this.coreSession != null && this.bindStatus == BindStatus.AUTHENTICATED;
    }

    public boolean isAnonymous() {
        return this.bindStatus == BindStatus.ANONYMOUS;
    }

    public boolean isAuthPending() {
        return this.bindStatus == BindStatus.AUTH_PENDING;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    public void setCoreSession(CoreSession coreSession) {
        this.coreSession = coreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonAllOutstandingRequests() {
        String string = this.outstandingLock;
        synchronized (string) {
            AbandonableRequest[] abandonables;
            for (AbandonableRequest abandonable : abandonables = this.outstandingRequests.values().toArray(EMPTY_ABANDONABLES)) {
                this.abandonOutstandingRequest(abandonable.getMessageId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbandonableRequest abandonOutstandingRequest(Integer messageId) {
        AbandonableRequest request = null;
        String string = this.outstandingLock;
        synchronized (string) {
            request = this.outstandingRequests.remove(messageId);
        }
        if (request == null) {
            LOG.warn("AbandonableRequest with messageId {} not found in outstandingRequests.", messageId);
            return null;
        }
        if (request.isAbandoned()) {
            LOG.warn("AbandonableRequest with messageId {} has already been abandoned", messageId);
            return request;
        }
        request.abandon();
        if (IS_DEBUG) {
            LOG.debug("AbandonRequest on AbandonableRequest wth messageId {} was successful.", messageId);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutstandingRequest(AbandonableRequest request) {
        String string = this.outstandingLock;
        synchronized (string) {
            this.outstandingRequests.put(request.getMessageId(), request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOutstandingRequest(AbandonableRequest request) {
        String string = this.outstandingLock;
        synchronized (string) {
            this.outstandingRequests.remove(request.getMessageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, AbandonableRequest> getOutstandingRequests() {
        String string = this.outstandingLock;
        synchronized (string) {
            return Collections.unmodifiableMap(this.outstandingRequests);
        }
    }

    public BindStatus getBindStatus() {
        return this.bindStatus;
    }

    public void setAuthPending() {
        this.bindStatus = BindStatus.AUTH_PENDING;
    }

    public void setAnonymous() {
        this.bindStatus = BindStatus.ANONYMOUS;
    }

    public void setAuthenticated() {
        this.bindStatus = BindStatus.AUTHENTICATED;
    }

    public String getCurrentMechanism() {
        return this.currentMechanism;
    }

    public void putSaslProperty(String property, Object value) {
        this.saslProperties.put(property, value);
    }

    public Object getSaslProperty(String property) {
        return this.saslProperties.get(property);
    }

    public void clearSaslProperties() {
        this.saslProperties.clear();
    }

    public void removeSaslProperty(String property) {
        this.saslProperties.remove(property);
    }

    public LdapService getLdapServer() {
        return this.ldapService;
    }

    public void setLdapServer(LdapService ldapService) {
        this.ldapService = ldapService;
    }
}

