/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslFilter
extends IoFilterAdapter {
    private static final Logger log = LoggerFactory.getLogger(SaslFilter.class);
    public static final String DISABLE_SECURITY_LAYER_ONCE = SaslFilter.class.getName() + ".DisableSecurityLayerOnce";
    private SaslServer saslServer;

    public SaslFilter(SaslServer saslServer) {
        if (saslServer == null) {
            throw new IllegalStateException();
        }
        this.saslServer = saslServer;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SaslException {
        boolean hasSecurityLayer;
        log.debug("Message received:  {}", message);
        String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        boolean bl = hasSecurityLayer = qop != null && (qop.equals("auth-int") || qop.equals("auth-conf"));
        if (hasSecurityLayer) {
            ByteBuffer buf = (ByteBuffer)message;
            int bufferLength = buf.getInt();
            byte[] bufferBytes = new byte[bufferLength];
            buf.get(bufferBytes);
            log.debug("Will use SASL to unwrap received message of length:  {}", bufferLength);
            byte[] token = this.saslServer.unwrap(bufferBytes, 0, bufferBytes.length);
            nextFilter.messageReceived(session, ByteBuffer.wrap(token));
        } else {
            log.debug("Will not use SASL on received message.");
            nextFilter.messageReceived(session, message);
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws SaslException {
        log.debug("Filtering write request:  {}", writeRequest);
        if (session.containsAttribute(DISABLE_SECURITY_LAYER_ONCE)) {
            log.debug("Disabling SaslFilter once; will not use SASL on write request.");
            session.removeAttribute(DISABLE_SECURITY_LAYER_ONCE);
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        boolean hasSecurityLayer = qop != null && (qop.equals("auth-int") || qop.equals("auth-conf"));
        ByteBuffer saslLayerBuffer = null;
        if (hasSecurityLayer) {
            ByteBuffer buf = (ByteBuffer)writeRequest.getMessage();
            int bufferLength = buf.remaining();
            byte[] bufferBytes = new byte[bufferLength];
            buf.get(bufferBytes);
            log.debug("Will use SASL to wrap message of length:  {}", bufferLength);
            byte[] saslLayer = this.saslServer.wrap(bufferBytes, 0, bufferBytes.length);
            saslLayerBuffer = ByteBuffer.allocate(4 + saslLayer.length);
            saslLayerBuffer.putInt(saslLayer.length);
            saslLayerBuffer.put(saslLayer);
            saslLayerBuffer.position(0);
            saslLayerBuffer.limit(4 + saslLayer.length);
            log.debug("Sending encrypted token of length {}.", saslLayerBuffer.limit());
            nextFilter.filterWrite(session, new IoFilter.WriteRequest(saslLayerBuffer, writeRequest.getFuture()));
        } else {
            log.debug("Will not use SASL on write request.");
            nextFilter.filterWrite(session, writeRequest);
        }
    }
}

