/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.plain;

import java.io.IOException;
import javax.naming.InvalidNameException;
import javax.security.sasl.SaslException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslServer;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.PrepareString;
import org.apache.directory.shared.ldap.util.StringTools;

public class PlainSaslServer
extends AbstractSaslServer {
    public static final String SASL_PLAIN_AUTHZID = "authzid";
    public static final String SASL_PLAIN_AUTHCID = "authcid";
    public static final String SASL_PLAIN_PASSWORD = "password";
    private NegotiationState state = NegotiationState.INITIALIZED;

    public PlainSaslServer(LdapSession ldapSession, CoreSession adminSession, BindRequest bindRequest) {
        super(ldapSession, adminSession, bindRequest);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_AUTHZID);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_AUTHCID);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_PASSWORD);
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    public byte[] evaluateResponse(byte[] initialResponse) throws SaslException {
        if (StringTools.isEmpty(initialResponse)) {
            this.state = NegotiationState.MECH_RECEIVED;
            return null;
        }
        InitialResponse element = InitialResponse.AUTHZID_EXPECTED;
        String authzId = null;
        String authcId = null;
        String password = null;
        int start = 0;
        int end = 0;
        try {
            for (byte b : initialResponse) {
                if (b == 0) {
                    if (start - end == 0) {
                        if (element == InitialResponse.AUTHZID_EXPECTED) {
                            element = InitialResponse.AUTHCID_EXPECTED;
                            continue;
                        }
                        throw new IllegalArgumentException("response with no auhcid or no password");
                    }
                    String value = new String(initialResponse, ++start, end - start + 1, "UTF-8");
                    switch (element) {
                        case AUTHZID_EXPECTED: {
                            element = InitialResponse.AUTHCID_EXPECTED;
                            authzId = PrepareString.normalize(value, PrepareString.StringType.CASE_EXACT_IA5);
                            start = ++end;
                            break;
                        }
                        case AUTHCID_EXPECTED: {
                            element = InitialResponse.PASSWORD_EXPECTED;
                            authcId = PrepareString.normalize(value, PrepareString.StringType.DIRECTORY_STRING);
                            start = ++end;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("'\u0000' chars are not allowed in authcid or no password");
                        }
                    }
                    continue;
                }
                ++end;
            }
            if (start == end) {
                throw new IllegalArgumentException("response with no auhcid or no password");
            }
            String value = StringTools.utf8ToString(initialResponse, ++start, end - start + 1);
            password = PrepareString.normalize(value, PrepareString.StringType.CASE_EXACT_IA5);
            if (authcId == null || password == null) {
                throw new IllegalArgumentException("response with no auhcid or no password");
            }
            CoreSession userSession = this.authenticate(authcId, password);
            this.getLdapSession().setCoreSession(userSession);
            this.state = NegotiationState.COMPLETED;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("The given InitialReponse is incorrect");
        }
        catch (InvalidNameException ine) {
            throw new IllegalArgumentException("Cannot authenticate an invalid authcid DN");
        }
        catch (Exception e) {
            throw new SaslException("Cannot authenticate the user " + authcId);
        }
        return StringTools.EMPTY_BYTES;
    }

    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    private CoreSession authenticate(String user, String password) throws InvalidNameException, Exception {
        BindOperationContext bindContext = new BindOperationContext(this.getLdapSession().getCoreSession());
        bindContext.setDn(new LdapDN(user));
        bindContext.setCredentials(StringTools.getBytesUtf8(password));
        this.getAdminSession().getDirectoryService().getOperationManager().bind(bindContext);
        return bindContext.getSession();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InitialResponse {
        AUTHZID_EXPECTED,
        AUTHCID_EXPECTED,
        PASSWORD_EXPECTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NegotiationState {
        INITIALIZED,
        MECH_RECEIVED,
        COMPLETED;

    }
}

