/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMatchingRuleRegistry
implements MatchingRuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMatchingRuleRegistry.class);
    private final Map<String, MatchingRule> byOid;
    private final OidRegistry oidRegistry;

    public DefaultMatchingRuleRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.byOid = new HashMap<String, MatchingRule>();
    }

    @Override
    public MatchingRule lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            MatchingRule matchingRule = this.byOid.get(id);
            if (LOG.isDebugEnabled()) {
                LOG.debug("lookup with id '" + id + "' of matchingRule: " + matchingRule);
            }
            return matchingRule;
        }
        throw new NamingException("Unknown MatchingRule OID " + id);
    }

    @Override
    public void register(MatchingRule matchingRule) throws NamingException {
        String[] names;
        if (this.byOid.containsKey(matchingRule.getOid())) {
            throw new NamingException("matchingRule w/ OID " + matchingRule.getOid() + " has already been registered!");
        }
        for (String name : names = matchingRule.getNamesRef()) {
            this.oidRegistry.register(name, matchingRule.getOid());
        }
        this.oidRegistry.register(matchingRule.getOid(), matchingRule.getOid());
        this.byOid.put(matchingRule.getOid(), matchingRule);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registed matchingRule: " + matchingRule);
        }
    }

    @Override
    public boolean hasMatchingRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        MatchingRule mr = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (mr != null) {
            return mr.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "MatchingRule name map!");
    }

    @Override
    public Iterator<MatchingRule> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        this.byOid.remove(numericOid);
    }
}

