/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.add;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequest
extends LdapMessage {
    private static final Logger log = LoggerFactory.getLogger(AddRequest.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private Entry entry = new DefaultClientEntry();
    private EntryAttribute currentAttribute;
    private int addRequestLength;
    private int attributesLength;
    private List<Integer> attributeLength;
    private List<Integer> valuesLength;

    public int getMessageType() {
        return 1;
    }

    public void initEntry() {
        this.entry = new DefaultClientEntry();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public void addAttributeType(String type) throws NamingException {
        if (this.entry.get(type) != null) {
            this.currentAttribute = this.entry.get(type);
            return;
        }
        this.currentAttribute = new DefaultClientAttribute(type);
        this.entry.put(this.currentAttribute);
    }

    public void addAttributeValue(Object value) {
        if (value instanceof String) {
            this.currentAttribute.add((String)value);
        } else {
            this.currentAttribute.add(new byte[][]{(byte[])value});
        }
    }

    public LdapDN getEntryDn() {
        return this.entry.getDn();
    }

    public void setEntryDn(LdapDN entryDn) {
        this.entry.setDn(entryDn);
    }

    public int computeLength() {
        this.addRequestLength = 1 + TLV.getNbBytes(LdapDN.getNbBytes(this.entry.getDn())) + LdapDN.getNbBytes(this.entry.getDn());
        this.attributesLength = 0;
        if (this.entry != null && this.entry.size() != 0) {
            this.attributeLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            for (EntryAttribute attribute : this.entry) {
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getId().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes(idLength) + idLength;
                if (attribute.size() != 0) {
                    localValuesLength = 0;
                    for (Value value : attribute) {
                        int valueLength;
                        if (value instanceof ClientStringValue) {
                            valueLength = StringTools.getBytesUtf8((String)value.get()).length;
                            localValuesLength += 1 + TLV.getNbBytes(valueLength) + valueLength;
                            continue;
                        }
                        valueLength = ((byte[])value.get()).length;
                        localValuesLength += 1 + TLV.getNbBytes(valueLength) + valueLength;
                    }
                    localAttributeLength += 1 + TLV.getNbBytes(localValuesLength) + localValuesLength;
                }
                this.attributesLength += 1 + TLV.getNbBytes(localAttributeLength) + localAttributeLength;
                this.attributeLength.add(localAttributeLength);
                this.valuesLength.add(localValuesLength);
            }
        }
        this.addRequestLength += 1 + TLV.getNbBytes(this.attributesLength) + this.attributesLength;
        int result = 1 + TLV.getNbBytes(this.addRequestLength) + this.addRequestLength;
        if (IS_DEBUG) {
            log.debug("AddRequest PDU length = {}", result);
        }
        return result;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)104);
            buffer.put(TLV.getBytes(this.addRequestLength));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, LdapDN.getBytes(this.entry.getDn()));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.attributesLength));
            if (this.entry != null && this.entry.size() != 0) {
                int attributeNumber = 0;
                for (EntryAttribute attribute : this.entry) {
                    buffer.put((byte)48);
                    int localAttributeLength = this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes(localAttributeLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, attribute.getId());
                    buffer.put((byte)49);
                    int localValuesLength = this.valuesLength.get(attributeNumber);
                    buffer.put(TLV.getBytes(localValuesLength));
                    if (attribute.size() != 0) {
                        for (Value value : attribute) {
                            if (value instanceof ClientBinaryValue) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, (byte[])value.get());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, (String)value.get());
                        }
                    }
                    ++attributeNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        if (IS_DEBUG) {
            log.debug("AddRequest encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            log.debug("AddRequest initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Add Request\n");
        sb.append("        Attributes\n");
        if (this.entry == null) {
            sb.append("            No attributes\n");
        } else {
            sb.append(this.entry);
        }
        return sb.toString();
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }
}

