/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.ldap.codec.search.controls.SubEntryControlCodec;
import org.apache.directory.shared.ldap.codec.search.controls.SubEntryControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.SubEntryControlStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubEntryControlGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(SubEntryControlGrammar.class);
    private static IGrammar instance = new SubEntryControlGrammar();

    private SubEntryControlGrammar() {
        this.name = SubEntryControlGrammar.class.getName();
        this.statesEnum = SubEntryControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[2][256];
        this.transitions[0][1] = new GrammarTransition(0, 1, 1, new GrammarAction("SubEntryControl visibility"){

            public void action(IAsn1Container container) throws DecoderException {
                SubEntryControlContainer subEntryContainer = (SubEntryControlContainer)container;
                SubEntryControlCodec control = new SubEntryControlCodec();
                subEntryContainer.setSubEntryControl(control);
                TLV tlv = subEntryContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    control.setVisibility(BooleanDecoder.parse(value));
                    container.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    log.error("The visibility flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

