/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValue<T>
implements Value<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractValue.class);
    protected T wrapped;
    protected T normalizedValue;
    protected boolean normalized;
    protected Boolean valid;

    @Override
    public void clear() {
        this.wrapped = null;
        this.normalized = false;
        this.normalizedValue = null;
        this.valid = null;
    }

    @Override
    public Value<T> clone() {
        try {
            return (Value)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public T getReference() {
        return this.wrapped;
    }

    @Override
    public T get() {
        return this.getCopy();
    }

    @Override
    public T getNormalizedValue() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return this.getCopy();
        }
        return this.getNormalizedValueCopy();
    }

    @Override
    public T getNormalizedValueReference() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return this.wrapped;
        }
        return this.normalizedValue;
    }

    @Override
    public final boolean isNull() {
        return this.wrapped == null;
    }

    @Override
    public boolean isValid() {
        if (this.valid != null) {
            return this.valid;
        }
        return false;
    }

    @Override
    public final boolean isValid(SyntaxChecker syntaxChecker) throws NamingException {
        if (this.valid != null) {
            return this.valid;
        }
        if (syntaxChecker == null) {
            String message = "Cannot validate " + this.toString() + " with a null SyntaxChecker";
            LOG.error(message);
            throw new NamingException(message);
        }
        this.valid = syntaxChecker.isValidSyntax(this.getReference());
        return this.valid;
    }

    @Override
    public void normalize() throws NamingException {
        this.normalized = true;
        this.normalizedValue = this.wrapped;
    }

    @Override
    public abstract void set(T var1);

    @Override
    public final boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public final void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }
}

