/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Arrays;
import org.apache.directory.shared.ldap.message.AbstractRequest;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindResponse;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class BindRequestImpl
extends AbstractRequest
implements BindRequest {
    static final long serialVersionUID = 7945504184130380071L;
    private LdapDN name;
    private byte[] credentials;
    private int hCredentials = 0;
    private String mechanism;
    private boolean isSimple = true;
    private boolean isVersion3 = true;
    public BindResponse response;

    public BindRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean getSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public byte[] getCredentials() {
        return this.credentials;
    }

    public void setCredentials(byte[] credentials) {
        if (credentials != null) {
            this.credentials = new byte[credentials.length];
            System.arraycopy(credentials, 0, this.credentials, 0, credentials.length);
        } else {
            this.credentials = null;
        }
        if (credentials != null) {
            this.hCredentials = 0;
            for (byte b : credentials) {
                this.hCredentials = this.hCredentials * 31 + b;
            }
        } else {
            this.hCredentials = 0;
        }
    }

    public String getSaslMechanism() {
        return this.mechanism;
    }

    public void setSaslMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    public LdapDN getName() {
        return this.name;
    }

    public void setName(LdapDN name) {
        this.name = name;
    }

    public boolean isVersion3() {
        return this.isVersion3;
    }

    public boolean getVersion3() {
        return this.isVersion3;
    }

    public void setVersion3(boolean isVersion3) {
        this.isVersion3 = isVersion3;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new BindResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BindRequest)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BindRequest req = (BindRequest)obj;
        if (req.isSimple() != this.isSimple()) {
            return false;
        }
        if (req.isVersion3() != this.isVersion3()) {
            return false;
        }
        LdapDN dn1 = req.getName();
        LdapDN dn2 = this.getName();
        if (dn1 == null) {
            if (dn2 != null) {
                return false;
            }
        } else {
            if (dn2 == null) {
                return false;
            }
            if (!dn1.equals(dn2)) {
                return false;
            }
        }
        return Arrays.equals(req.getCredentials(), this.getCredentials());
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + (this.credentials == null ? 0 : this.hCredentials);
        hash = hash * 17 + (this.isSimple ? 0 : 1);
        hash = hash * 17 + (this.isVersion3 ? 0 : 1);
        hash = hash * 17 + (this.mechanism == null ? 0 : this.mechanism.hashCode());
        hash = hash * 17 + (this.name == null ? 0 : this.name.hashCode());
        hash = hash * 17 + (this.response == null ? 0 : this.response.hashCode());
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    BindRequest\n");
        sb.append("        Version : '").append(this.isVersion3 ? "3" : "2").append("'\n");
        if (StringTools.isEmpty(this.name.toString()) && this.isSimple) {
            sb.append("        Name : anonymous\n");
        } else {
            sb.append("        Name : '").append(this.name.toString()).append("'\n");
            if (this.isSimple) {
                sb.append("        Simple authentication : '").append(StringTools.utf8ToString(this.credentials)).append('/').append(StringTools.dumpBytes(this.credentials)).append("'\n");
            } else {
                sb.append("        Sasl credentials\n");
                sb.append("            Mechanism :'").append(this.mechanism).append("'\n");
                if (this.credentials == null) {
                    sb.append("            Credentials : null");
                } else {
                    sb.append("            Credentials : '").append(StringTools.utf8ToString(this.credentials)).append('/').append(StringTools.dumpBytes(this.credentials)).append("'\n");
                }
            }
        }
        return sb.toString();
    }

    public void abandon() {
        throw new UnsupportedOperationException("RFC 2251 [Section 4.11]: Abandon, Bind, Unbind, and StartTLS operations cannot be abandoned. ");
    }
}

