/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEntrySerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ServerEntrySerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private transient Registries registries;

    public ServerEntrySerializer(Registries registries) {
        this.registries = registries;
    }

    public byte[] serialize(Object object) throws IOException {
        DefaultServerEntry entry = (DefaultServerEntry)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        entry.serialize(out);
        out.flush();
        if (IS_DEBUG) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serialize " + entry);
        }
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries);
        try {
            serverEntry.deserialize(in);
            return serverEntry;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Cannot deserialize the entry :" + cnfe.getMessage());
            return null;
        }
    }
}

