/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.message.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;

public class MoveOperationContext
extends AbstractChangeOperationContext {
    private LdapDN parent;

    public MoveOperationContext(CoreSession session) {
        super(session);
    }

    public MoveOperationContext(CoreSession session, LdapDN oldDn, LdapDN parent) {
        super(session, oldDn);
        this.parent = parent;
    }

    public MoveOperationContext(CoreSession session, InternalModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest.getName());
        this.parent = modifyDnRequest.getNewSuperior();
        if (this.parent == null) {
            throw new IllegalArgumentException("The new superior cannot be null for " + modifyDnRequest);
        }
        this.requestControls = modifyDnRequest.getControls();
        if (modifyDnRequest.getNewRdn() != null) {
            throw new IllegalArgumentException(modifyDnRequest + " represents a move and rename operation.");
        }
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public LdapDN getParent() {
        return this.parent;
    }

    public void setParent(LdapDN parent) {
        this.parent = parent;
    }

    public String getName() {
        return MessageTypeEnum.MOD_DN_REQUEST.name();
    }

    public String toString() {
        return "ReplaceContext for old DN '" + this.getDn().getUpName() + "'" + ", parent '" + this.parent + "'";
    }
}

