/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.kerberos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.collective.CollectiveAttributeInterceptor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.referral.ReferralInterceptor;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.TriggerInterceptor;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyDerivationInterceptor
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(KeyDerivationInterceptor.class);
    public static final String NAME = "keyDerivationService";
    private static final Collection<String> USERLOOKUP_BYPASS;

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        LdapDN normName = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        if (entry.get("userPassword") != null && entry.get("krb5PrincipalName") != null) {
            log.debug("Adding the entry '{}' for DN '{}'.", entry, (Object)normName.getUpName());
            ServerBinaryValue userPassword = (ServerBinaryValue)entry.get("userPassword").get();
            String strUserPassword = userPassword.getString();
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("'" + strUserPassword + "' ( ");
                sb.append(userPassword);
                sb.append(" )");
                log.debug("Adding Attribute id : 'userPassword',  Values : [ {} ]", (Object)sb.toString());
            }
            Value<?> principalNameValue = entry.get("krb5PrincipalName").get();
            String principalName = principalNameValue.getString();
            log.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)strUserPassword);
            Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, strUserPassword);
            entry.put("krb5PrincipalName", principalName);
            entry.put("krb5KeyVersionNumber", "0");
            entry.put(this.getKeyAttribute(addContext.getSession().getDirectoryService().getRegistries(), keys));
            log.debug("Adding modified entry '{}' for DN '{}'.", entry, (Object)normName.getUpName());
        }
        next.add(addContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modContext) throws Exception {
        ModifySubContext subContext = new ModifySubContext();
        this.detectPasswordModification(modContext, subContext);
        if (subContext.getUserPassword() != null) {
            this.lookupPrincipalAttributes(modContext, subContext);
        }
        if (subContext.isPrincipal() && subContext.hasValues()) {
            this.deriveKeys(modContext, subContext);
        }
        next.modify(modContext);
    }

    void detectPasswordModification(ModifyOperationContext modContext, ModifySubContext subContext) throws Exception {
        List<Modification> mods = modContext.getModItems();
        String operation = null;
        for (Modification mod : mods) {
            ServerAttribute attr;
            if (log.isDebugEnabled()) {
                switch (mod.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        operation = "Adding";
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        operation = "Removing";
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        operation = "Replacing";
                    }
                }
            }
            if ((attr = (ServerAttribute)mod.getAttribute()).instanceOf("userPassword")) {
                Value<?> firstValue = attr.get();
                String password = null;
                if (firstValue instanceof ServerStringValue) {
                    password = ((ServerStringValue)firstValue).getString();
                    log.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)password);
                } else if (firstValue instanceof ServerBinaryValue) {
                    password = ((ServerBinaryValue)firstValue).getString();
                    if (log.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("'" + password + "' ( ");
                        sb.append(StringTools.dumpBytes(((ServerBinaryValue)firstValue).getBytes()).trim());
                        sb.append(" )");
                        log.debug("{} Attribute id : 'userPassword',  Values : [ {} ]", (Object)operation, (Object)sb.toString());
                    }
                }
                subContext.setUserPassword(password);
                log.debug("Got userPassword '{}'.", (Object)subContext.getUserPassword());
            }
            if (!attr.instanceOf("krb5PrincipalName")) continue;
            subContext.setPrincipalName(attr.getString());
            log.debug("Got principal '{}'.", (Object)subContext.getPrincipalName());
        }
    }

    void lookupPrincipalAttributes(ModifyOperationContext modContext, ModifySubContext subContext) throws Exception {
        EntryAttribute keyVersionNumberAttr;
        LdapDN principalDn = modContext.getDn();
        LookupOperationContext lookupContext = modContext.newLookupContext(principalDn);
        lookupContext.setByPassed(USERLOOKUP_BYPASS);
        lookupContext.setAttrsId(new String[]{"objectClass", "krb5PrincipalName", "krb5KeyVersionNumber"});
        ClonedServerEntry userEntry = modContext.lookup(lookupContext);
        if (userEntry == null) {
            throw new LdapAuthenticationException("Failed to authenticate user '" + principalDn + "'.");
        }
        EntryAttribute objectClass = userEntry.getOriginalEntry().get("objectClass");
        if (!objectClass.contains("krb5Principal")) {
            return;
        }
        subContext.isPrincipal(true);
        log.debug("DN {} is a Kerberos principal.  Will attempt key derivation.", (Object)principalDn.getUpName());
        if (subContext.getPrincipalName() == null) {
            EntryAttribute principalAttribute = userEntry.getOriginalEntry().get("krb5PrincipalName");
            String principalName = principalAttribute.getString();
            subContext.setPrincipalName(principalName);
            log.debug("Found principal '{}' from lookup.", (Object)principalName);
        }
        if ((keyVersionNumberAttr = userEntry.getOriginalEntry().get("krb5KeyVersionNumber")) == null) {
            subContext.setNewKeyVersionNumber(0);
            log.debug("Key version number was null, setting to 0.");
        } else {
            int oldKeyVersionNumber = Integer.valueOf(keyVersionNumberAttr.getString());
            int newKeyVersionNumber = oldKeyVersionNumber + 1;
            subContext.setNewKeyVersionNumber(newKeyVersionNumber);
            log.debug("Found key version number '{}', setting to '{}'.", oldKeyVersionNumber, (Object)newKeyVersionNumber);
        }
    }

    void deriveKeys(ModifyOperationContext modContext, ModifySubContext subContext) throws Exception {
        List<Modification> mods = modContext.getModItems();
        String principalName = subContext.getPrincipalName();
        String userPassword = subContext.getUserPassword();
        int kvno = subContext.getNewKeyVersionNumber();
        log.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
        Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, userPassword);
        ArrayList<Modification> newModsList = new ArrayList<Modification>();
        for (Modification mod : mods) {
            newModsList.add(mod);
        }
        AttributeTypeRegistry atRegistry = modContext.getSession().getDirectoryService().getRegistries().getAttributeTypeRegistry();
        newModsList.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultServerAttribute("krb5PrincipalName", atRegistry.lookup("krb5PrincipalName"), principalName)));
        newModsList.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultServerAttribute("krb5KeyVersionNumber", atRegistry.lookup("krb5KeyVersionNumber"), Integer.toString(kvno))));
        ServerAttribute attribute = this.getKeyAttribute(modContext.getSession().getDirectoryService().getRegistries(), keys);
        newModsList.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute));
        modContext.setModItems(newModsList);
    }

    private ServerAttribute getKeyAttribute(Registries registries, Map<EncryptionType, EncryptionKey> keys) throws Exception {
        DefaultServerAttribute keyAttribute = new DefaultServerAttribute("krb5Key", registries.getAttributeTypeRegistry().lookup("krb5Key"));
        Iterator<EncryptionKey> it = keys.values().iterator();
        while (it.hasNext()) {
            try {
                keyAttribute.add(new byte[][]{EncryptionKeyEncoder.encode(it.next())});
            }
            catch (IOException ioe) {
                log.error("Error encoding EncryptionKey.", ioe);
            }
        }
        return keyAttribute;
    }

    private Map<EncryptionType, EncryptionKey> generateKeys(String principalName, String userPassword) {
        if (userPassword.equalsIgnoreCase("randomKey")) {
            try {
                return RandomKeyFactory.getRandomKeys();
            }
            catch (KerberosException ke) {
                log.debug(ke.getMessage(), ke);
                return null;
            }
        }
        return KerberosKeyFactory.getKerberosKeys(principalName, userPassword);
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(NormalizationInterceptor.class.getName());
        c.add(AuthenticationInterceptor.class.getName());
        c.add(ReferralInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(ExceptionInterceptor.class.getName());
        c.add(OperationalAttributeInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        c.add(SubentryInterceptor.class.getName());
        c.add(CollectiveAttributeInterceptor.class.getName());
        c.add(EventInterceptor.class.getName());
        c.add(TriggerInterceptor.class.getName());
        USERLOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }

    class ModifySubContext {
        private boolean isPrincipal = false;
        private String principalName;
        private String userPassword;
        private int newKeyVersionNumber = -1;

        ModifySubContext() {
        }

        boolean isPrincipal() {
            return this.isPrincipal;
        }

        void isPrincipal(boolean isPrincipal) {
            this.isPrincipal = isPrincipal;
        }

        String getPrincipalName() {
            return this.principalName;
        }

        void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        String getUserPassword() {
            return this.userPassword;
        }

        void setUserPassword(String userPassword) {
            this.userPassword = userPassword;
        }

        int getNewKeyVersionNumber() {
            return this.newKeyVersionNumber;
        }

        void setNewKeyVersionNumber(int newKeyVersionNumber) {
            this.newKeyVersionNumber = newKeyVersionNumber;
        }

        boolean hasValues() {
            return this.userPassword != null && this.principalName != null && this.newKeyVersionNumber > -1;
        }
    }
}

